﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/bgtc/bgtc_StateControlApi.h>
#include "BgtcStub.h"

namespace {
    nn::os::SystemEvent g_StateChangedEvent(nn::os::EventClearMode_AutoClear, false);
    nn::bgtc::State g_State = nn::bgtc::State_Idle;
    bool g_HasTask = false;

    void SetState(nn::bgtc::State newState) NN_NOEXCEPT
    {
        if ( g_State != newState )
        {
            g_State = newState;
            g_StateChangedEvent.Signal();
        }
    }
}

namespace nn { namespace bgtc {

    nn::Result InitializeStateControl() NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    void FinalizeStateControl() NN_NOEXCEPT
    {
    }

    nn::bgtc::State GetState() NN_NOEXCEPT
    {
        return g_State;
    }

    void NotifyEnteringHalfAwake() NN_NOEXCEPT
    {
        // 一度必ず State_Idle 以外に変化する
        SetState(nn::bgtc::State_Processing);

        // タスクがない状態ならすぐ Idle に戻る
        if ( !g_HasTask )
        {
            SetState(nn::bgtc::State_Idle);
        }
    }

    void NotifyLeavingHalfAwake() NN_NOEXCEPT
    {
    }

    nn::os::SystemEvent& GetStateChangedEvent() NN_NOEXCEPT
    {
        return g_StateChangedEvent;
    }

}} // namespace nn::bgtc

// 以下テスト環境専用

namespace nnt { namespace bgtc {

    void SetTaskAvailable(bool hasTask) NN_NOEXCEPT
    {
        if ( g_HasTask != hasTask )
        {
            g_HasTask = hasTask;
            SetState( hasTask ? nn::bgtc::State_Processing : nn::bgtc::State_Idle );
        }
    }

}} // namespace nnt::bgtc
