﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nnt.h>
#include <nnt/nntest.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/bpc/bpc_RtcTypes.h>
#include <nn/bpc/bpc_WakeupConfig.h>
#include <nn/bpc/bpc_WakeupConfigServer.h>
#include <nn/i2c/i2c.h>

#define ARRAY_SIZE(array) (sizeof(array)/sizeof(array[0]))

namespace {
    struct AlarmParam
    {
        int64_t         secondsFromNow; // no matter if absolute or relative
    };

    struct AlarmSleepWakeTestParam
    {
        const AlarmParam*       pAlarmParamList;
        int                     alarmCount;
        bool                    expectedIsEnabled;
        int64_t                 expectedTargetTimeFromNow;
    };

    const AlarmParam AlarmParamNxSetNormal1[] =
    {
        {8LL},
        {5LL},
        {3LL},
    };

    const AlarmSleepWakeTestParam AlarmSleepWakeTestParamNxSet[] =
    {
        {AlarmParamNxSetNormal1, ARRAY_SIZE(AlarmParamNxSetNormal1), true, 3LL},
    };
}

namespace nnt  {

void BpcTestFuncBeforeSleep(int loopCount)
{
    NN_ABORT_UNLESS_RANGE(loopCount, 0, ARRAY_SIZE(AlarmSleepWakeTestParamNxSet));
    auto& param = AlarmSleepWakeTestParamNxSet[loopCount];

    // BPC 初期化
    nn::bpc::InitializeWakeupConfig();

    // タイマーを確保し、テストパラメータに沿ってセットアップ
    std::vector<int> timerHandleList(param.alarmCount);
    for (int i = 0; i < param.alarmCount; ++i)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::bpc::CreateWakeupTimer(
            &timerHandleList[i],
            nn::TimeSpan::FromSeconds(param.pAlarmParamList[i].secondsFromNow),
            nn::bpc::WakeupTimerType_BackgroundTask
            ));
    }
}

void BpcTestFuncAfterWake(int loopCount)
{
    // ウェイク時にすべて無効化されているはず（システムプロセス側の SDK_ASSERT でチェックされている）

    nn::bpc::FinalizeWakeupConfig();
}

} // namespace nnt
