﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include <nn/dd.h>

#include <nnt/nntest.h>

#include "SocthermDumpRegisters.h"

namespace nnt { namespace soctherm {

TEST(SocthermHardwareTest, DumpRegister)
{
    // memory map
    uintptr_t baseAddress = nn::dd::QueryIoMappingAddress(0x700e2000, 0x1000);

    NN_ABORT_UNLESS(baseAddress != 0, "QueryIoMappingAddress failed.\n");

    for ( const auto& socthermRegister : SocthermRegisterList )
    {
        NN_LOG("%s : %08x\n", socthermRegister.name, *(reinterpret_cast<uint32_t*>(baseAddress + socthermRegister.offset)));
    }
}

}} // namespace nnt::soctherm
