﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/oe.h>

#include <nnt/nntest.h>

#include "testOe_DefaultPerformanceConfigurationTest.h"
#include "testOe_Init.h"

namespace nnt { namespace oe {

namespace {

INSTANTIATE_TEST_CASE_P(ConfigInfos, DefaultPerformanceConfigurationTest, ::testing::ValuesIn(DefaultConfigInfoList));

} // namespace

TEST_P(DefaultPerformanceConfigurationTest, CheckFrequencies)
{
    if ( ((nn::oe::GetPerformanceMode() == nn::oe::PerformanceMode_Normal)
        && (GetParam().mode == nn::oe::PerformanceMode_Normal))
        || ((nn::oe::GetPerformanceMode() == nn::oe::PerformanceMode_Boost)
        && (GetParam().mode == nn::oe::PerformanceMode_Boost)) )
    {
        ConfigInfo configInfo = GetParam();
        configInfo.cpuSetting = CpuOverclockSetting;
        CheckFrequencies(configInfo);
    }

    EXPECT_EQ(GetParam().config, nn::oe::GetPerformanceConfiguration(GetParam().mode));
}

}} // namespace nnt::oe
