﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"
#include "testOe_PerformanceConfigurationTest.h"

namespace nnt { namespace oe {

namespace {

INSTANTIATE_TEST_CASE_P(ConfigInfos, PerformanceConfigurationTest, ::testing::ValuesIn(ConfigInfoList));

} // namespace

TEST_P(PerformanceConfigurationTest, SetConfigAndCheckFrequencies)
{
    SetConfigAndCheckFrequencies(GetParam());
}

TEST_P(PerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnNormal)
{
    SetConfigAndCheckFrequenciesOnNormal(GetParam());
}

TEST_P(PerformanceConfigurationTest, SetConfigAndCheckFrequenciesOnBoost)
{
    SetConfigAndCheckFrequenciesOnBoost(GetParam());
}

TEST_P(PerformanceConfigurationTest, SetDeathConfigAndCheckFrequencies)
{
    SetDeathConfigAndCheckFrequencies(GetParam());
}

TEST_P(PerformanceConfigurationTest, SetDeathConfigAndCheckFrequenciesOnNormal)
{
    SetDeathConfigAndCheckFrequenciesOnNormal(GetParam());
}

TEST_P(PerformanceConfigurationTest, SetDeathConfigAndCheckFrequenciesOnBoost)
{
    SetConfigAndCheckFrequenciesOnBoost(GetParam());
}

}} // namespace nnt::oe
