﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>

#include <nn/nifm/nifm_Api.h>

#include <nn/pctl/pctl_Api.h>
#include <nn/pctl/pctl_ApiSnsPost.h>
#include <nn/pctl/pctl_ApiStereoVision.h>
#include <nn/account.h>

#include <nn/util/util_ScopeExit.h>

#include "../Common/testPctl_TestUtil.h"


class DummyApplicationTest : public ::testing::Test
{
protected:
    static void SetUpTestCase()
    {
        nn::account::Initialize();
    }

    static void TearDownTestCase()
    {
    }
};

TEST_F(DummyApplicationTest, Basic)
{
    int count;
    nn::account::Uid users[nn::account::UserCountMax];
    NNT_ASSERT_RESULT_SUCCESS(nn::account::ListAllUsers(&count, users, NN_ARRAY_SIZE(users)));
    ASSERT_GT(count, 0);

    nn::account::UserHandle handle;
    NNT_ASSERT_RESULT_SUCCESS(nn::account::OpenUser(&handle, users[0]));
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(10));

    NN_UTIL_SCOPE_EXIT
    {
        nn::account::CloseUser(handle);

        const int sleepTotal = 60;
        for (int i = 0; i < sleepTotal; i += 10)
        {
            nn::os::SleepThread(nn::TimeSpan::FromSeconds(10));
            NN_LOG("Sleep %d/%d\n", i + 10, sleepTotal);
        }
    };

    EXPECT_FALSE(nn::pctl::CheckFreeCommunicationPermission(false));
    NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultSnsPostRestricted, nn::pctl::ConfirmSnsPostPermission());
    //NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultStereoVisionRestricted, nn::pctl::ConfirmStereoVisionPermission());
}

