﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/nn_TimeSpan.h>

namespace nnt { namespace os { namespace detail {

#define INVALID_HANDLE  (nn::svc::Handle(0))

//-----------------------------------------------------------------------------

enum Command
{
    Command_DelayedSignal = 0,
    Command_Shutdown,
};

//-----------------------------------------------------------------------------

class DelayedSystemEventServer
{
public:
    // コンストラクタ で遅延シグナル用スレッドを生成し、
    // デストラクタ   で遅延シグナル用スレッドを削除する。
    explicit DelayedSystemEventServer(nn::os::SystemEventType* event) NN_NOEXCEPT;
    ~DelayedSystemEventServer()                                   NN_NOEXCEPT;

    // 遅延シグナル要求
    void RequireDelayedSignal(nn::TimeSpan span) NN_NOEXCEPT
    {
        nn::os::SendMessageQueue( &m_Queue, Command_DelayedSignal );
        nn::os::SendMessageQueue( &m_Queue,
                    static_cast<uintptr_t>(span.GetNanoSeconds()) );
    }

    // サーバスレッドの本体
    void ServerThreadImpl() NN_NOEXCEPT;

private:
    nn::os::SystemEventType*    m_SystemEvent;
    nn::os::ThreadType          m_ServerThread;
    nn::os::MessageQueueType    m_Queue;
};

//-----------------------------------------------------------------------------

}}} // namespace nnt::os::detail

