﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Windows.h>
#include <nn/os/os_Types.h>

namespace nnt { namespace os { namespace detail {

void CreateUniqueInterruptName(char* portName, size_t size) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

class NamedPipeServerImplByWin32
{
public:
    // コンストラクタ と デストラクタ
    explicit NamedPipeServerImplByWin32(const char* portName)  NN_NOEXCEPT;
    ~NamedPipeServerImplByWin32() NN_NOEXCEPT;

    // 接続と解除
    void        Connect()    NN_NOEXCEPT;
    void        Disconnect() NN_NOEXCEPT;

    // サーバ側はハンドルを受信して、返値を返す
    void                 ReplyValue(uint32_t value)                 NN_NOEXCEPT;
    nn::os::NativeHandle RecvHandle()                               NN_NOEXCEPT;
    void                 DestroyHandle(nn::os::NativeHandle handle) NN_NOEXCEPT;

private:
    HANDLE      m_Handle;
};

typedef NamedPipeServerImplByWin32    NamedPipeServer;

//-----------------------------------------------------------------------------

class NamedPipeClientImplByWin32
{
public:
    // コンストラクタ と デストラクタ
    explicit NamedPipeClientImplByWin32(const char* portName)  NN_NOEXCEPT;
    ~NamedPipeClientImplByWin32() NN_NOEXCEPT;

    // クライアント側はハンドルを送信して、返値を受取る
    void     SendHandle(int cmd, nn::os::NativeHandle handle) NN_NOEXCEPT;
    uint32_t RecvValue()                                      NN_NOEXCEPT;

private:
    HANDLE      m_Handle;
};

typedef NamedPipeClientImplByWin32    NamedPipeClient;

//-----------------------------------------------------------------------------

}}} // namespace nnt::os::detail

