﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_Types.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_HardwareParamsSelect.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Server.h>
#include <nn/svc/svc_Result.h>


namespace nnt { namespace os { namespace detail {

#define INVALID_HANDLE  (nn::svc::Handle(0))

//-----------------------------------------------------------------------------

static const size_t PortNameLengthMax = 12;

class NamedPipeServerImplByHorizon
{
public:
    // コンストラクタ と デストラクタ
    explicit NamedPipeServerImplByHorizon(const char* portName) NN_NOEXCEPT;
    ~NamedPipeServerImplByHorizon() NN_NOEXCEPT;

    // 接続と解除
    void        Connect()    NN_NOEXCEPT;
    void        Disconnect() NN_NOEXCEPT;

    // サーバ側はハンドルを受信して、返値を返す
    void                 ReplyValue(uint32_t value)                 NN_NOEXCEPT;
    nn::os::NativeHandle RecvHandle()                               NN_NOEXCEPT;
    void                 DestroyHandle(nn::os::NativeHandle handle) NN_NOEXCEPT;

private:
    char                m_PortName[PortNameLengthMax];
    nn::svc::Handle     m_Port;
    nn::svc::Handle     m_Session;
};

typedef NamedPipeServerImplByHorizon    NamedPipeServer;

//-----------------------------------------------------------------------------

class NamedPipeClientImplByHorizon
{
public:
    // コンストラクタ と デストラクタ
    explicit NamedPipeClientImplByHorizon(const char* portName) NN_NOEXCEPT;
    ~NamedPipeClientImplByHorizon() NN_NOEXCEPT;

    // クライアント側はハンドルを送信して、返値を受取る
    void     SendHandle(int cmd, nn::os::NativeHandle handle) NN_NOEXCEPT;
    uint32_t RecvValue()                                      NN_NOEXCEPT;

private:
    nn::svc::Handle     m_Session;
};

typedef NamedPipeClientImplByHorizon    NamedPipeClient;

//-----------------------------------------------------------------------------

}}} // namespace nnt::os::detail

