﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"
#include "../Common/test_Helper.h"

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkText.h>
#include <nn/os.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>

namespace nnt { namespace os { namespace argument {

//-----------------------------------------------------------------------------
//  コマンドライン引数関連のテスト
//-----------------------------------------------------------------------------

namespace {

}   // namespace

TEST(PrintAllArgv, test_PrintAllArgv)
{
    auto argc = nn::os::GetHostArgc();
    auto argv = nn::os::GetHostArgv();

    // とりあえず受け取った引数をログに出しておく
    for (int i = 0; i < argc; ++i)
    {
        NN_LOG("argv[%d]=\x22%s\x22\n", i, argv[i]);
    }
}

TEST(ArgvNullTerminatedTest, test_ArgvNullTerminated)
{
    auto argc = nn::os::GetHostArgc();
    auto argv = nn::os::GetHostArgv();

    // argc は常に 1 以上を返す
    // コマンドライン引数がなかった場合は、argc=1, argv[0][0] == '\0' となる。
    NNT_OS_LOG("argc = %d\n", argc);
    EXPECT_TRUE( argc > 0 );

    // argv が NULL 終端されているかをチェック
    NNT_OS_LOG(NN_TEXT("argv は NULL 終端されているか？ ... "));
    bool ret = (argv[ argc ] == NULL);
    NNT_OS_LOG( ret ? "Yes\n" : "No\n");
    EXPECT_EQ( ret, true );
}

//-----------------------------------------------------------------------------

}}} // namespace nnt::os::argument

