﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

#include <nn/http/json/http_RapidJsonApi.h>
#include <nn/http/json/http_JsonErrorMap.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>

#include <nn/fs/fs_SaveDataTransferVersion2.h>

#include <olsc_KeySeedPackageAdaptor.h>
#include <olsc_OutputStream.h>

#include "testOlsc_InputStream.h"
#include "testOlsc_SaveDataUtil.h"

using namespace nn;
using namespace nn::olsc;

namespace mixed_Info_success {

const char KeySeedPackageSimpleString[] =
"{"
    "\"encoded_key_seed_package\" : \"AAAAAAAAAAAAAAAAAAAAANYVfbl8Iqq5AB8jichGbeYutAo_0g3jjhiMJqOjfC8MAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5fy1pN0O1OtAvL7nFkCiiqlnUzUF3QjnqgxPfOSRKibOElP90MRdv7tJxjHHYwIKUjBK9SnXXlrqGneQYeU4Fe26ZftdJVm7kV_y_ctbDIaoTzGujrEs_fM0hTwa7BJFN6dzFMRKyq-jhN37BKL8f1HJ59ruAH9Bf5zoWJLkCKvHloRuNolZ3VuXTywvlpDzn83pBXl0f-p8r_djrWE8I1YNrwC8WuZHMXWei9fFElCoU-j1QV3HBCKVrZg5kDb5nRFN3_52UN1Bqhm3S6tWEKlIy4BqFOSSygCpl85Cd-6fiN8hCkQ8Lgwv2WHqSVGNNv6tobgTIG11Hs12m1_lFqmmzc8p3sAY-JJIVAg9yVLyGiY5-i9IYiRoEkj0FllMOWueMvM3G7YgbptYzbAsh2xbNe_kwFCuxbbL-bNxvcCELX7ywKqcEtUH-8dtsRc6hR3LJ-2wE85yAkoiS372r3YW4yF0lnLfaqkvNVB7fJwKFV7LpuTpU7LyOmJLC9TE=\""
"}";

struct Cancelable
{
    bool IsCancelled() const { return false; }
};

const Bit8 ExpectedKsp[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xd6, 0x15, 0x7d, 0xb9, 0x7c, 0x22, 0xaa, 0xb9, 0x00, 0x1f, 0x23, 0x89, 0xc8, 0x46, 0x6d, 0xe6,
    0x2e, 0xb4, 0x0a, 0x3f, 0xd2, 0x0d, 0xe3, 0x8e, 0x18, 0x8c, 0x26, 0xa3, 0xa3, 0x7c, 0x2f, 0x0c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x79, 0x7f, 0x2d, 0x69, 0x37, 0x43, 0xb5, 0x3a, 0xd0, 0x2f, 0x2f, 0xb9, 0xc5, 0x90, 0x28, 0xa2,
    0xaa, 0x59, 0xd4, 0xcd, 0x41, 0x77, 0x42, 0x39, 0xea, 0x83, 0x13, 0xdf, 0x39, 0x24, 0x4a, 0x89,
    0xb3, 0x84, 0x94, 0xff, 0x74, 0x31, 0x17, 0x6f, 0xee, 0xd2, 0x71, 0x8c, 0x71, 0xd8, 0xc0, 0x82,
    0x94, 0x8c, 0x12, 0xbd, 0x4a, 0x75, 0xd7, 0x96, 0xba, 0x86, 0x9d, 0xe4, 0x18, 0x79, 0x4e, 0x05,
    0x7b, 0x6e, 0x99, 0x7e, 0xd7, 0x49, 0x56, 0x6e, 0xe4, 0x57, 0xfc, 0xbf, 0x72, 0xd6, 0xc3, 0x21,
    0xaa, 0x13, 0xcc, 0x6b, 0xa3, 0xac, 0x4b, 0x3f, 0x7c, 0xcd, 0x21, 0x4f, 0x06, 0xbb, 0x04, 0x91,
    0x4d, 0xe9, 0xdc, 0xc5, 0x31, 0x12, 0xb2, 0xab, 0xe8, 0xe1, 0x37, 0x7e, 0xc1, 0x28, 0xbf, 0x1f,
    0xd4, 0x72, 0x79, 0xf6, 0xbb, 0x80, 0x1f, 0xd0, 0x5f, 0xe7, 0x3a, 0x16, 0x24, 0xb9, 0x02, 0x2a,
    0xf1, 0xe5, 0xa1, 0x1b, 0x8d, 0xa2, 0x56, 0x77, 0x56, 0xe5, 0xd3, 0xcb, 0x0b, 0xe5, 0xa4, 0x3c,
    0xe7, 0xf3, 0x7a, 0x41, 0x5e, 0x5d, 0x1f, 0xfa, 0x9f, 0x2b, 0xfd, 0xd8, 0xeb, 0x58, 0x4f, 0x08,
    0xd5, 0x83, 0x6b, 0xc0, 0x2f, 0x16, 0xb9, 0x91, 0xcc, 0x5d, 0x67, 0xa2, 0xf5, 0xf1, 0x44, 0x94,
    0x2a, 0x14, 0xfa, 0x3d, 0x50, 0x57, 0x71, 0xc1, 0x08, 0xa5, 0x6b, 0x66, 0x0e, 0x64, 0x0d, 0xbe,
    0x67, 0x44, 0x53, 0x77, 0xff, 0x9d, 0x94, 0x37, 0x50, 0x6a, 0x86, 0x6d, 0xd2, 0xea, 0xd5, 0x84,
    0x2a, 0x52, 0x32, 0xe0, 0x1a, 0x85, 0x39, 0x24, 0xb2, 0x80, 0x2a, 0x65, 0xf3, 0x90, 0x9d, 0xfb,
    0xa7, 0xe2, 0x37, 0xc8, 0x42, 0x91, 0x0f, 0x0b, 0x83, 0x0b, 0xf6, 0x58, 0x7a, 0x92, 0x54, 0x63,
    0x4d, 0xbf, 0xab, 0x68, 0x6e, 0x04, 0xc8, 0x1b, 0x5d, 0x47, 0xb3, 0x5d, 0xa6, 0xd7, 0xf9, 0x45,
    0xaa, 0x69, 0xb3, 0x73, 0xca, 0x77, 0xb0, 0x06, 0x3e, 0x24, 0x92, 0x15, 0x02, 0x0f, 0x72, 0x54,
    0xbc, 0x86, 0x89, 0x8e, 0x7e, 0x8b, 0xd2, 0x18, 0x89, 0x1a, 0x04, 0x92, 0x3d, 0x05, 0x96, 0x53,
    0x0e, 0x5a, 0xe7, 0x8c, 0xbc, 0xcd, 0xc6, 0xed, 0x88, 0x1b, 0xa6, 0xd6, 0x33, 0x6c, 0x0b, 0x21,
    0xdb, 0x16, 0xcd, 0x7b, 0xf9, 0x30, 0x14, 0x2b, 0xb1, 0x6d, 0xb2, 0xfe, 0x6c, 0xdc, 0x6f, 0x70,
    0x21, 0x0b, 0x5f, 0xbc, 0xb0, 0x2a, 0xa7, 0x04, 0xb5, 0x41, 0xfe, 0xf1, 0xdb, 0x6c, 0x45, 0xce,
    0xa1, 0x47, 0x72, 0xc9, 0xfb, 0x6c, 0x04, 0xf3, 0x9c, 0x80, 0x92, 0x88, 0x92, 0xdf, 0xbd, 0xab,
    0xdd, 0x85, 0xb8, 0xc8, 0x5d, 0x25, 0x9c, 0xb7, 0xda, 0xaa, 0x4b, 0xcd, 0x54, 0x1e, 0xdf, 0x27,
    0x02, 0x85, 0x57, 0xb2, 0xe9, 0xb9, 0x3a, 0x54, 0xec, 0xbc, 0x8e, 0x98, 0x92, 0xc2, 0xf5, 0x31
};

TEST(OlscJsonAdaptorTest, KeySeedPackageSuccess)
{
    auto uid = nnt::olsc::GetFirstUserId();
    nn::fs::DeleteSystemSaveData(nnt::olsc::SystemSaveDataIdForTest, uid);

    olsc::srv::adaptor::KeySeedPackageAdaptor adaptor;

    nnt::olsc::MemoryInputStreamForRapidJson inputStream;
    inputStream.Set(KeySeedPackageSimpleString, sizeof(KeySeedPackageSimpleString));

    const Cancelable c;
    NNT_EXPECT_RESULT_SUCCESS(http::json::ImportJsonByRapidJson<http::json::DefaultJsonErrorMap>(adaptor, inputStream, &c));
    NNT_EXPECT_RESULT_SUCCESS(adaptor.GetResult());

    fs::SaveDataTransferManagerVersion2::KeySeedPackage ksp;
    NNT_EXPECT_RESULT_SUCCESS(adaptor.GetKeySeedPackage(&ksp));

    EXPECT_EQ(0, std::memcmp(ExpectedKsp, ksp.data, fs::SaveDataTransferManagerVersion2::KeySeedPackage::Size));
}

} // namespace mixed_info_success

namespace mixed_info_fail {
    const int JsonLen = 2048;

    const char InvalidSize[][JsonLen] =
    {
        "{"
            "\"encoded_key_seed_package\" : \"AAAAAAAAAAAAAAAAAAAAAANYVfbl8Iqq5AB8jichGbeYutAo_0g3jjhiMJqOjfC8MAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5fy1pN0O1OtAvL7nFkCiiqlnUzUF3QjnqgxPfOSRKibOElP90MRdv7tJxjHHYwIKUjBK9SnXXlrqGneQYeU4Fe26ZftdJVm7kV_y_ctbDIaoTzGujrEs_fM0hTwa7BJFN6dzFMRKyq-jhN37BKL8f1HJ59ruAH9Bf5zoWJLkCKvHloRuNolZ3VuXTywvlpDzn83pBXl0f-p8r_djrWE8I1YNrwC8WuZHMXWei9fFElCoU-j1QV3HBCKVrZg5kDb5nRFN3_52UN1Bqhm3S6tWEKlIy4BqFOSSygCpl85Cd-6fiN8hCkQ8Lgwv2WHqSVGNNv6tobgTIG11Hs12m1_lFqmmzc8p3sAY-JJIVAg9yVLyGiY5-i9IYiRoEkj0FllMOWueMvM3G7YgbptYzbAsh2xbNe_kwFCuxbbL-bNxvcCELX7ywKqcEtUH-8dtsRc6hR3LJ-2wE85yAkoiS372r3YW4yF0lnLfaqkvNVB7fJwKFV7LpuTpU7LyOmJLC9TE=\""
        "}",
        "{"
            "\"encoded_key_seed_package\" : \"AAAAAAAAAAAAAAAAAAAAAANYVfbl8Iqq5AB8jichGbeYutAo_0g3jjhiMJqOjfC8MAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5fy1pN0O1OtAvL7nFkCiiqlnUzUF3QjnqgxPfOSRKibOElP90MRdv7tJxjHHYwIKUjBK9SnXXlrqGneQYeU4Fe26ZftdJVm7kV_y_ctbDIaoTzGujrEs_fM0hTwa7BJFN6dzFMRKyq-jhN37BKL8f1HJ59ruAH9Bf5zoWJLkCKvHloRuNolZ3VuXTywvlpDzn83pBXl0f-p8r_djrWE8I1YNrwC8WuZHMXWei9fFElCoU-j1QV3HBCKVrZg5kDb5nRFN3_52UN1Bqhm3S6tWEKlIy4BqFOSSygCpl85Cd-6fiN8hCkQ8Lgwv2WHqSVGNNv6tobgTIG11Hs12m1_lFqmmzc8p3sAY-JJIVAg9yVLyGiY5-i9IYiRoEkj0FllMOWueMvM3G7YgbptYzbAsh2xbNe_kwFCuxbbL-bNxvcCELX7ywKqcEtUH-8dtsRc6hR3LJ-2wE85yAkoiS372r3YW4yF0lnLfaqkvNVB7fJwKFV7LpuTpU7LyOmJLC9TE=\","
            "\"encoded_key_seed_package\" : \"AAAAAAAAAAAAAAAAAAAAANYVfbl8Iqq5AB8jichGbeYutAo_0g3jjhiMJqOjfC8MAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5fy1pN0O1OtAvL7nFkCiiqlnUzUF3QjnqgxPfOSRKibOElP90MRdv7tJxjHHYwIKUjBK9SnXXlrqGneQYeU4Fe26ZftdJVm7kV_y_ctbDIaoTzGujrEs_fM0hTwa7BJFN6dzFMRKyq-jhN37BKL8f1HJ59ruAH9Bf5zoWJLkCKvHloRuNolZ3VuXTywvlpDzn83pBXl0f-p8r_djrWE8I1YNrwC8WuZHMXWei9fFElCoU-j1QV3HBCKVrZg5kDb5nRFN3_52UN1Bqhm3S6tWEKlIy4BqFOSSygCpl85Cd-6fiN8hCkQ8Lgwv2WHqSVGNNv6tobgTIG11Hs12m1_lFqmmzc8p3sAY-JJIVAg9yVLyGiY5-i9IYiRoEkj0FllMOWueMvM3G7YgbptYzbAsh2xbNe_kwFCuxbbL-bNxvcCELX7ywKqcEtUH-8dtsRc6hR3LJ-2wE85yAkoiS372r3YW4yF0lnLfaqkvNVB7fJwKFV7LpuTpU7LyOmJLC9TE=\""
        "}"
    };

    const char InvalidField[][JsonLen] =
    {
        "{"
            "\"encoded_key_seed_packagea\" : \"AAAAAAAAAAAAAAAAAAAANYVfbl8Iqq5AB8jichGbeYutAo_0g3jjhiMJqOjfC8MAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5fy1pN0O1OtAvL7nFkCiiqlnUzUF3QjnqgxPfOSRKibOElP90MRdv7tJxjHHYwIKUjBK9SnXXlrqGneQYeU4Fe26ZftdJVm7kV_y_ctbDIaoTzGujrEs_fM0hTwa7BJFN6dzFMRKyq-jhN37BKL8f1HJ59ruAH9Bf5zoWJLkCKvHloRuNolZ3VuXTywvlpDzn83pBXl0f-p8r_djrWE8I1YNrwC8WuZHMXWei9fFElCoU-j1QV3HBCKVrZg5kDb5nRFN3_52UN1Bqhm3S6tWEKlIy4BqFOSSygCpl85Cd-6fiN8hCkQ8Lgwv2WHqSVGNNv6tobgTIG11Hs12m1_lFqmmzc8p3sAY-JJIVAg9yVLyGiY5-i9IYiRoEkj0FllMOWueMvM3G7YgbptYzbAsh2xbNe_kwFCuxbbL-bNxvcCELX7ywKqcEtUH-8dtsRc6hR3LJ-2wE85yAkoiS372r3YW4yF0lnLfaqkvNVB7fJwKFV7LpuTpU7LyOmJLC9TE=\""
        "}",
        "{"
        "}"
    };

struct Cancelable
{
    bool IsCancelled() const { return false; }
};

template<typename ExpectResultType>
void TestImpl(const char json[])
{
    auto uid = nnt::olsc::GetFirstUserId();
    nn::fs::DeleteSystemSaveData(nnt::olsc::SystemSaveDataIdForTest, uid);


    olsc::srv::adaptor::KeySeedPackageAdaptor adaptor;

    nnt::olsc::MemoryInputStreamForRapidJson inputStream;
    inputStream.Set(json, JsonLen);

    const Cancelable c;
    NNT_EXPECT_RESULT_SUCCESS(http::json::ImportJsonByRapidJson<http::json::DefaultJsonErrorMap>(adaptor, inputStream, &c));
    NNT_EXPECT_RESULT_FAILURE(ExpectResultType, adaptor.GetResult());
}

template<typename ExpectResultType>
void RunTest(const char json[][JsonLen], int count)
{
    for (int i = 0; i < count; ++i)
    {
        TestImpl<ExpectResultType>(json[i]);
    }
}

TEST(OlscJsonAdaptorTest, KeySeedPackageFail)
{
    RunTest<olsc::ResultKeySeedPackageUnacceptableContent>(InvalidSize, sizeof(InvalidSize) / JsonLen);
    RunTest<olsc::ResultKeySeedPackageUnacceptableContent>(InvalidField, sizeof(InvalidField) / JsonLen);
}
}
