﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_ApiForTest.h>
#include "./testNsd_Constant.h"

#include <nn/nsd/nsd_ApiForMiddleware.h>
#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/nsd_ApiForNasService.h>
#include <nn/nsd/nsd_ApiForNasServicePrivate.h>

#include <nn/nn_SdkLog.h>
#if NN_BUILD_CONFIG_OS_WIN

// Windows.h マクロと衝突しないかの確認

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#endif // NN_BUILD_CONFIG_OS_WIN

using namespace nn::nsd;

//
// これらのテストは、何も設定がインポートされてない状態が前提となっています。
//
TEST(NsdTest_ForNoSaveTest, GetSettingName)
{
    nn::nsd::SettingName settingName;
    NNT_EXPECT_RESULT_FAILURE( nn::nsd::ResultNotFound, nn::nsd::GetSettingName(&settingName) );
    // 返ってくる settingName は不定
}

TEST(NsdTest_ForNoSaveTest, GetEnvironmentIdentifier)
{
    nn::nsd::EnvironmentIdentifier identifier;
    nn::nsd::GetEnvironmentIdentifier(&identifier); // void 関数
    EXPECT_STREQ( identifier.value, "dd1" ); // TODO: とりあえず dd1
}

// ビルトイン設定の Nas の直接取得
TEST(NsdTest_ForNoSaveTest, NasFqdn1)
{
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasApiFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasApiFqdn.value, fqdn.value);
    }
    {
        nn::nsd::Fqdn fqdn;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasRequestFqdn(&fqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasRequestFqdn.value, fqdn.value);
    }
}

// ビルトイン設定を用いた Nas FQDN Resulve
TEST(NsdTest_ForNoSaveTest, NasFqdn2)
{
    // dd1 FQDN を入れて dd1 FQDN のままか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::Resolve(&out, nnt::nsd::constant::Dd1.nasApiFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasApiFqdn.value, out.value);
    }
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Dd1.nasRequestFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasRequestFqdn.value, out.value);
    }
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Dd1.baasFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.baasFqdn.value, out.value);
    }

    // baas: lp1 FQDN を入れて dd1 FQDN になるか
    {
        nn::nsd::Fqdn out;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::ResolveEx(&out, nnt::nsd::constant::Lp1.baasFqdn));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.baasFqdn.value, out.value);
    }
}

// NasService の取得
TEST(NsdTest_ForNoSaveTest, NasService)
{
    // ビルトイン設定を取得して dd1 のものと等しいか確認
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxAccount));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxShop));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxFriends));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxFriends.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxFriends.clientId, setting.clientId);
    }
    {
        nn::nsd::NasServiceSetting setting;
        NNT_EXPECT_RESULT_SUCCESS(nn::nsd::GetNasServiceSetting(&setting, nn::nsd::NasServiceNameOfNxELicense));
        EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxELicense.redirectUri.value, setting.redirectUri.value);
        EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxELicense.clientId, setting.clientId);
    }
}

