﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_ApiForNasService.h>
#include <nn/nsd/nsd_ApiForNasServicePrivate.h>
#include "./testNsd_Constant.h"

#if NN_BUILD_CONFIG_OS_WIN

// Windows.h マクロと衝突しないかの確認

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#include <nn/nn_Log.h>

#endif // NN_BUILD_CONFIG_OS_WIN

using namespace nn::nsd;

//
// 何も設定がインポートされてない状態で、
// 製品機でない dd1 が環境識別子になる前提のテスト
//

TEST(NsdTest_ForNasService, GetNasRequestFqdn)
{
    Fqdn out;
    NNT_ASSERT_RESULT_SUCCESS(GetNasRequestFqdn(&out));
    // dd1 固定
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasRequestFqdn.value, out.value);
}

TEST(NsdTest_ForNasService, GetNasRequestFqdnEx)
{
    Fqdn out;
    GetNasRequestFqdnEx(&out);
    // dd1 固定
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasRequestFqdn.value, out.value);
}

TEST(NsdTest_ForNasService, GetNasApiFqdn)
{
    Fqdn out;
    NNT_ASSERT_RESULT_SUCCESS(GetNasApiFqdn(&out));

    // dd1 固定
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasApiFqdn.value, out.value);
}

TEST(NsdTest_ForNasService, GetNasApiFqdnEx)
{
    Fqdn out;
    GetNasApiFqdnEx(&out);

    // dd1 固定
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasApiFqdn.value, out.value);
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNxAccount1)
{
    NasServiceSetting setting;
    NNT_EXPECT_RESULT_SUCCESS(GetNasServiceSetting(&setting, NasServiceNameOfNxAccount));

    // dd1 固定
    EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.clientId, setting.clientId);
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.redirectUri.value, setting.redirectUri.value);
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNxAccount2)
{
    NasServiceSetting setting;
    GetNasServiceSettingEx(&setting, NasServiceNameOfNxAccount);

    // dd1 固定
    EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.clientId, setting.clientId);
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxAccount.redirectUri.value, setting.redirectUri.value);
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNxShop1)
{
    NasServiceSetting setting;
    NNT_EXPECT_RESULT_SUCCESS(GetNasServiceSetting(&setting, NasServiceNameOfNxShop));

    // dd1 固定
    EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.clientId, setting.clientId);
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.redirectUri.value, setting.redirectUri.value);
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNxShop2)
{
    NasServiceSetting setting;
    GetNasServiceSettingEx(&setting, NasServiceNameOfNxShop);

    // dd1 固定
    EXPECT_EQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.clientId, setting.clientId);
    EXPECT_STREQ(nnt::nsd::constant::Dd1.nasServiceSettingOfNxShop.redirectUri.value, setting.redirectUri.value);
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNotFound1)
{
    NasServiceSetting setting;
    const NasServiceName name = {"invalid"};

    NNT_ASSERT_RESULT_FAILURE(nn::nsd::ResultNotFound,
        GetNasServiceSetting(&setting, name));
}

TEST(NsdTest_ForNasService, GetNasServiceSettingNotFound2)
{
    NasServiceSetting setting;
    const NasServiceName name = {"invalid"};

    GetNasServiceSettingEx(&setting, name);

    EXPECT_EQ(nnt::nsd::constant::InvalidNasServiceSetting.clientId, setting.clientId);
    EXPECT_STREQ(nnt::nsd::constant::InvalidNasServiceSetting.redirectUri.value, setting.redirectUri.value);

}

// TODO: 他のNASサービスのテスト
// TODO: 異常系テスト
