﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/nn_Result.h>

namespace testns {

//!--------------------------------------------------------------------------------------
//! @brief ホストPCのファイルシステムマウント
//! @details 実行時の引数からマウント先を指定します。
//! 引数にマウント先がなければマウントしません。
//! RunOnTarget.exe *.nsp "--testns_MountHost=path"
//!--------------------------------------------------------------------------------------
nn::Result MountHostFileSystem( const char* mountVolumeName ) NN_NOEXCEPT;

//!--------------------------------------------------------------------------------------
//! @brief ホストPCのファイルシステムアンマウント
//!--------------------------------------------------------------------------------------
void UnmountHostFileSystem() NN_NOEXCEPT;

//!--------------------------------------------------------------------------------------
//! @brief ホストPCマウントボリュームのスキーム付きパスを生成
//! @param pOutValue        マウントスキームを付与したフルパス。
//!                         MountHostFileSystem() で指定したマウントボリューム + ':' + ファイルパス + '\0' 分のバッファサイズが必要です。
//! @param pExpectFilePath  '/' をマウントルートとしたマウントスキームを除外したファイルパス。
//! @return     成功した場合 trueが返されます。@n
//!             マウントされていないなど、ホストファイルアクセスが出来ない場合は false が返されます。
//!
//! @details MakeHostFileSystemPath( outValue, "/filename.txt" ) とした場合、
//! outValue には、"Scheme:/filename.txt" が生成されます。
//!--------------------------------------------------------------------------------------
const bool MakeHostFileSystemPath( char* pOutValue, const char* pExpectFilePath ) NN_NOEXCEPT;

//!--------------------------------------------------------------------------------------
//! @brief ホストPCマウントボリュームの取得
//! @param pOutValue    マウントボリューム文字列を格納するバッファ。
//!                     MountHostFileSystem() で指定したマウントボリューム + '\0' 分のバッファサイズが必要です。
//!
//! @return     成功した場合 trueが返されます。@n
//!             マウントされていないなど、ホストファイルアクセスが出来ない場合は false が返されます。
//!--------------------------------------------------------------------------------------
const bool GetMountedHostFileSystemVolume( char* pOutValue ) NN_NOEXCEPT;

} // namespace testns
