﻿<#
    .SYNOPSIS
        Private utilities module

    .DESCRIPTION
        This file defines functions for private operations
#>

# 基本パス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)

# 指定パス文字列を完全なフルパス形式に修正する
function Get-AbsoluteFullPath( [string]$defSourcePathString )
{
    if ( $(Test-Path ${defSourcePathString} -IsValid) )
    {
        [System.IO.FileInfo] $defInfo = New-Object System.IO.FileInfo ${defSourcePathString}
        return [string] $defInfo.FullName
    }
    throw "${defSourcePathString} is invalid path string."
}
Export-ModuleMember -Function Get-AbsoluteFullPath

# ファイル存在確認
function Test-ExistFile( [string]$defSourceFile )
{
    if ( -not $(Test-Path ${defSourceFile}) )
    {
        $message = "${defSourceFile} not found"
        throw New-Object "System.IO.FileNotFoundException" $message
    }
}
Export-ModuleMember -Function Test-ExistFile

# ファイル削除
function Remove-ExistFile( [string]$defSourceFile )
{
    if ( $(Test-Path ${defSourceFile}) )
    {
        Remove-Item ${defSourceFile} | Out-Null
    }
}
Export-ModuleMember -Function Remove-ExistFile

# ファイル名称変更
function Edit-RenameFile( [string]$defSourceFile, [string]$defDestinationFile )
{
    if ( $(Test-Path ${defSourceFile}) )
    {
        if ( $(Test-Path ${defDestinationFile}) )
        {
            Remove-Item ${defDestinationFile} | Out-Null
        }
        Rename-Item ${defSourceFile} ${defDestinationFile} | Out-Null
    }
}
Export-ModuleMember -Function Edit-RenameFile

# ディレクトリ生成
function Edit-MakeDirectory( [string]$defPath )
{
    if ( -not $(Test-Path ${defPath}) )
    {
        New-Item -Path ${defPath} -Type Directory | Out-Null
    }
}
Export-ModuleMember -Function Edit-MakeDirectory

# ファイル削除
function Remove-ExistDirectory( [string]$defPath )
{
    if ( $(Test-Path ${defPath}) )
    {
        Remove-Item -path ${defPath} -recurse -force | Out-Null
    }
}
Export-ModuleMember -Function Remove-ExistDirectory
