﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

class Stopwatch
{
public:
    Stopwatch()
     : m_IsStarted(false)
    {
    }

    ~Stopwatch()
    {
    }

    void Start()
    {
        if (m_IsStarted == false)
        {
            m_IsStarted = true;
            m_Start = nn::os::GetSystemTick().ToTimeSpan();
        }
    }

    void Stop()
    {
        if (m_IsStarted == true)
        {
            m_Stop = nn::os::GetSystemTick().ToTimeSpan();
            m_IsStarted = false;
        }
    }

    int64_t GetMilliSecond()
    {
        if (m_IsStarted == true)
        {
            return -1;
        }

        return (m_Stop - m_Start).GetMilliSeconds();
    }

private:
    bool m_IsStarted;
    nn::TimeSpan m_Start;
    nn::TimeSpan m_Stop;
};

class ScopedWatch
{
public:
    NN_IMPLICIT ScopedWatch(Stopwatch* inWatchPtr)
     : m_WatchPtr(inWatchPtr)
    {
        if (m_WatchPtr != nullptr)
        {
            m_WatchPtr->Start();
        }
    }

    ~ScopedWatch()
    {
        if (m_WatchPtr != nullptr)
        {
            m_WatchPtr->Stop();
        }
    }
private:
    Stopwatch* m_WatchPtr;
};
