﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/settings/system/settings_Language.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>

class NsTypeConv
{
public:
    static const char* ToString(nn::ns::StartupUserAccount inStartupUserAccount) NN_NOEXCEPT;
    static nn::ns::StartupUserAccount ToStartupUserAccount(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::AttributeFlag inAttributeFlag) NN_NOEXCEPT;
    static nn::ns::AttributeFlag ToAttributeFlag(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::ParentalControlFlag inParentalControlFlag) NN_NOEXCEPT;
    static nn::ns::ParentalControlFlag ToParentalControlFlag(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::Screenshot inScreenshot) NN_NOEXCEPT;
    static nn::ns::Screenshot ToScreenshot(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::VideoCapture inVideoCapture) NN_NOEXCEPT;
    static nn::ns::VideoCapture ToVideoCapture(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::LogoType inLogoType) NN_NOEXCEPT;
    static nn::ns::LogoType ToLogoType(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::RatingOrganization inRatingOrganization) NN_NOEXCEPT;
    static nn::ns::RatingOrganization ToRatingOrganization(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::DataLossConfirmation inDataLossConfirmation) NN_NOEXCEPT;
    static nn::ns::DataLossConfirmation ToDataLossConfirmation(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::PlayLogPolicy inPlayLogPolicy) NN_NOEXCEPT;
    static nn::ns::PlayLogPolicy ToPlayLogPolicy(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::LogoHandling inLogoHandling) NN_NOEXCEPT;
    static nn::ns::LogoHandling ToLogoHandling(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::AddOnContentRegistrationType inAocRegistrationType) NN_NOEXCEPT;
    static nn::ns::AddOnContentRegistrationType ToAddOnContentRegistrationType(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::Hdcp inHdcp) NN_NOEXCEPT;
    static nn::ns::Hdcp ToHdcp(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::CrashReport inCR) NN_NOEXCEPT;
    static nn::ns::CrashReport ToCrashReport(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::RuntimeAddOnContentInstall inRuntimeAocInstall) NN_NOEXCEPT;
    static nn::ns::RuntimeAddOnContentInstall ToRuntimeAddOnContentInstall(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::PlayLogQueryCapability inPlayLogQueryCapability) NN_NOEXCEPT;
    static nn::ns::PlayLogQueryCapability ToPlayLogQueryCapability(const std::string& inStr) NN_NOEXCEPT;

    static const char* ToString(nn::ns::RepairFlag inRepairFlag) NN_NOEXCEPT;
    static nn::ns::RepairFlag ToRepairFlag(const std::string& inStr) NN_NOEXCEPT;

    static const std::string RequiredNetworkServiceLicenseOnLaunchFlagToString(nn::Bit8 flag) NN_NOEXCEPT;
    static nn::Bit8 ToRequiredNetworkServiceLicenseOnLaunchFlag(const std::string& inStr) NN_NOEXCEPT;

public:
    static const char* ToString(nn::settings::Language inLanguage) NN_NOEXCEPT;
    static nn::settings::Language ToSettingLanguage(const std::string& inLangageStr) NN_NOEXCEPT;

public:
    static const char* ToString(nn::ncm::StorageId inStrageId) NN_NOEXCEPT;
    static nn::ncm::StorageId ToStorageIdForInstallStorage(const std::string& inStr) NN_NOEXCEPT;
    //static nn::ncm::StorageId ToStorageId(const std::string& inStrageStr) NN_NOEXCEPT;

    static const char* ToString(nn::ncm::ContentMetaType inContentMetaType) NN_NOEXCEPT;
    //static nn::ncm::ContentMetaType ToContentMetaType(const std::string& inContentMetaType) NN_NOEXCEPT;
};

