﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/ns_ApplicationViewApi.h>

class ApplicationViewChecker
{
public:
    ApplicationViewChecker() NN_NOEXCEPT;
    virtual ~ApplicationViewChecker() NN_NOEXCEPT;

public:
    bool DoCheck(const nn::ns::ApplicationView& inView) NN_NOEXCEPT;

public:
    void SetDefaultApplicationInstallExpectedValue() NN_NOEXCEPT;
    void SetPatchExpectedFilterValue() NN_NOEXCEPT;
    void SetPatchOnlyExpectedFilterValue() NN_NOEXCEPT;
    void SetAocExpectedFilterValue() NN_NOEXCEPT;
    void SetAocOnlyExpectedFilterValue() NN_NOEXCEPT;

public:
    bool hasRecord;
    bool hasMainRecord;
    bool hasPatchRecord;
    bool hasAddOnContentRecord;
    bool hasMainInstallRecord;
    bool isDownloading;
    bool isGameCard;
    bool hasGameCardEntity;
    bool isLaunchable;
    bool hasAllEntity;
    bool hasMainEntity;
    bool hasAllAddOnContentEntity;
    bool hasPatchEntity;
    bool maybeCorrupted;
    bool isWaitingCommit;
    bool isWaitingApplicationCommit;
    bool isWaitingAocCommit;
    bool isWaitingPatchInstall;
    bool isAutoDeleteDisabled;
    bool isApplyingDelta;
};
