﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include "ApplicationManagerTestTool_ApplicationViewChecker.h"

ApplicationViewChecker::ApplicationViewChecker() NN_NOEXCEPT
{
    this->SetDefaultApplicationInstallExpectedValue();
}

ApplicationViewChecker::~ApplicationViewChecker() NN_NOEXCEPT
{

}

void ApplicationViewChecker::SetDefaultApplicationInstallExpectedValue() NN_NOEXCEPT
{
    // アプリをインストールした直後のデフォルト値状態(期待値)の設定
    this->hasRecord = true;
    this->hasMainRecord = true;
    this->hasPatchRecord = false;
    this->hasAddOnContentRecord = false;
    this->hasMainInstallRecord = true;
    this->isDownloading = false;
    this->isGameCard = false;
    this->hasGameCardEntity = false;
    this->isLaunchable = true;
    this->hasAllEntity = true;
    this->hasMainEntity = true;
    this->hasAllAddOnContentEntity = true;
    this->hasPatchEntity = false;
    this->maybeCorrupted = false;
    this->isWaitingCommit = false;
    this->isWaitingApplicationCommit = false;
    this->isWaitingAocCommit = false;
    this->isWaitingPatchInstall = false;
    this->isAutoDeleteDisabled = false;
    this->isApplyingDelta = false;
}

void ApplicationViewChecker::SetPatchExpectedFilterValue() NN_NOEXCEPT
{
    // パッチを適用した場合の期待値の追加設定
    this->hasPatchRecord = true;
    this->hasPatchEntity = true;
}

void ApplicationViewChecker::SetPatchOnlyExpectedFilterValue() NN_NOEXCEPT
{
    // アプリなしでパッチのみ適用した場合の期待値の追加設定
    this->hasMainRecord = false;
    this->hasPatchRecord = true;
    this->hasMainInstallRecord = false;
    this->isLaunchable = false;
    this->hasMainEntity = false;
    this->hasPatchEntity = true;
}

void ApplicationViewChecker::SetAocExpectedFilterValue() NN_NOEXCEPT
{
    // Aocを適用した場合の期待値の追加設定
    this->hasAddOnContentRecord = true;
}

void ApplicationViewChecker::SetAocOnlyExpectedFilterValue() NN_NOEXCEPT
{
    // アプリなしでAocのみ適用した場合の期待値の追加設定
    this->hasMainRecord = false;
    this->hasAddOnContentRecord = true;
    this->hasMainInstallRecord = false;
    this->isLaunchable = false;
    this->hasMainEntity = false;
}

bool ApplicationViewChecker::DoCheck(const nn::ns::ApplicationView& inView) NN_NOEXCEPT
{
    bool checkResult = true;

    // チェックに引っかかった行数を明確にするため、あえてマクロ(関数)定義を使用する
    #define CHECK_EXPECT_EQ(expected, actual) \
        do {                                  \
            EXPECT_EQ(expected, actual);      \
            if (expected != actual)           \
            {                                 \
                checkResult = false;          \
            }                                 \
        } while (NN_STATIC_CONDITION(false))

    // ひとまず Has～()、Is～()系の API のみをチェック対象とする
    CHECK_EXPECT_EQ(this->hasRecord, inView.HasRecord());
    CHECK_EXPECT_EQ(this->hasMainRecord, inView.HasMainRecord());
    CHECK_EXPECT_EQ(this->hasPatchRecord, inView.HasPatchRecord());
    CHECK_EXPECT_EQ(this->hasAddOnContentRecord, inView.HasAddOnContentRecord());
    CHECK_EXPECT_EQ(this->hasMainInstallRecord, inView.HasMainInstallRecord());
    CHECK_EXPECT_EQ(this->isDownloading, inView.IsDownloading());
    CHECK_EXPECT_EQ(this->isGameCard, inView.IsGameCard());
    CHECK_EXPECT_EQ(this->hasGameCardEntity, inView.HasGameCardEntity());
    CHECK_EXPECT_EQ(this->isLaunchable, inView.IsLaunchable());
    CHECK_EXPECT_EQ(this->hasAllEntity, inView.HasAllEntity());
    CHECK_EXPECT_EQ(this->hasMainEntity, inView.HasMainEntity());
    CHECK_EXPECT_EQ(this->hasAllAddOnContentEntity, inView.HasAllAddOnContentEntity());
    CHECK_EXPECT_EQ(this->hasPatchEntity, inView.HasPatchEntity());
    CHECK_EXPECT_EQ(this->maybeCorrupted, inView.MaybeCorrupted());
    CHECK_EXPECT_EQ(this->isWaitingCommit, inView.IsWaitingCommit());
    CHECK_EXPECT_EQ(this->isWaitingApplicationCommit, inView.IsWaitingApplicationCommit());
    CHECK_EXPECT_EQ(this->isWaitingAocCommit, inView.IsWaitingAocCommit());
    CHECK_EXPECT_EQ(this->isWaitingPatchInstall, inView.IsWaitingPatchInstall());
    CHECK_EXPECT_EQ(this->isAutoDeleteDisabled, inView.IsAutoDeleteDisabled());
    CHECK_EXPECT_EQ(this->isApplyingDelta, inView.IsApplyingDelta());

    return checkResult;
}
