﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/es/es_Types.h>
#include <nn/es/es_ELicenseTypes.h>
#include <nn/account/account_NintendoAccountTypes.h>

namespace nnt { namespace elicense {

class ArchiveGenerator
{
public:
    constexpr static size_t BufferCapacity = 64 * 1024;

    explicit ArchiveGenerator() NN_NOEXCEPT : m_ArchiveSize(0u) {}

    size_t GenerateDummy(char* pOutBase64Buffer, size_t bufferSize
        , const nn::es::ELicenseArchiveId& eLicenseArchiveId
        , const nn::account::NintendoAccountId& naId
        , const nn::es::RightsId& titleId) NN_NOEXCEPT;

    inline size_t GetSize() const NN_NOEXCEPT
    {
        return m_ArchiveSize;
    }

    inline char* GetArchive() NN_NOEXCEPT
    {
        return m_Archive;
    }

private:
    size_t CreateJson(char* outBuffer, size_t bufferSize, const nn::es::ELicenseArchiveId& eLicenseArchiveId, const nn::account::NintendoAccountId& naId, const nn::es::RightsId& titleId) NN_NOEXCEPT;
    size_t Encrypt(void* outBuffer, size_t bufferSize, void* pSource, size_t sourceSize) NN_NOEXCEPT;

    char    m_Archive[BufferCapacity] = {};
    size_t  m_ArchiveSize;
};

}} // ~namespace nnt::elicense
