﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/ae.h>

#include <nn/la/la_CommonArgumentsReader.h>
#include <nn/la/la_NifmToWifiWebAuthArgumentsReader.h>
#include <nn/la/la_AppletToNifmArgumentsWriter.h>
#include <nn/nifm/nifm_TypesRequestPrivate.h>
#include <nn/util/util_Uuid.h>

#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nifm/nifm_ApiNetworkProfile.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_NetworkConnection.h>

#include "../Common/nifm_TestUtility.h"


void LibraryAppletNetConnectMain(const nn::ae::LibraryAppletSelfInfo& info) NN_NOEXCEPT
{
    NN_LOG("===== DummyWifiWebAuth Start =====\n");

    nn::la::CommonArgumentsReader commonArgumentsReader;

    ASSERT_TRUE(commonArgumentsReader.TryPopFromInChannel());

    NN_LOG("commonArguments\n");
    NN_LOG("\tlaVersion = %u\n", commonArgumentsReader.GetLaVersion());
    NN_LOG("\tcolorIndex = %d\n", commonArgumentsReader.GetColorIndex());
    NN_LOG("\tisPlayStartupSound = %s\n", commonArgumentsReader.IsPlayStartupSound() ? "true" : "false");

    nn::la::NifmToWifiWebAuthArgumentsReader wifiWebAuthArgumentsReader;

    ASSERT_TRUE(wifiWebAuthArgumentsReader.TryPopFromInChannel());

    char uuidStr[nn::util::Uuid::StringSize];

    NN_LOG("\n");
    NN_LOG("NifmWifiWebAuthArgumentsReader\n");
    NN_LOG("\tconnTestUrl = %s\n", wifiWebAuthArgumentsReader.GetConnTestUrlPointer());
    NN_LOG("\tauthtUrl = %s\n", wifiWebAuthArgumentsReader.GetAuthUrlPointer());
    NN_LOG("\tprofileId = %s\n", wifiWebAuthArgumentsReader.GetProfileId().ToString(uuidStr, nn::util::Uuid::StringSize));
    NN_LOG("\tsubmitId = %d\n", wifiWebAuthArgumentsReader.GetSubmitId());

    {
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::InitializeSystem());
        nn::nifm::NetworkProfileData networkProfileData;
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::GetNetworkProfile(&networkProfileData, wifiWebAuthArgumentsReader.GetProfileId()));

        nn::nifm::NetworkConnection networkConnection;
        nn::Result result = nn::nifm::SetRequestRequirementBySubmitId(networkConnection.GetRequestHandle(), wifiWebAuthArgumentsReader.GetSubmitId());
        if (result.IsSuccess())
        {
            NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestConnectionConfirmationOption(networkConnection.GetRequestHandle(), nn::nifm::ConnectionConfirmationOption_Prohibited));
            NN_LOG("DummyWifiWebAuth FromApp\n");
        }
        else
        {
            NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestRequirementPreset(networkConnection.GetRequestHandle(), nn::nifm::RequirementPreset_InternetForWifiWebAuthApplet));
            NN_LOG("DummyWifiWebAuth FromApplet\n");
        }

        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestNetworkProfileId(networkConnection.GetRequestHandle(), wifiWebAuthArgumentsReader.GetProfileId()));

        NN_LOG("WifiWebAuth: SubmitRequestAndWait...\n");
        if (nn::nifm::test::SubmitRequestAndWait(&networkConnection, 60))
        {
            nn::os::SleepThread(nn::TimeSpan::FromSeconds(10));
        }
        NNT_ASSERT_RESULT_SUCCESS(networkConnection.GetResult());
    }

    // 疎通確認成功を応答
    nn::la::AppletToNifmArgumentsWriter appletToNifmArgumentsWriter(true);
    appletToNifmArgumentsWriter.PushToOutChannel();
}

extern "C" void nninitStartup()
{
    // 本テストはアプレット向け desc を利用しており、アプレット向けのリソース制限が適用されます。
    // ここでは、デフォルトの nninitStartup() のデフォルトメモリアロケータのサイズが
    // アプレットで利用できるサイズ上限を超えているため、自前で nninitStartup() を用意しています。
}

extern "C" void nnMain()
{
    nn::ae::InvokeLibraryAppletMain(LibraryAppletNetConnectMain);
}

