﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nnt.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>

#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_ApiScan.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_TemporaryNetworkProfile.h>
#include <nn/nifm/nifm_TypesWirelessSetting.h>
#include <nn/nifm/nifm_ResultPrivate.h>

#include <nn/ae.h>
#include <nn/applet/applet.h>
#include <nn/err.h>

#include "../Common/nifm_TestUtility.h"


class DummyAppletCallerTest : public ::testing::Test
{
protected:
    static void SetUpTestCase()
    {
    }

    static void TearDownTestCase()
    {
    }
};

/**
 * DummyAppletCaller(SA) -> DummyWeb(LA1) -> DummyError(LA2)
 *                                        -> DummyNetConnect(LA2)
 *                                        -> DummyWifiWebAuth(LA2)
 */

TEST_F(DummyAppletCallerTest, AppletWeb)
{
    nn::applet::LibraryAppletHandle handle;
    nn::applet::CreateLibraryApplet(&handle, nn::applet::AppletId_LibraryAppletWeb, nn::applet::LibraryAppletMode_AllForeground);
    nn::applet::StartLibraryApplet(handle);
    nn::applet::JoinLibraryApplet(handle);
    nn::applet::CloseLibraryApplet(handle);
}

// nn::ae のメッセージ処理
bool ExpectMessage(nn::ae::Message expectMessage, nn::os::SystemEventType& e) NN_NOEXCEPT
{
    auto message = nn::ae::WaitForNotificationMessage(&e);
    if (message != expectMessage)
    {
        NN_LOG("Unexpected message 0x%08x (expect=0x%08x)\n", message, expectMessage);
        return false;
    }
    return true;
}

nn::ncm::ApplicationId g_ApplicationId;
void RunApplication(nn::ae::SystemAppletParameters* param) NN_NOEXCEPT
{
    // SA の起動
    nn::os::SystemEventType e;
    nn::ae::InitializeNotificationMessageEvent(&e);
    NN_ABORT_UNLESS(ExpectMessage(nn::ae::Message_ChangeIntoForeground, e));

    auto ret = RUN_ALL_TESTS();

    nnt::Exit(ret);
}

// アロケータ用のバッファ
NN_ALIGNAS(4096) uint8_t  g_MallocBuffer[1 * 1024 * 1024];
extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_MallocBuffer, sizeof(g_MallocBuffer));
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    // SystemApplet としてアプリを起動する
    nn::ae::InvokeSystemAppletMain(nn::ae::AppletId_SystemAppletMenu, RunApplication);
}
