﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>

//================================================================================
// 定数定義です。
//================================================================================
#define NNT_NFP_MENU_CONSOLE

#define NNT_PRINT_MENU(...)              NN_LOG("[MENU]" __VA_ARGS__)
#define NNT_PRINT_LOG(...)               NN_LOG("[LOG]" __VA_ARGS__)
#define NNT_PRINT_LOG_NO_PREFIX(...)     NN_LOG(__VA_ARGS__)
#define NNT_CLEAR_MENU()                 NN_LOG("\033[2J")

enum RenderDisplay
{
    RenderDisplay_0     = 1 << 0,
    RenderDisplay_1     = 1 << 1,
    RenderDisplay_Both  = RenderDisplay_0 | RenderDisplay_1,
};

//================================================================================
//  メニュー描画用のクラスです
//================================================================================
class MenuRenderSystem
{
public:
    MenuRenderSystem() NN_NOEXCEPT {}

    void Initialize(char* pHeap,const int heapSize) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void SetClearColor(RenderDisplay targetDisplay,
                       const float red,
                       const float green,
                       const float blue,
                       const float alpha) NN_NOEXCEPT;

    void SetColor(const float red, const float green, const float blue, const float alpha) NN_NOEXCEPT;

    void SetFontSize(const int size) NN_NOEXCEPT;

    void SetLineWidth(const float width) NN_NOEXCEPT;

    void WaitVsync(RenderDisplay targetDisplay) NN_NOEXCEPT;

    void SetRenderTarget(RenderDisplay targetDisplay) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;

    void DrawText(int x, int y, const char* pText) NN_NOEXCEPT;

    void SwapBuffers() NN_NOEXCEPT;
};

