﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest/Horizon/NetTest_Types.h"
#include "NetTest/Horizon/NetTest_OS.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

#include <cstring>
#include <cstdio>
#include <cstdlib> // For malloc

#include <windows.h>

namespace NATF {
namespace Utils {
int ReadLine(FILE* pFile, char* pBuffer, int bufferLen, bool dropWide) NN_NOEXCEPT;
}}

namespace
{
    const char* const TmpFile = "d_tmp.txt";
    const uint32_t MaxPath = 2 * 1024;
    char g_pProcessPathFromFile[MaxPath];
    char g_pCurrentProcessPath[MaxPath];
}

TEST(natf, KillPids)
{
    char pPidsFile[MaxPath];
    int argC = 0;
    const char * const * pArgV = nullptr;
    NATF::Utils::ParserGroup parser;
    bool defaultIgnoreFailure = false;
    bool ignoreFailure = defaultIgnoreFailure;

    memset(pPidsFile, 0, MaxPath);

    NETTEST_GET_ARGS(argC, pArgV);

    parser.AddParser(NATF::Utils::StringParser("--PidsFile", nullptr, pPidsFile, sizeof(pPidsFile)));
    parser.AddParser(NATF::Utils::BoolParser  ("--IgnoreFailure", &defaultIgnoreFailure, ignoreFailure));

    if (!parser.Parse(argC, pArgV))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    NN_LOG("Pid file: %s\n", pPidsFile);

    FILE* pFile = fopen(pPidsFile, "rt");
    if( !pFile )
    {
        NN_NETTEST_LOG(" * Failed to open file!\n\n");

        if(!ignoreFailure)
        {
            FAIL();
        }

        return;
    }

    while( !feof(pFile) )
    {
        bool skipKillPid = false;
        int pid = 0;
        int ret = fscanf(pFile, "%d:", &pid);

        if( ret <= 0 )
        {
            NN_LOG("Done\n");
            break;
        }

        NN_LOG("PID: %d\n", pid);
        ret = NATF::Utils::ReadLine(pFile, g_pProcessPathFromFile, sizeof(g_pProcessPathFromFile), false);
        if(ret <= 0)
        {
            NN_LOG("WARNING - Could not read process path! Going to try to kill it anyway!\n");
            FAIL();
        }
        else
        {
            do
            {
                char pNameCmdBuffer[80];
                snprintf(pNameCmdBuffer, sizeof(pNameCmdBuffer), "wmic process where processId=%d get ExecutablePath > %s", pid, TmpFile);

                int rval = system(pNameCmdBuffer);
                if(rval != 0)
                {
                    NN_LOG("Failed to execute command: %s\n\n", pNameCmdBuffer);
                    skipKillPid = true;
                    FAIL();
                    break;
                }

                FILE* pTmpFile = fopen(TmpFile, "rt");
                if(nullptr == pTmpFile)
                {
                    NN_LOG("Failed to open file for read: %s\n\n", TmpFile);
                    skipKillPid = true;
                    FAIL();
                    break;
                }

                // Read and ignore first line.
                int bytesRead = NATF::Utils::ReadLine(pTmpFile, g_pCurrentProcessPath, sizeof(g_pCurrentProcessPath), true);
                if(bytesRead <= 0)
                {
                    NN_LOG("WARNING - failed to read process path!\n\n");
                    fclose(pTmpFile);
                    if(!ignoreFailure)
                    {
                        skipKillPid = true;
                        FAIL();
                    }

                    break;
                }

                // Read and ignore second line.
                bytesRead = NATF::Utils::ReadLine(pTmpFile, g_pCurrentProcessPath, sizeof(g_pCurrentProcessPath), true);
                if(bytesRead <= 0)
                {
                    NN_LOG("WARNING - failed to read process path!\n\n");
                    fclose(pTmpFile);
                    if(!ignoreFailure)
                    {
                        skipKillPid = true;
                        FAIL();
                    }

                    break;
                }

                // Read process name path
                bytesRead = NATF::Utils::ReadLine(pTmpFile, g_pCurrentProcessPath, sizeof(g_pCurrentProcessPath), true);
                if(bytesRead <= 0)
                {
                    NN_LOG("WARNING - failed to read process path!\n\n");
                    fclose(pTmpFile);
                    if(!ignoreFailure)
                    {
                        skipKillPid = true;
                        FAIL();
                    }

                    break;
                }

                fclose(pTmpFile);

                // Make sure process name paths match
                if(strncmp(g_pProcessPathFromFile, g_pCurrentProcessPath, MaxPath) != 0)
                {
                    NN_LOG("WARNING - Process names do not match! Will NOT attempt to kill PID\n");
                    NN_LOG("File: %s\n", g_pProcessPathFromFile);
                    NN_LOG("Curr: %s\n", g_pCurrentProcessPath);
                    skipKillPid = true;
                    break;
                }
            } while(NN_STATIC_CONDITION(false));
        }

        if(false == skipKillPid)
        {
            char pCmdBuffer[256];
            sprintf(pCmdBuffer, "taskkill /T /F /pid %d", pid);
            int rval = system(pCmdBuffer);

            NN_LOG("Return code: %d\n", rval);
            if(!ignoreFailure)
            {
                EXPECT_EQ(rval, 0);
            }
        }
    }

    fclose(pFile);

    char pCmdBuffer[64 + MaxPath];
    sprintf(pCmdBuffer, "del %s", pPidsFile);
    system(pCmdBuffer);

    sprintf(pCmdBuffer, "del %s", TmpFile);
    system(pCmdBuffer);

    NN_LOG("Exiting...\n");
} // NOLINT(impl/function_size)
