﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "CommandParsers.h"
#include "Utils/CommandLineParser.h"

class TestlistGenerator
{
public:

    TestlistGenerator() NN_NOEXCEPT;

    bool Init() NN_NOEXCEPT;
    bool GenerateAllLists() NN_NOEXCEPT;
    bool GenerateTestlist(uint32_t platform, uint32_t buildType) NN_NOEXCEPT;

private:

    bool FindPlatformDefinitions(const char* pFileName) NN_NOEXCEPT;
    bool CheckForPlatformDefinition(FILE* pFile, const char* pCheck, size_t lineLen, uint32_t& lineNumber) NN_NOEXCEPT;
    bool ParseAndWriteLine(ParseInfo& parseInfo) NN_NOEXCEPT;

    bool RegisterCommandParser(CommandParser::ParserFn parserFn) NN_NOEXCEPT;
    bool RegisterAllCommandParsers() NN_NOEXCEPT;


    // These functions return -1 on fail or the number of bytes read from pCheck on success.
    int32_t IgnorePlatformDefinition  (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForDisablePlatform   (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForIgnoreEmptyLine   (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForInclude           (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForComment           (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForBuild             (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForPlatform          (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForConstants         (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForParamLoop         (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForLoopParam         (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckOnlyPlatforms        (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForDefinitions       (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForDefineReference   (ParseInfo& parseInfo) NN_NOEXCEPT;
    int32_t CheckForUnexpectedCommand (ParseInfo& parseInfo) NN_NOEXCEPT;

    // Helper functions for parsing loop command
    bool ReadLoopComponentsIntoBuffers(ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool CheckLoopComponentCommands   (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundLoopBodyCommand         (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundBeginIterationCommand   (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundEndIterationCommand     (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundBeginParamCommand       (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundEndParamCommand         (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;
    bool FoundEndLoopCommand          (ParseInfo& parseInfo, LoopState& loopState) NN_NOEXCEPT;

    bool FindOrCreateDefinition(ParseInfo& parseInfo, const char* pDefineName, size_t nameLen, DefineParam*& pFoundDefine) NN_NOEXCEPT;
    bool ReadDefinitionIntoBuffer(ParseInfo& parseInfo, DefineParam* pDefine, uint32_t startLine) NN_NOEXCEPT;

    struct Platform
    {
        bool isEnabled;
        uint32_t startLine;
        char pName[MaxPlatformNameBufLen];
        char pConstants[MaxPlatformConstantsBufLen];

        Platform() NN_NOEXCEPT
            : isEnabled(true),
              startLine(0)
        {
            memset(pName,      '\0', sizeof(pName));
            memset(pConstants, '\0', sizeof(pConstants));
        }
    };

    Platform m_pPlatforms[MaxPlatforms];
    uint8_t m_platformCount;
    DefineParam* m_pRootDefine;
    std::unique_ptr<CommandParser> m_pRootCommandParser;

    char m_pBaseTestlistFileIn[MaxFilePath];
    char m_pOutDir[MaxFilePath];
    char m_pBuildTypesParam[MaxBuildTypeListBufLen];

    char m_pBuildTypes[MaxBuildTypes][MaxBuildTypeStrBufLen];
    uint32_t m_buildTypeCount;

    FILE* m_pReadFile;
    FILE* m_pWriteFile;

    uint32_t m_curPlatform;
    uint32_t m_curBuildType;

    NATF::Utils::ParserGroup m_parser;
};
