﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string> // For strlen()
#include <nn/nn_Common.h>

#define PRINT_LINE_INFO(PARSE_INFO, ...)               \
do                                                     \
{                                                      \
    NN_LOG(" %s\n",          (PARSE_INFO).pFileName);  \
    NN_LOG(" Line: %-4d - ", (PARSE_INFO).lineNumber); \
    NN_LOG(__VA_ARGS__);                               \
} while(NN_STATIC_CONDITION(false))

#define RETURN_FALSE_ON_FALSE(CONDITION) \
do                                       \
{                                        \
    if(false == (CONDITION))             \
    {                                    \
        return false;                    \
    }                                    \
} while(NN_STATIC_CONDITION(false))

namespace
{
    static const char* const AutoGeneratedMessage_1 = "# This file was generated from ";
    static const char* const AutoGeneratedMessage_2 = "\n# This testlist was generated for tests built for ";
    static const char* const SpaceStr               = " ";
    static const char* const StripExt               = "yml.natf";
    static const char* const AppendExt              = ".testlist.yml";
    static const char CommandChar                   = '<';
    static const char CommandCharEnd                = '>';

    static const char* const CommandInclude                  = "<INCLUDE>";
    static const size_t      CommandIncludeLen               = strlen(CommandInclude);

    static const char* const CommandDisablePlatform          = "<DISABLE_PLATFORM>";
    static const size_t      CommandDisablePlatformLen       = strlen(CommandDisablePlatform);

    static const char* const CommandBeginIgnoreEmptyLines    = "<IGNORE_EMPTY_LINES>";
    static const size_t      CommandBeginIgnoreEmptyLinesLen = strlen(CommandBeginIgnoreEmptyLines);
    static const char* const CommandEndIgnoreEmptyLines      = "</IGNORE_EMPTY_LINES>";
    static const size_t      CommandEndIgnoreEmptyLinesLen   = strlen(CommandEndIgnoreEmptyLines);

    static const char* const CommandBeginComment             = "<COMMENT>";
    static const size_t      CommandBeginCommentLen          = strlen(CommandBeginComment);
    static const char* const CommandEndComment               = "</COMMENT>";
    static const size_t      CommandEndCommentLen            = strlen(CommandEndComment);

    static const char* const CommandBeginDefinePlatform      = "<DEFINE_PLATFORM>";
    static const size_t      CommandBeginDefinePlatformLen   = strlen(CommandBeginDefinePlatform);
    static const char* const CommandEndDefinePlatform        = "</DEFINE_PLATFORM>";
    static const size_t      CommandEndDefinePlatformLen     = strlen(CommandEndDefinePlatform);

    static const char* const CommandPlatform                 = "<PLATFORM>";
    static const size_t      CommandPlatformLen              = strlen(CommandPlatform);

    static const char* const CommandBuild                    = "<BUILD>";
    static const size_t      CommandBuildLen                 = strlen(CommandBuild);

    static const char* const CommandPlatformConstants        = "<PLATFORM_CONSTANTS>";
    static const size_t      CommandPlatformConstantsLen     = strlen(CommandPlatformConstants);

    static const char* const CommandBeginOnlyPlatforms       = "<ONLY_PLATFORMS>";
    static const size_t      CommandBeginOnlyPlatformsLen    = strlen(CommandBeginOnlyPlatforms);
    static const char* const CommandEndOnlyPlatforms         = "</ONLY_PLATFORMS>";
    static const size_t      CommandEndOnlyPlatformsLen      = strlen(CommandEndOnlyPlatforms);

    static const char* const CommandParamLoop                = "<LOOP>";
    static const size_t      CommandParamLoopLen             = strlen(CommandParamLoop);
    static const char* const CommandNextParam                = "<PARAM>";
    static const size_t      CommandNextParamLen             = strlen(CommandNextParam);
    static const char* const CommandEndParam                 = "</PARAM>";
    static const size_t      CommandEndParamLen              = strlen(CommandEndParam);
    static const char* const CommandNextIteration            = "<ITERATION>";
    static const size_t      CommandNextIterationLen         = strlen(CommandNextIteration);
    static const char* const CommandCloseIteration           = "</ITERATION>";
    static const size_t      CommandCloseIterationLen        = strlen(CommandCloseIteration);
    static const char* const CommandLoopBody                 = "<LOOP_BODY>";
    static const size_t      CommandLoopBodyLen              = strlen(CommandLoopBody);
    static const char* const CommandEndLoop                  = "</LOOP>";
    static const size_t      CommandEndLoopLen               = strlen(CommandEndLoop);
    static const char* const CommandLoopParam                = "<LOOP_PARAM>";
    static const size_t      CommandLoopParamLen             = strlen(CommandLoopParam);

    static const char* const CommandBeginDefine              = "<DEFINE>";
    static const size_t      CommandBeginDefineLen           = strlen(CommandBeginDefine);
    static const char* const CommandEndDefine                = "</DEFINE>";
    static const size_t      CommandEndDefineLen             = strlen(CommandEndDefine);

    static const uint32_t ReadWriteBufLen            = 2048;       // Buffer size used to read and write to files.
    static const uint32_t MaxBuildTypeListBufLen     = 32;         // Buffer size used to hold list of build types
    static const uint32_t MaxBuildTypeStrBufLen      = 8;          // Buffer size used to hold a single build type string.
    static const uint32_t MaxBuildTypes              = 3;          // Maximum number of build types: Debug,Develop,Release
    static const uint32_t MaxFilePath                = 2048;       // Buffer size for file path to the read and write files.
    static const uint32_t MaxPlatforms               = 16;         // The maximum number of platforms you can define
    static const uint32_t MaxPlatformNameBufLen      = 9;          // Buffer size of the platform name defined after <DEFINE_PLATFORM>
    static const uint32_t MaxPlatformConstantsBufLen = 512;        // Buffer size of the platform constants defined under <DEFINE_PLATFORM>
    static const uint32_t MaxLoopParamBufLen         = 8 * 1024;   // Buffer size of each loop parameter. i.e. Under <PARAM>
    static const uint32_t MaxLoopBodyBufLen          = 512 * 1024; // Buffer size of the body of a loop. i.e. Under <LOOP_BODY>
    static const uint32_t MaxDefineBufLen            = 512 * 1024; // Buffer size to hold the contents of a <DEFINE>
    static const uint32_t MaxDefineNameBufLen        = 64;         // Buffer size of the define name after <DEFINE>
    static const uint32_t MaxFileNameBufLen          = 512;        // Buffer size used to hold file names when using <INCLUDE>
}
