﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest/Horizon/NetTest_Types.h"
#include "NetTest/Horizon/NetTest_OS.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

#include <cstring>
#include <cstdio>

#include <windows.h>

namespace
{
    const uint32_t ReadBufLen  = 1024;
    const uint32_t MaxFilePath = 2048;
    const uint32_t MaxIpBufLen = 16;

    const char * const AutoDnsStr = "\"auto_dns\":";
    const char * const PreferredDnsStr = "\"preferred_dns\":";
    const char * const AlternateDnsStr = "\"alternate_dns\":";
}

TEST(natf, GenDnsNetworkSettings)
{
    int argC = 0;
    const char * const * pArgV = nullptr;
    char pSettingsFileIn[MaxFilePath];
    char pSettingsFileOut[MaxFilePath];
    char pPreferredDns[MaxIpBufLen];
    char pAlternateDns[MaxIpBufLen];
    NATF::Utils::ParserGroup parser;

    NETTEST_GET_ARGS(argC, pArgV);

    parser.AddParser(NATF::Utils::StringParser ("--NetSettingsFileIn", nullptr, pSettingsFileIn, sizeof(pSettingsFileIn)));
    parser.AddParser(NATF::Utils::StringParser ("--NetSettingsFileOut", nullptr, pSettingsFileOut, sizeof(pSettingsFileOut)));
    parser.AddParser(NATF::Utils::IpParser     ("--PreferredDns", nullptr, pPreferredDns, sizeof(pPreferredDns)));
    parser.AddParser(NATF::Utils::IpParser     ("--AlternateDns", nullptr, pAlternateDns, sizeof(pAlternateDns)));

    if (!parser.Parse(argC, pArgV))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    FILE* pReadFile = fopen(pSettingsFileIn, "rt");
    if( !pReadFile )
    {
        NN_NETTEST_LOG("Failed to open file!\n\n");
        FAIL();
    }

    FILE* pWriteFile = fopen(pSettingsFileOut, "wt");
    if( !pWriteFile )
    {
        fclose(pReadFile);
        NN_NETTEST_LOG("Failed to open file!\n\n");
        FAIL();
    }

    while(!feof(pReadFile))
    {
        char pBuffer[ReadBufLen];
        char* pRet = fgets(pBuffer, ReadBufLen, pReadFile);
        if( pRet )
        {
            char* pFindAutoDns      = strstr(pBuffer, AutoDnsStr);
            char* pFindPreferredDns = strstr(pBuffer, PreferredDnsStr);
            char* pFindAlternateDns = strstr(pBuffer, AlternateDnsStr);

            if( pFindAutoDns )
            {
                NN_NETTEST_LOG("Found %s\n", AutoDnsStr);
                int writtenBytes = NETTEST_SNPRINTF(pFindAutoDns, ReadBufLen - (pFindAutoDns - pBuffer), "%s false,\n", AutoDnsStr);
                if( writtenBytes != (int)strlen(pFindAutoDns) )
                {
                    NN_NETTEST_LOG("Failed to write to buffer! BufLen: %d, Bytes to write: %d\n\n", ReadBufLen, writtenBytes);
                    FAIL();
                    break;
                }
            }
            else if( pFindPreferredDns )
            {
                NN_NETTEST_LOG("Found %s\n", PreferredDnsStr);
                int writtenBytes = NETTEST_SNPRINTF(pFindPreferredDns, ReadBufLen - (pFindPreferredDns - pBuffer), "%s \"%s\",\n", PreferredDnsStr, pPreferredDns);
                if( writtenBytes != (int)strlen(pFindPreferredDns) )
                {
                    NN_NETTEST_LOG("Failed to write to buffer! BufLen: %d, Bytes to write: %d\n\n", ReadBufLen, writtenBytes);
                    FAIL();
                    break;
                }
            }
            else if( pFindAlternateDns )
            {
                NN_NETTEST_LOG("Found %s\n", AlternateDnsStr);
                int writtenBytes = NETTEST_SNPRINTF(pFindAlternateDns, ReadBufLen - (pFindAlternateDns - pBuffer), "%s \"%s\"\n", AlternateDnsStr, pAlternateDns);
                if( writtenBytes != (int)strlen(pFindAlternateDns) )
                {
                    NN_NETTEST_LOG("Failed to write to buffer! BufLen: %d, Bytes to write: %d\n\n", ReadBufLen, writtenBytes);
                    FAIL();
                    break;
                }
            }

            size_t lineLen = strlen(pBuffer);
            size_t bytesWritten = fwrite(pBuffer, 1, lineLen, pWriteFile);
            if( bytesWritten != lineLen )
            {
                NN_NETTEST_LOG("File error while writing! err: %d\n\n", ferror(pReadFile));
                FAIL();
                break;
            }
        }
        else if( ferror(pReadFile) )
        {
            NN_NETTEST_LOG("File error while reading! err: %d\n\n", ferror(pReadFile));
            FAIL();
            break;
        }
    }

    fclose(pReadFile);
    fclose(pWriteFile);

    NN_NETTEST_LOG("Exiting...\n");
}
