﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/TcpUdpNetworkTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

// TcpUdpNetworkAsClientServer
TEST(natf, TcpUdpNetworkAsClientServer)
{
    bool isSuccess;

    NATF::Utils::ParserGroup parser;
    nn::util::Uuid netProfile;
    int defaultTimeoutMs = 300;
    int defaultDurationSec = 30;
    int32_t timeoutMs;
    int32_t durationSec;
    char appTypeName[NATF::Modules::SoTestDataXfer::MaxNameStringLen];
    char ipAddr[NATF::Modules::SoTestDataXfer::MaxIpAddrStringLen];
    int defaultPortNumber = NATF::Modules::SoTestDataXfer::MaxPortNumber + 1;
    int32_t portNumber;
    char protocolTypeName[NATF::Modules::SoTestDataXfer::MaxNameStringLen];
    char pTestName[NATF::BaseTest::NameBufferLen];
    char xferPattern[NATF::Modules::SoTestDataXfer::MaxBufSize];

    int argC;
    const char * const * argV;

    memset((void *)xferPattern, '\0', sizeof(xferPattern));

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argC, argV);

    parser.AddParser(NATF::Utils::StringParser  ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UuidParser    ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::Int32Parser   ("--TimeoutMs", &defaultTimeoutMs, timeoutMs));
    parser.AddParser(NATF::Utils::StringParser  ("--AppType", nullptr, appTypeName,
        sizeof(appTypeName)));
    parser.AddParser(NATF::Utils::IpParser      ("--IpAddr", nullptr, ipAddr, sizeof(ipAddr)));
    parser.AddParser(NATF::Utils::Int32Parser   ("--PortNumber", &defaultPortNumber, portNumber));
    parser.AddParser(NATF::Utils::StringParser  ("--ProtocolType", nullptr, protocolTypeName,
        sizeof(protocolTypeName)));
    parser.AddParser(NATF::Utils::Int32Parser   ("--DurationSec", &defaultDurationSec, durationSec));
    parser.AddParser(NATF::Utils::StringParser  ("--XferPattern", "Echo", xferPattern, sizeof(xferPattern)));

    if( !parser.Parse(argC, argV) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::TcpUdpNetwork tcpNetwork(pTestName, netProfile, timeoutMs, appTypeName, ipAddr, portNumber, protocolTypeName, durationSec, xferPattern);

    isSuccess = tcpNetwork.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
