﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/
#include "NetTest_Port.h"

#include "Tests/IperfTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

namespace
{
    const uint32_t MaxIperfArgBufLen = 1024;
}

// Iperf
TEST(natf, Iperf)
{
    NATF::Utils::ParserGroup parser;
    int argc;
    const char * const * pArgv;
    uint32_t timeoutMs = 0;
    nn::util::Uuid netProfile;
    bool doExchangeIp = true;
    char pTestName[NATF::BaseTest::NameBufferLen];
    char pIperfArgs[MaxIperfArgBufLen];

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UuidParser   ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::UInt32Parser ("--TimeoutMs", nullptr, timeoutMs));
    parser.AddParser(NATF::Utils::BoolParser   ("--ExchangeIp", nullptr, doExchangeIp));
    parser.AddParser(NATF::Utils::StringParser ("--IperfArgs", nullptr, pIperfArgs, sizeof(pIperfArgs)));

    if( !parser.Parse(argc, pArgv) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    NATF::Tests::Iperf iperf(pTestName, netProfile, timeoutMs, doExchangeIp, pIperfArgs);

    bool isSuccess = iperf.Run();
    EXPECT_EQ(isSuccess, true);

    nn::os::SleepThread( nn::TimeSpan::FromSeconds(2) );
    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
