﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/os.h>
#include <nn/nn_Log.h>

namespace // unnamed, for constants accessible only to this file
{
    const int TestSleepTimeSec = 17;
}



#ifdef WIN32
#include <cstdio>
#endif

// HelloWorld
TEST(natf, HelloWorld_HostCounterpart)
{
    NN_LOG("\nHello World 2 - STARTED!\n");

    #ifdef WIN32
        FILE* fp;

        fp = fopen("c:\\temp\\testnet_hello2_start.txt", "w+");
        if( fp != nullptr )
        {
            fputs("test started\n", fp);
            fclose(fp);
        }
    #endif

    NN_LOG("\n-Hello World 2 - Sleeping %ds!\n", TestSleepTimeSec);
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(TestSleepTimeSec));

    #ifdef WIN32
        fp = fopen("c:\\temp\\testnet_hello2_end.txt", "w+");
        if( fp != nullptr )
        {
            fputs("test finished\n", fp);
            fclose(fp);
        }
    #endif

    NN_LOG("\nHello World 2 - FINISHED!\n\n");
}

