﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include "NetTest_Port.h"

#include "Tests/CurlHttpDownloadMultiTest.h"
#include "Utils/CommandLineParser.h"
#include "../Common/ParseHelpers.h"

#include <curl/curl.h>

namespace
{
    const uint32_t ProxyAuthBufLen = 32;
}

// CurlCrl
TEST(natf, CurlCrl)
{
    bool isSuccess = true;
    NATF::Utils::ParserGroup parser;
    NATF::Modules::LibCurl::Params params;
    int argc;
    uint32_t timeoutMs = 0;
    uint16_t defaultProxyPort = 0;
    bool defaultDoVerifyHostName = true;
    bool defaultDoVerifyDate = true;
    nn::util::Uuid netProfile;
    char pTestName[NATF::BaseTest::NameBufferLen];
    char pProxyAuth[ProxyAuthBufLen];
    const char* pDefaultProxyServer = "";
    const char* pDefaultProxyCredentials = "";
    const char* pDefaultProxyAuth = "NEGOTIATE";
    const char * const * pArgv;

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser  ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UuidParser    ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::StringParser  ("--Url", nullptr, params.pUrl, sizeof(params.pUrl)));
    parser.AddParser(NATF::Utils::UInt32Parser  ("--TimeoutMs", nullptr, timeoutMs));
    parser.AddParser(NATF::Utils::Md5HashParser ("--Md5Hash", nullptr, params.expectedHash));
    parser.AddParser(NATF::Utils::BoolParser    ("--VerifyHostName", &defaultDoVerifyHostName, params.doVerifyHostname));
    parser.AddParser(NATF::Utils::BoolParser    ("--VerifyDate", &defaultDoVerifyDate, params.doVerifyDate));
    parser.AddParser(NATF::Utils::StringParser  ("--ProxyServer", pDefaultProxyServer, params.pProxyServer, sizeof(params.pProxyServer)));
    parser.AddParser(NATF::Utils::StringParser  ("--ProxyCredentials", pDefaultProxyCredentials, params.pProxyUserPwd, sizeof(params.pProxyUserPwd)));
    parser.AddParser(NATF::Utils::StringParser  ("--ClientCert", "", params.pClientCertPath, sizeof(params.pClientCertPath)));
    parser.AddParser(NATF::Utils::StringParser  ("--ServerCert", "", params.pServerCertPath, sizeof(params.pServerCertPath)));
    parser.AddParser(NATF::Utils::UInt16Parser  ("--ProxyPort", &defaultProxyPort, params.proxyPort));
    parser.AddParser(NATF::Utils::StringParser  ("--ProxyAuth", pDefaultProxyAuth, pProxyAuth, sizeof(pProxyAuth)));

    if (!parser.Parse(argc, pArgv))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    if( strncmp(pProxyAuth, "", sizeof(pProxyAuth)) != 0 )
    {
        NetTest::StrUpr(pProxyAuth);
        if(nnt::ParserHelpers::GetProxyAuthFromString(pProxyAuth, sizeof(pProxyAuth), params.proxyAuthMethod) == false)
        {
            FAIL();
            return;
        }
    }

    params.expectedCurlReturn   = 51;
    params.expectedAuthReturn   = 155771;
    params.expectedHttpResponse = 0;
    params.doVerifyPeer         = true;
    params.doVerifyHostname     = false;

    NATF::Tests::CurlHttpDownloadMulti curlCrl(pTestName, netProfile, timeoutMs, 1, params);

    isSuccess = curlCrl.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
} // NOLINT(impl/function_size)

