﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ssl/ssl_Connection.h>

namespace nnt {

    class ParserHelpers
    {
    public:
        static bool GetCacheModeFromString(const char* pString, uint32_t strBufLen, nn::ssl::Connection::SessionCacheMode& outCacheMode) NN_NOEXCEPT;
        static bool GetProxyAuthFromString(const char* pString, uint32_t strBufLen, int& outProxyAuth) NN_NOEXCEPT;
        static bool GetWaitTypeFromString(const char* pString, uint32_t strBufLen, bool& outUseSelect) NN_NOEXCEPT;
    };

} // nnt
