﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


// ------------------------------------------------------------------------------------------------
// Parameters
// ------------------------------------------------------------------------------------------------
const char     ServerName[]    = "natf.com";
const uint32_t ServerIpAddress = 0xbec22e0a; // ntd-net-server1.ntd.nintendo.com

// Appropriate certs are defined in testServerPki.h/testClientPki.h/testClientPkiNoPwd.h
// 442: g_pTestCaCertExpired
// 443: g_pTestCaCert
// 444: g_pTestCaCert, g_pTestClientPki (g_pTestClientPkiSize)
//      g_pTestClientPkiPassword(g_TestClientPkiPasswordLength)
// 446: g_pTestCaCert3, g_pTestClientPki3 (g_pTestClientPkiSize3)
//      g_pTestClientPkiPassword3(g_TestClientPkiPasswordLength3)
enum ServerPort
{
    ServerPort_ExpiredCert     = 442, //!< Normal https server which returns expired cert
    ServerPort_Normal          = 443, //!< Normal https server
    ServerPort_ClientAuth      = 444, //!< Https server which requires client authentication
    ServerPort_SrvRevoked      = 447, //!< Https server with cert or intermediate CA revoked by issuer
};
