﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include <nn/socket.h>
#include <nn/nn_Log.h>

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

namespace
{
    bool TestInetNtoa_AddrNetwork(void *pAddrNetwork, bool isSupported)
    {
        bool isSuccess = true;
        char *rval;

        ERROR_IF(nullptr == pAddrNetwork, "InetNtoa precondition not met: pAddrNetwork null");

        PRINT_AND_CALL(rval = nn::socket::InetNtoa(*reinterpret_cast<nn::socket::InAddr *>(pAddrNetwork)));

        ERROR_IF(nullptr == rval, "InetNtoa failed (static buffer not allocated).");

        if( isSupported )
        {
            ERROR_IF(!NATF::API::VerifyIpAddrEquiv(rval, reinterpret_cast<nn::socket::InAddr *>(pAddrNetwork)), "InetNtoa failed when expected to succeed.");
        }
        else
        {
            ERROR_IF(NATF::API::VerifyIpAddrEquiv(rval, reinterpret_cast<nn::socket::InAddr *>(pAddrNetwork)), "InetNtoa succeeded when expected to fail.");
        }

out:
        return isSuccess;
    }

    bool TestInetNtoa_Main()
    {
        bool isSuccess = true;
        bool rval = false;

        nn::socket::SockAddrIn addrIpv4;
        char alternateAddrNetwork[4] = { 0x01, 0x00, 0x00, 0x7F };

        ////////////////////////////////////////////////////////////////
        // Function:
        // char *inet_ntoa(nn::socket::InAddr in);

        ////////////////////////////////////////////////////////////////
        // Argument:
        // nn::socket::InAddr in

        memset(&addrIpv4, 0, sizeof(addrIpv4));
        addrIpv4.sin_addr.S_addr = 0x0100007F; // IpV4 loopback
        PRINT_AND_CALL(rval = TestInetNtoa_AddrNetwork(&addrIpv4.sin_addr, true));
        ERROR_IF_AND_COUNT(rval != true, "InetNtoa() test failed");

#ifdef sockaddr_in6
{
        // NOTE: sockaddr_in6 not defined
        struct sockaddr_in6 addrIpv6;
        memset(&addrIpv6, 0, sizeof(addrIpv6));
        strcpy(&addrIpv6.sin6_addr.s6_addr, "::1"); // IpV6 loopback
        PRINT_AND_CALL(rval = TestInetNtoa_AddrNetwork(&addrIpv6.sin6_addr, false));
        ERROR_IF_AND_COUNT(rval != true, "InetNtoa() test failed");
}
#endif

        memset(&addrIpv4, 0, sizeof(addrIpv4));
        PRINT_AND_CALL(rval = TestInetNtoa_AddrNetwork(&addrIpv4.sin_addr, true));
        ERROR_IF_AND_COUNT(rval != true, "InetNtoa() test failed");

        PRINT_AND_CALL(rval = TestInetNtoa_AddrNetwork(reinterpret_cast<void*>(alternateAddrNetwork), true));
        ERROR_IF_AND_COUNT(rval != true, "InetNtoa() test failed");

out:
        return isSuccess;
    }

} // unnamed

namespace NATF {
namespace API {

TEST(ApiUnit, TestInetNtoa_Setup)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Socket), "TestSetup failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetNtoa_Main)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    INITIALIZE_TEST_COUNTS;

    NN_LOG("Calling TestInetNtoa_Main...\n");
    isSuccess = ::TestInetNtoa_Main();

    PRINT_TEST_COUNTS;

    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetNtoa_Teardown)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

}} // NATF::API
