﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////
// DEFAULT: ENABLE_FAILING_TESTS - DISABLED
//
// #define ENABLE_FAILING_TESTS

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include <cstdio>     // sprintf
#include <cctype>     // isprint
#include <cstdlib>    // malloc

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nn/socket.h>
#include <nnt/nntest.h>

#include <nn/os/os_Thread.h>
#include <nn/nifm.h>

#include "Unit/testNet_ThreadedTest.h"          // Threads for testing
#include "Unit/testNet_LoopbackDnsServer.h"     // Loopback DNS

#include <nn/socket/socket_ApiPrivate.h>

#ifndef NN_BUILD_CONFIG_OS_WIN32
#include <nn/socket/resolver/resolver_Client.h>
#endif

namespace NATF {
namespace API {

//////////////////////////////////////////////////////////////
//
// I M P O R T A N T:  This testing is *ONLY* for NX.  These tests do not work on Windows
//
//////////////////////////////////////////////////////////////

#ifndef NN_BUILD_CONFIG_OS_WIN32

//*********************
//*  G L O B A L S
//*********************

static ThreadedController * g_pThreadedTest = NULL;
static LoopbackDnsServer *  g_loopbackDnsServer = NULL;

static int                  kMaxNumberOfThreads = 32;
static int                  kThreadPriority = 10;
static int                  kMaxUDPPacketSize = 9000;
static uint16_t             kMaxTCPPacketSize = 65535;
static uint16_t             kMaxResourceRecordSize = 65535;

static uint32_t             g_WorkVaruint32_t = 0;
static int                  g_WorkVarint_t = 0;
static bool                 g_workVarBool = false;
static uint8_t              g_WorkVaruchar;

// Standard Google Lookup
//
// ; <<>> DiG 9.10.3-P4 <<>> +noedns=0 google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 35193
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//// ;; ANSWER SECTION:
// google.com.             150     IN      A       216.58.193.78
//
// ;; Query time: 31 msefalsec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:59:44 PDT 2016
// ;; MSG SIZE  rcvd: 44

static const unsigned char Google_com_simple[] = {

0x96, 0xac, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,
0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0xcd, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e

};

// Simple Google Lookup (with TC bit) - (Pos 3) - Set From: 0x81 To: 0x83
//
// ; <<>> DiG 9.10.3-P4 <<>> +noedns=0 google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 35193
// ;; flags: qr rd ra tc; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//
// ;; ANSWER SECTION:
// google.com.             150     IN      A       216.58.193.78
//
// ;; Query time: 31 msefalsec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:59:44 PDT 2016
// ;; MSG SIZE  rcvd: 44

static const unsigned char Google_com_simple_with_TC[] = {

0x96, 0xac, 0x83, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,
0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0xcd, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e

};

// Google Response with BROKEN LABEL OFFSET == (0xff) instead of (0x0c)
//
// ; <<>> DiG 9.10.3-P4 <<>> +noedns=0 google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 35193
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//
// ;; ANSWER SECTION:
// google.com.             150     IN      A       216.58.193.78
//
// ;; Query time: 31 msefalsec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:59:44 PDT 2016
// ;; MSG SIZE  rcvd: 44

static const unsigned char Google_com_Bad_Label_Offset[] = {

0x96, 0xac, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,  // google.com + 0x0
0x00, 0x01, 0x00, 0x01, 0xc0, 0xff, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0xcd, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e

};

// Google: Pointer to (SELF) - Pos (30 == 0x1E ) points to it's own offset
//
// ; <<>> DiG 9.10.3-P4 <<>> +noedns=0 google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 35193
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//
// ;; ANSWER SECTION:
// google.com.             150     IN      A       216.58.193.78
//
// ;; Query time: 31 msefalsec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:59:44 PDT 2016
// ;; MSG SIZE  rcvd: 44

static const unsigned char Google_com_Label_Endless_Pointer_Bug[] = {

0x96, 0xac, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,  // google.com + 0x0
0x00, 0x01, 0x00, 0x01, 0xc0, 0x1e, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0xcd, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e

};


// Google Lookup with EDNS0 + Payload Size = 4K
//
// ; <<>> DiG 9.10.3-P4 <<>> google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 7008
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 1
//
// ;; OPT PSEUDOSECTION:
// ; EDNS: version: 0, flags:; udp: 4096
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//
// ;; ANSWER SECTION:
// google.com.             90      IN      A       216.58.193.78
//
// ;; Query time: 3 msec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:33:48 PDT 2016
// ;; MSG SIZE  rcvd: 55

static const unsigned char SimpleGoogleEDNS04k[] = {

0x1b, 0x60, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
0x06, 0x67, 0x6f, 0x6f, 0x76, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,
0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0x5a, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e, 0x00, 0x00, 0x29, 0x10,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

};

// Google (Truncated response: Missing: 0x3a, 0xc1, 0x4e at end of buffer)
//
// ; <<>> DiG 9.10.3-P4 <<>> +noedns=0 google.com
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 35193
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;google.com.                    IN      A
//
// ;; ANSWER SECTION:
// google.com.             150     IN      A       216.58.193.78
//
// ;; Query time: 31 msefalsec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 12:59:44 PDT 2016
// ;; MSG SIZE  rcvd: 44

static const unsigned char Google_com_truncated_response_buffer[] = {

0x96, 0xac, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,
0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x00, 0xcd, 0x00, 0x04, 0xd8

};

// DNSSEC - Root Key Retrieval
// ; <<>> DiG 9.10.3-P4 <<>> +multiline . DNSKEY
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 54955
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 2, AUTHORITY: 0, ADDITIONAL: 1
//
// ;; OPT PSEUDOSECTION:
// ; EDNS: version: 0, flags:; udp: 4096
// ;; QUESTION SECTION:
// ;.                      IN DNSKEY
//
// ;; ANSWER SECTION:
// .                       13143 IN DNSKEY 256 3 8 (
//                                 AwEAAcCsATzyk1Hj1xabagAGWi9sZSbB+igdzDM8CMZ5
//                                 fPcOb314yP9/lmvidoBuApPlMVwlz0lXaj6gzyjoOKBv
//                                 eoDD0VyHTqjCDg9UrcDoClNZciR2sHZoaMZp2yVNFyaC
//                                 +7MkA8lsrCShieYPEowSjQdkvY5ONlEib/ATXdmAhfgB
//                                 ) ; ZSK; alg = RSASHA256; key id = 46551
// .                       13143 IN DNSKEY 257 3 8 (
//                                 AwEAAagAIKlVZrpC6Ia7gEzahOR+9W29euxhJhVVLOyQ
//                                 bSEW0O8gcCjFFVQUTf6v58fLjwBd0YI0EzrAcQqBGCzh
//                                 /RStIoO8g0NfnfL2MTJRkxoXbfDaUeVPQuYEhg37NZWA
//                                 JQ9VnMVDxP/VHL496M/QZxkjf5/Efucp2gaDX6RS6CXp
//                                 oY68LsvPVjR0ZSwzz1apAzvN9dlzEheX7ICJBBtuA6G3
//                                 LQpzW5hOA2hzCTMjJPJ8LbqF6dsV6DoBQzgul0sGIcGO
//                                 Yl7OyQdXfZ57relSQageu+ipAdTTJ25AsRTAoub8ONGc
//                                 LmqrAmRLKBP1dfwhYB4N7knNnulqQxA+Uk1ihz0=
//                                 ) ; KSK; alg = RSASHA256; key id = 19036
//
// ;; Query time: 31 msec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 15:06:24 PDT 2016
// ;; MSG SIZE  rcvd: 450

static const unsigned char DNSSECRootKeyTrustAnchors[] = {

0xfc, 0x1e, 0x81, 0x80, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x30, 0x00, 0x01, 0x00, 0x00,
0x30, 0x00, 0x01, 0x00, 0x00, 0x29, 0x9b, 0x01, 0x08, 0x01, 0x01, 0x03, 0x08, 0x03, 0x01, 0x00, 0x01, 0xa8, 0x00,
0x20, 0xa9, 0x55, 0x66, 0xba, 0x42, 0xe8, 0x86, 0xbb, 0x80, 0x4c, 0xda, 0x84, 0xe4, 0x7e, 0xf5, 0x6d, 0xbd, 0x7a,
0xec, 0x61, 0x26, 0x15, 0x55, 0x2c, 0xec, 0x90, 0x6d, 0x21, 0x16, 0xd0, 0xef, 0x20, 0x70, 0x28, 0xc5, 0x15, 0x54,
0x14, 0x4d, 0xfe, 0xaf, 0xe7, 0xc7, 0xcb, 0x8f, 0x00, 0x5d, 0xd1, 0x82, 0x34, 0x13, 0x3a, 0xc0, 0x71, 0x0a, 0x81,
0x18, 0x2c, 0xe1, 0xfd, 0x14, 0xad, 0x22, 0x83, 0xbc, 0x83, 0x43, 0x5f, 0x9d, 0xf2, 0xf6, 0x31, 0x32, 0x51, 0x93,
0x1a, 0x17, 0x6d, 0xf0, 0xda, 0x51, 0xe5, 0x4f, 0x42, 0xe6, 0x04, 0x86, 0x0d, 0xfb, 0x35, 0x95, 0x80, 0x25, 0x0f,
0x55, 0x9c, 0xc5, 0x43, 0xc4, 0xff, 0xd5, 0x1c, 0xbe, 0x3d, 0xe8, 0xcf, 0xd0, 0x67, 0x19, 0x23, 0x7f, 0x9f, 0xc4,
0x7e, 0xe7, 0x29, 0xda, 0x06, 0x83, 0x5f, 0xa4, 0x52, 0xe8, 0x25, 0xe9, 0xa1, 0x8e, 0xbc, 0x2e, 0xcb, 0xcf, 0x56,
0x34, 0x74, 0x65, 0x2c, 0x33, 0xcf, 0x56, 0xa9, 0x03, 0x3b, 0xcd, 0xf5, 0xd9, 0x73, 0x12, 0x17, 0x97, 0xec, 0x80,
0x89, 0x04, 0x1b, 0x6e, 0x03, 0xa1, 0xb7, 0x2d, 0x0a, 0x73, 0x5b, 0x98, 0x4e, 0x03, 0x68, 0x73, 0x09, 0x33, 0x23,
0x24, 0xf2, 0x7c, 0x2d, 0xba, 0x85, 0xe9, 0xdb, 0x15, 0xe8, 0x3a, 0x01, 0x43, 0x38, 0x2e, 0x97, 0x4b, 0x06, 0x21,
0xc1, 0x8e, 0x62, 0x5e, 0xce, 0xc9, 0x07, 0x57, 0x7d, 0x9e, 0x7b, 0xad, 0xe9, 0x52, 0x41, 0xa8, 0x1e, 0xbb, 0xe8,
0xa9, 0x01, 0xd4, 0xd3, 0x27, 0x6e, 0x40, 0xb1, 0x14, 0xc0, 0xa2, 0xe6, 0xfc, 0x38, 0xd1, 0x9c, 0x2e, 0x6a, 0xab,
0x02, 0x64, 0x4b, 0x28, 0x13, 0xf5, 0x75, 0xfc, 0x21, 0x60, 0x1e, 0x0d, 0xee, 0x49, 0xcd, 0x9e, 0xe9, 0x6a, 0x43,
0x10, 0x3e, 0x52, 0x4d, 0x62, 0x87, 0x3d, 0x00, 0x00, 0x30, 0x00, 0x01, 0x00, 0x00, 0x29, 0x9b, 0x00, 0x88, 0x01,
0x00, 0x03, 0x08, 0x03, 0x01, 0x00, 0x01, 0xc0, 0xac, 0x01, 0x3c, 0xf2, 0x93, 0x51, 0xe3, 0xd7, 0x16, 0x9b, 0x6a,
0x00, 0x06, 0x5a, 0x2f, 0x6c, 0x65, 0x26, 0xc1, 0xfa, 0x28, 0x1d, 0xcc, 0x33, 0x3c, 0x08, 0xc6, 0x79, 0x7c, 0xf7,
0x0e, 0x6f, 0x7d, 0x78, 0xc8, 0xff, 0x7f, 0x96, 0x6b, 0xe2, 0x76, 0x80, 0x6e, 0x02, 0x93, 0xe5, 0x31, 0x5c, 0x25,
0xcf, 0x49, 0x57, 0x6a, 0x3e, 0xa0, 0xcf, 0x28, 0xe8, 0x38, 0xa0, 0x6f, 0x7a, 0x80, 0xc3, 0xd1, 0x5c, 0x87, 0x4e,
0xa8, 0xc2, 0x0e, 0x0f, 0x54, 0xad, 0xc0, 0xe8, 0x0a, 0x53, 0x59, 0x72, 0x24, 0x76, 0xb0, 0x76, 0x68, 0x68, 0xc6,
0x69, 0xdb, 0x25, 0x4d, 0x17, 0x26, 0x82, 0xfb, 0xb3, 0x24, 0x03, 0xc9, 0x6c, 0xac, 0x24, 0xa1, 0x89, 0xe6, 0x0f,
0x12, 0x8c, 0x12, 0x8d, 0x07, 0x64, 0xbd, 0x8e, 0x4e, 0x36, 0x51, 0x22, 0x6f, 0xf0, 0x13, 0x5d, 0xd9, 0x80, 0x85,
0xf8, 0x01, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

};


// ; <<>> DiG 9.10.3-P4 <<>> google.com any
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 556
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 13, AUTHORITY: 0, ADDITIONAL: 1
//
// ;; OPT PSEUDOSECTION:
// ; EDNS: version: 0, flags:; udp: 4096
// ;; QUESTION SECTION:
// ;google.com.                    IN      ANY
//
// ;; ANSWER SECTION:
// google.com.             86266   IN      CAA     0 issue "symantec.com"
// google.com.             466     IN      MX      10 aspmx.l.google.com.
// google.com.             466     IN      MX      40 alt3.aspmx.l.google.com.
// google.com.             466     IN      MX      30 alt2.aspmx.l.google.com.
// google.com.             466     IN      MX      50 alt4.aspmx.l.google.com.
// google.com.             466     IN      MX      20 alt1.aspmx.l.google.com.
// google.com.             3466    IN      TXT     "v=spf1 include:_spf.google.com ~all"
// google.com.             54      IN      AAAA    2607:f8b0:400a:807::200e
// google.com.             56      IN      A       216.58.216.174
// google.com.             99661   IN      NS      ns4.google.com.
// google.com.             99661   IN      NS      ns1.google.com.
// google.com.             99661   IN      NS      ns3.google.com.
// google.com.             99661   IN      NS      ns2.google.com.
//
// ;; Query time: 31 msec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 18:04:44 PDT 2016
// ;; MSG SIZE  rcvd: 342

static const unsigned char Google_com_any[] = {

0x02, 0x2c, 0x81, 0x80, 0x00, 0x01, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x01, 0x06, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
0x03, 0x63, 0x6f, 0x6d, 0x00, 0x00, 0xff, 0x00, 0x01, 0xc0, 0x0c, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x50, 0xfa,
0x00, 0x13, 0x00, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x79, 0x6d, 0x61, 0x6e, 0x74, 0x65, 0x63, 0x2e, 0x63,
0x6f, 0x6d, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x01, 0xd2, 0x00, 0x0c, 0x00, 0x0a, 0x05, 0x61, 0x73,
0x70, 0x6d, 0x78, 0x01, 0x6c, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x01, 0xd2, 0x00, 0x09,
0x00, 0x28, 0x04, 0x61, 0x6c, 0x74, 0x33, 0xc0, 0x49, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x01, 0xd2,
0x00, 0x09, 0x00, 0x1e, 0x04, 0x61, 0x6c, 0x74, 0x32, 0xc0, 0x49, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00,
0x01, 0xd2, 0x00, 0x09, 0x00, 0x32, 0x04, 0x61, 0x6c, 0x74, 0x34, 0xc0, 0x49, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01,
0x00, 0x00, 0x01, 0xd2, 0x00, 0x09, 0x00, 0x14, 0x04, 0x61, 0x6c, 0x74, 0x31, 0xc0, 0x49, 0xc0, 0x0c, 0x00, 0x10,
0x00, 0x01, 0x00, 0x00, 0x0d, 0x8a, 0x00, 0x24, 0x23, 0x76, 0x3d, 0x73, 0x70, 0x66, 0x31, 0x20, 0x69, 0x6e, 0x63,
0x6c, 0x75, 0x64, 0x65, 0x3a, 0x5f, 0x73, 0x70, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
0x6d, 0x20, 0x7e, 0x61, 0x6c, 0x6c, 0xc0, 0x0c, 0x00, 0x1c, 0x00, 0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x10, 0x26,
0x07, 0xf8, 0xb0, 0x40, 0x0a, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0e, 0xc0, 0x0c, 0x00, 0x01,
0x00, 0x01, 0x00, 0x00, 0x00, 0x38, 0x00, 0x04, 0xd8, 0x3a, 0xd8, 0xae, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00,
0x01, 0x85, 0x4d, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01,
0x85, 0x4d, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x31, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x85,
0x4d, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x33, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x85, 0x4d,
0x00, 0x06, 0x03, 0x6e, 0x73, 0x32, 0xc0, 0x0c, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

};


// ; <<>> DiG 9.10.3-P4 <<>> hp.com any +ignore +noedns=0
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 43726
// ;; flags: qr tc rd ra; QUERY: 1, ANSWER: 14, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;hp.com.                                IN      ANY
//
// ;; ANSWER SECTION:
// hp.com.                 3089    IN      A       15.217.232.245
// hp.com.                 3089    IN      A       15.240.60.238
// hp.com.                 3089    IN      A       15.201.225.10
// hp.com.                 3089    IN      A       15.216.241.18
// hp.com.                 3089    IN      TXT     "MS=ms38857149"
// hp.com.                 3089    IN      TXT     "google-site-verification:2kiyv1SjebKUcEmaJ4QtapQe2EcbqPcYmhiJ-XJMZsY"
// hp.com.                 3089    IN      TXT     "IQI2xT+r6hj2PuJ171J02xOMMXSUHl4I2VJ5a4CB2OsyfPJkfHXHbmJ5e2Ee6kbNjJQsERvcm3d4IeS2e7xPPQ=="
// hp.com.                 3089    IN      PTR     0.0.0.15.in-addr.arpa.
// hp.com.                 3089    IN      MX      10 smtp.hp.com.
// hp.com.                 3089    IN      SOA     cce02hpeibpe.ams.hpecore.net. hostmaster.hp.com. 443242505 3600 3600 2419200 900
// hp.com.                 3089    IN      NS      ns4.hp.com.
// hp.com.                 3089    IN      NS      ns6.hp.com.
// hp.com.                 3089    IN      NS      ns2.hp.com.
// hp.com.                 3089    IN      NS      ns3.hp.com.
//
// ;; Query time: 2 msec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 18:31:58 PDT 2016
// ;; MSG SIZE  rcvd: 499

static const unsigned char HP_com_manyanswers[] = {

0xaa, 0xce, 0x83, 0x80, 0x00, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x68, 0x70, 0x03, 0x63, 0x6f, 0x6d,
0x00, 0x00, 0xff, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x04, 0x0f, 0xd9,
0xe8, 0xf5, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x04, 0x0f, 0xf0, 0x3c, 0xee, 0xc0,
0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x04, 0x0f, 0xc9, 0xe1, 0x0a, 0xc0, 0x0c, 0x00, 0x01,
0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x04, 0x0f, 0xd8, 0xf1, 0x12, 0xc0, 0x0c, 0x00, 0x10, 0x00, 0x01, 0x00,
0x00, 0x0c, 0x11, 0x00, 0x0e, 0x0d, 0x4d, 0x53, 0x3d, 0x6d, 0x73, 0x33, 0x38, 0x38, 0x35, 0x37, 0x31, 0x34, 0x39,
0xc0, 0x0c, 0x00, 0x10, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x45, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
0x2d, 0x73, 0x69, 0x74, 0x65, 0x2d, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
0x32, 0x6b, 0x69, 0x79, 0x76, 0x31, 0x53, 0x6a, 0x65, 0x62, 0x4b, 0x55, 0x63, 0x45, 0x6d, 0x61, 0x4a, 0x34, 0x51,
0x74, 0x61, 0x70, 0x51, 0x65, 0x32, 0x45, 0x63, 0x62, 0x71, 0x50, 0x63, 0x59, 0x6d, 0x68, 0x69, 0x4a, 0x2d, 0x58,
0x4a, 0x4d, 0x5a, 0x73, 0x59, 0xc0, 0x0c, 0x00, 0x10, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x59, 0x58, 0x49,
0x51, 0x49, 0x32, 0x78, 0x54, 0x2b, 0x72, 0x36, 0x68, 0x6a, 0x32, 0x50, 0x75, 0x4a, 0x31, 0x37, 0x31, 0x4a, 0x30,
0x32, 0x78, 0x4f, 0x4d, 0x4d, 0x58, 0x53, 0x55, 0x48, 0x6c, 0x34, 0x49, 0x32, 0x56, 0x4a, 0x35, 0x61, 0x34, 0x43,
0x42, 0x32, 0x4f, 0x73, 0x79, 0x66, 0x50, 0x4a, 0x6b, 0x66, 0x48, 0x58, 0x48, 0x62, 0x6d, 0x4a, 0x35, 0x65, 0x32,
0x45, 0x65, 0x36, 0x6b, 0x62, 0x4e, 0x6a, 0x4a, 0x51, 0x73, 0x45, 0x52, 0x76, 0x63, 0x6d, 0x33, 0x64, 0x34, 0x49,
0x65, 0x53, 0x32, 0x65, 0x37, 0x78, 0x50, 0x50, 0x51, 0x3d, 0x3d, 0xc0, 0x0c, 0x00, 0x0c, 0x00, 0x01, 0x00, 0x00,
0x0c, 0x11, 0x00, 0x17, 0x01, 0x30, 0x01, 0x30, 0x01, 0x30, 0x02, 0x31, 0x35, 0x07, 0x69, 0x6e, 0x2d, 0x61, 0x64,
0x64, 0x72, 0x04, 0x61, 0x72, 0x70, 0x61, 0x00, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00,
0x09, 0x00, 0x0a, 0x04, 0x73, 0x6d, 0x74, 0x70, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0x0c,
0x11, 0x00, 0x3f, 0x0c, 0x63, 0x63, 0x65, 0x30, 0x32, 0x68, 0x70, 0x65, 0x69, 0x62, 0x70, 0x65, 0x03, 0x61, 0x6d,
0x73, 0x07, 0x68, 0x70, 0x65, 0x63, 0x6f, 0x72, 0x65, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x0a, 0x68, 0x6f, 0x73, 0x74,
0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0xc0, 0x0c, 0x1a, 0x6b, 0x58, 0x09, 0x00, 0x00, 0x0e, 0x10, 0x00, 0x00, 0x0e,
0x10, 0x00, 0x24, 0xea, 0x00, 0x00, 0x00, 0x03, 0x84, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11,
0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00,
0x06, 0x03, 0x6e, 0x73, 0x36, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x06,
0x03, 0x6e, 0x73, 0x32, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x11, 0x00, 0x06, 0x03,
0x6e, 0x73, 0x33, 0xc0, 0x0c

};

// ;; Truncated, retrying in TCP mode.
//
// ; <<>> DiG 9.10.3-P4 <<>> hp.com any +noedns=0
// ;; global options: +cmd
// ;; Got answer:
// ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 26140
// ;; flags: qr rd ra; QUERY: 1, ANSWER: 16, AUTHORITY: 0, ADDITIONAL: 0
//
// ;; QUESTION SECTION:
// ;hp.com.                                IN      ANY
//
// ;; ANSWER SECTION:
// hp.com.                 2142    IN      A       15.240.60.238
// hp.com.                 2142    IN      A       15.201.225.10
// hp.com.                 2142    IN      A       15.216.241.18
// hp.com.                 2142    IN      A       15.217.232.245
// hp.com.                 2142    IN      TXT     "IQI2xT+r6hj2PuJ171J02xOMMXSUHl4I2VJ5a4CB2OsyfPJkfHXHbmJ5e2Ee6kbNjJQsERvcm3d4IeS2e7xPPQ=="
// hp.com.                 2142    IN      TXT     "MS=ms38857149"
// hp.com.                 2142    IN      TXT     "google-site-verification:2kiyv1SjebKUcEmaJ4QtapQe2EcbqPcYmhiJ-XJMZsY"
// hp.com.                 2142    IN      PTR     0.0.0.15.in-addr.arpa.
// hp.com.                 2142    IN      MX      10 smtp.hp.com.
// hp.com.                 2142    IN      SOA     cce02hpeibpe.ams.hpecore.net. hostmaster.hp.com. 443242505 3600 3600 2419200 900
// hp.com.                 2142    IN      NS      ns5.hp.com.
// hp.com.                 2142    IN      NS      ns3.hp.com.
// hp.com.                 2142    IN      NS      ns4.hp.com.
// hp.com.                 2142    IN      NS      ns2.hp.com.
// hp.com.                 2142    IN      NS      ns1.hp.com.
// hp.com.                 2142    IN      NS      ns6.hp.com.
//
// ;; Query time: 2 msec
// ;; SERVER: 10.1.19.29#53(10.1.19.29)
// ;; WHEN: Tue Aug 02 18:47:45 PDT 2016
// ;; MSG SIZE  rcvd: 535
//
// IMPORTANT: (Pos 14): SWAP: Question: Query Type for (TYPE == ANY == 0xff) to (TYPE A == 0x01)

static const unsigned char HPTCPWithFullResponse[] = {

0x02, 0x17, 0x66, 0x1c, 0x81, 0x80, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x02, 0x68, 0x70, 0x03, 0x63, 0x6f, 0x6d, 0x00,
0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x04, 0x0f, 0xf0, 0x3c, 0xee, 0xc0, 0x0c,
0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x04, 0x0f, 0xc9, 0xe1, 0x0a, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
0x08, 0x5e, 0x00, 0x04, 0x0f, 0xd8, 0xf1, 0x12, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x04, 0x0f, 0xd9,
0xe8, 0xf5, 0xc0, 0x0c, 0x00, 0x10, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x59, 0x58, 0x49, 0x51, 0x49, 0x32, 0x78, 0x54, 0x2b,
0x72, 0x36, 0x68, 0x6a, 0x32, 0x50, 0x75, 0x4a, 0x31, 0x37, 0x31, 0x4a, 0x30, 0x32, 0x78, 0x4f, 0x4d, 0x4d, 0x58, 0x53, 0x55, 0x48,
0x6c, 0x34, 0x49, 0x32, 0x56, 0x4a, 0x35, 0x61, 0x34, 0x43, 0x42, 0x32, 0x4f, 0x73, 0x79, 0x66, 0x50, 0x4a, 0x6b, 0x66, 0x48, 0x58,
0x48, 0x62, 0x6d, 0x4a, 0x35, 0x65, 0x32, 0x45, 0x65, 0x36, 0x6b, 0x62, 0x4e, 0x6a, 0x4a, 0x51, 0x73, 0x45, 0x52, 0x76, 0x63, 0x6d,
0x33, 0x64, 0x34, 0x49, 0x65, 0x53, 0x32, 0x65, 0x37, 0x78, 0x50, 0x50, 0x51, 0x3d, 0x3d, 0xc0, 0x0c, 0x00, 0x10, 0x00, 0x01, 0x00,
0x00, 0x08, 0x5e, 0x00, 0x0e, 0x0d, 0x4d, 0x53, 0x3d, 0x6d, 0x73, 0x33, 0x38, 0x38, 0x35, 0x37, 0x31, 0x34, 0x39, 0xc0, 0x0c, 0x00,
0x10, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x45, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2d, 0x73, 0x69, 0x74, 0x65, 0x2d,
0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x32, 0x6b, 0x69, 0x79, 0x76, 0x31, 0x53, 0x6a, 0x65,
0x62, 0x4b, 0x55, 0x63, 0x45, 0x6d, 0x61, 0x4a, 0x34, 0x51, 0x74, 0x61, 0x70, 0x51, 0x65, 0x32, 0x45, 0x63, 0x62, 0x71, 0x50, 0x63,
0x59, 0x6d, 0x68, 0x69, 0x4a, 0x2d, 0x58, 0x4a, 0x4d, 0x5a, 0x73, 0x59, 0xc0, 0x0c, 0x00, 0x0c, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e,
0x00, 0x17, 0x01, 0x30, 0x01, 0x30, 0x01, 0x30, 0x02, 0x31, 0x35, 0x07, 0x69, 0x6e, 0x2d, 0x61, 0x64, 0x64, 0x72, 0x04, 0x61, 0x72,
0x70, 0x61, 0x00, 0xc0, 0x0c, 0x00, 0x0f, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x09, 0x00, 0x0a, 0x04, 0x73, 0x6d, 0x74, 0x70,
0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x3f, 0x0c, 0x63, 0x63, 0x65, 0x30, 0x32, 0x68, 0x70,
0x65, 0x69, 0x62, 0x70, 0x65, 0x03, 0x61, 0x6d, 0x73, 0x07, 0x68, 0x70, 0x65, 0x63, 0x6f, 0x72, 0x65, 0x03, 0x6e, 0x65, 0x74, 0x00,
0x0a, 0x68, 0x6f, 0x73, 0x74, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0xc0, 0x0c, 0x1a, 0x6b, 0x58, 0x09, 0x00, 0x00, 0x0e, 0x10, 0x00,
0x00, 0x0e, 0x10, 0x00, 0x24, 0xea, 0x00, 0x00, 0x00, 0x03, 0x84, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00,
0x06, 0x03, 0x6e, 0x73, 0x35, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x06, 0x03, 0x6e, 0x73,
0x33, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc0, 0x0c, 0xc0,
0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x32, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00,
0x01, 0x00, 0x00, 0x08, 0x5e, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x31, 0xc0, 0x0c, 0xc0, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x08,
0x5e, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x36, 0xc0, 0x0c

};

// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.2, Port: 0, Name: wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.cisum.org
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.11, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.5, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.16, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.17, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.18, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.23, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.6, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.19, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.13, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.9, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.20, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.1, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.21, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.8, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.22, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.12, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.10, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.3, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.2, Port: 0, Name: wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.cisum.org
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.11, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.5, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.16, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.17, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.18, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.23, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.6, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.19, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.13, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.9, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.20, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.1, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.21, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.8, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.22, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.12, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.10, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.3, Port: 0, Name: (null)

static const unsigned char Response505_part1[] = {

0x57, 0xF3, 0x83, 0x80, 0x00, 0x01, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x78, 0x78, 0x05, 0x63, 0x69, 0x73, 0x75, 0x6D, 0x03, 0x6F, 0x72, 0x67, 0x00, 0x00, 0x01, 0x00, 0x01, 0xC0, 0x0C, 0x00, 0x05, 0x00,
0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x42, 0x3F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xC0,
0x4C, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x02, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0B, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x05, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x10, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x11, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x12, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x17, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x06, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x13, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0D, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x09, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x14, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x01, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x15, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x08, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x16, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0C, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x0A, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x03, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x04

};

// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.2, Port: 0, Name: wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.cisum.org
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.11, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.5, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.16, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.17, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.18, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.23, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.6, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.19, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.13, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.9, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.20, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.1, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.21, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.8, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.22, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.12, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.10, Port: 0, Name: (null)
// Family: 2, Socktype: 2, Protocol: 17, Flags: 0x2, IPAddr: 1.2.3.3, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.2, Port: 0, Name: wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.cisum.org
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.11, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.5, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.16, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.17, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.18, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.23, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.6, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.19, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.13, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.9, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.20, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.1, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.21, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.8, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.22, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.12, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.10, Port: 0, Name: (null)
// Family: 2, Socktype: 1, Protocol: 6, Flags: 0x2, IPAddr: 1.2.3.3, Port: 0, Name: (null)

static const unsigned char Response505_part2[] = {

0x57, 0xF3, 0x81, 0x80, 0x00, 0x01, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x78, 0x78, 0x05, 0x63, 0x69, 0x73, 0x75, 0x6D, 0x03, 0x6F, 0x72, 0x67, 0x00, 0x00, 0x01, 0x00, 0x01, 0xC0, 0x0C, 0x00, 0x05, 0x00,
0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x42, 0x3F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xC0,
0x4C, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x02, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0B, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x05, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x10, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x11, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x12, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x17, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x06, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x13, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0D, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x09, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x14, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x01, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x15, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x08, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x16, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x0C, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03,
0x0A, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x0D, 0xA0, 0x00, 0x04, 0x01, 0x02, 0x03, 0x03, 0xC0, 0x67, 0x00, 0x01, 0x00, 0x01, 0x00,
0x04

};

//////////////////
// DNSSEC - Part 1
//////////////////

static const unsigned char Dnssec_part1[] = {

0x51, 0xec, 0x81, 0xa0, 0x00, 0x01, 0x00, 0x03, 0x00, 0x06, 0x00, 0x0d, 0x07, 0x6d, 0x6f, 0x6e, 0x61, 0x64, 0x69, 0x63, 0x05, 0x63, 0x79, 0x6e,
0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x00, 0x2c, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x2c, 0x00, 0x01, 0x00, 0x00, 0x01, 0x18, 0x00, 0x16, 0x01,
0x01, 0xf9, 0x0f, 0xd3, 0x96, 0x46, 0x96, 0x8e, 0xa8, 0x15, 0xcc, 0xcb, 0xc8, 0xdf, 0x17, 0xd9, 0x3a, 0x6a, 0x44, 0x75, 0xab, 0xc0, 0x0c, 0x00,
0x2e, 0x00, 0x01, 0x00, 0x00, 0x01, 0x18, 0x01, 0x1d, 0x00, 0x2c, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06,
0xb4, 0x72, 0x32, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x74, 0x36, 0xdd, 0x6c, 0x0d, 0xe3, 0x8a, 0x76, 0xa7, 0xbc,
0xef, 0x68, 0xe9, 0xdc, 0x7d, 0x8a, 0xe7, 0xe2, 0x2b, 0x87, 0x94, 0x53, 0x48, 0xfd, 0xfa, 0x81, 0xc9, 0x77, 0x1d, 0x51, 0xb7, 0x10, 0x76, 0xc9,
0x05, 0x6d, 0x10, 0xe9, 0x41, 0xb0, 0xfc, 0xff, 0x49, 0x83, 0x11, 0x03, 0xbb, 0xf4, 0x5c, 0x81, 0x10, 0x35, 0x18, 0xa1, 0xc4, 0x2b, 0xc3, 0x58,
0x5a, 0x33, 0xb2, 0x92, 0x5c, 0x38, 0xe1, 0x5e, 0x7e, 0x84, 0x3c, 0x43, 0x02, 0x3c, 0x54, 0x33, 0x5e, 0x82, 0x30, 0xf1, 0xe5, 0x4f, 0xde, 0x37,
0x14, 0x6b, 0xf8, 0xa4, 0xaa, 0x54, 0x31, 0x09, 0xe9, 0x10, 0x41, 0x8b, 0x95, 0xcd, 0xd9, 0x6c, 0x80, 0xbf, 0x5c, 0x55, 0x1b, 0x79, 0xa0, 0xb0,
0xf6, 0x35, 0xb5, 0x14, 0x51, 0xa1, 0x13, 0xad, 0x10, 0x24, 0xc6, 0x3a, 0xa9, 0x43, 0x7c, 0xad, 0xbc, 0x9c, 0x13, 0xaf, 0xf9, 0xf2, 0x47, 0xd3,
0x31, 0x31, 0xd6, 0x9b, 0x34, 0xf7, 0xcf, 0x1d, 0x00, 0x22, 0x5e, 0x68, 0x06, 0xe5, 0xfb, 0xde, 0xef, 0x0d, 0x5f, 0x49, 0xd1, 0x34, 0x22, 0xd1,
0x20, 0xd6, 0xe0, 0xd9, 0x47, 0x3a, 0x46, 0x3b, 0x5e, 0x2f, 0x7d, 0x91, 0x5d, 0x6a, 0x41, 0x70, 0x4e, 0xfb, 0x1e, 0x54, 0x9a, 0xe4, 0xc8, 0x67,
0xac, 0x02, 0x4e, 0x00, 0xfb, 0x0e, 0x49, 0x00, 0x21, 0xf2, 0xa7, 0x03, 0x29, 0xdd, 0x0c, 0x65, 0x0e, 0x35, 0xbc, 0x77, 0xcd, 0x88, 0x98, 0x9a,
0x6c, 0x85, 0x2d, 0x0e, 0xff, 0x20, 0x4d, 0x0e, 0x3f, 0xcd, 0xd1, 0xf6, 0xe7, 0xe5, 0xf4, 0x2a, 0xe8, 0x51, 0x2b, 0x7b, 0x6a, 0xdd, 0x28, 0xd4,
0xd9, 0x54, 0x28, 0x42, 0x23, 0x68, 0x1d, 0x74, 0xd3, 0xab, 0x3a, 0x45, 0xb5, 0xbd, 0x09, 0xa9, 0x2f, 0x9d, 0xbf, 0xf0, 0xbd, 0xfb, 0x91, 0x2c,
0x0a, 0x5e, 0xde, 0xee, 0x9a, 0x52, 0xc0, 0x0c, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x01, 0x18, 0x00, 0x9d, 0x00, 0x2c, 0x05, 0x03, 0x00, 0x00,
0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x3b,
0x07, 0x20, 0x93, 0x71, 0x5d, 0xb2, 0xea, 0xad, 0x40, 0x27, 0x1a, 0x0e, 0x01, 0x17, 0xaa, 0xdf, 0xa7, 0x73, 0xf1, 0x62, 0x57, 0x84, 0xbe, 0x60,
0x8f, 0x0e, 0x08, 0x2d, 0x18, 0xee, 0x90, 0x32, 0xbf, 0x03, 0x70, 0x99, 0x75, 0x68, 0xf9, 0x35, 0x4f, 0xee, 0x35, 0x2b, 0x3e, 0xd0, 0xfc, 0xb2,
0xf5, 0xe0, 0x7a, 0x62, 0xdc, 0x64, 0xc3, 0x4b, 0xa6, 0xe8, 0xde, 0xcb, 0x33, 0xf2, 0x25, 0x04, 0xf4, 0xe7, 0x45, 0xac, 0xb2, 0xa7, 0xf6, 0xdc,
0xfd, 0x20, 0xa9, 0x58, 0xc1, 0x96, 0xc0, 0x1d, 0xeb, 0x6d, 0xcd, 0x51, 0x70, 0x05, 0xdc, 0xbb, 0x6f, 0x82, 0x07, 0x85, 0x67, 0xd0, 0x5b, 0x59,
0xbc, 0xe6, 0xa5, 0x47, 0x69, 0xd6, 0xfa, 0x04, 0x62, 0x1a, 0x30, 0x55, 0xd3, 0xa7, 0x02, 0xa3, 0x01, 0xc7, 0xa7, 0x06, 0x6a, 0x73, 0x60, 0x11,
0x22, 0x9e, 0xc2, 0xfa, 0x50, 0x23, 0xda, 0xc1, 0x8c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x73, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x31, 0xc1,
0x8c, 0xc1, 0x8c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x73, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc1, 0x8c, 0xc1, 0x8c, 0x00, 0x02, 0x00,
0x01, 0x00, 0x02, 0x91, 0x73, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x32, 0xc1, 0x8c, 0xc1, 0x8c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x73, 0x00,
0x06, 0x03, 0x6e, 0x73, 0x33, 0xc1, 0x8c, 0xc1, 0x8c, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x01, 0x20, 0x01, 0x1d, 0x00, 0x02, 0x05, 0x02, 0x00,
0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0x72, 0x32, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00,
0x6f, 0xd7, 0x8c, 0x5d, 0x50, 0x62, 0x32, 0xe3, 0xef, 0x70, 0xe3, 0x35, 0xf8, 0x0d, 0x56, 0x9c, 0x93, 0x94, 0x3d, 0xe7, 0x72, 0x62, 0x4e, 0xff,
0x52, 0x8a, 0xc4, 0xbd, 0x01, 0x98, 0xc2, 0x47, 0x55, 0x7a, 0x90, 0xd2, 0x80, 0xc9, 0xef, 0xcf, 0x7e, 0x01, 0xd7, 0xb9, 0x4e, 0x19, 0x50, 0x34,
0xe4, 0xdb, 0xea, 0x11, 0x35, 0xd0, 0x59, 0x15, 0x44, 0x52, 0x60, 0xa5, 0xb7, 0x7d, 0x49, 0xb7, 0x27, 0xdb, 0x07, 0x69, 0xf6, 0x9c, 0x55, 0x6b,
0x05, 0x17, 0x8a, 0xbf, 0xe3, 0x40, 0x4f, 0x74, 0xd6, 0xf0, 0x90, 0x0c, 0xb7, 0xe6, 0xa1, 0x38, 0x29, 0x08, 0x07, 0xbc, 0x7f, 0xd5, 0xba, 0xf5,
0xca, 0x1f, 0xab, 0x7a, 0x8e, 0xb5, 0x91, 0xca, 0xd8, 0x83, 0x4b, 0xe6, 0x04, 0x97, 0xd9, 0x5b, 0x29, 0x4c, 0x13, 0xba, 0x68, 0xcb, 0x45, 0x91,
0xc2, 0x4e, 0x85, 0x32, 0x70, 0x3b, 0x4d, 0xdd, 0x46, 0x36, 0x6d, 0xd1, 0x45, 0x33, 0x7a, 0x99, 0xf4, 0x13, 0x61, 0x65, 0x22, 0xcf, 0x95, 0x26,
0x57, 0xf8, 0xc0, 0x33, 0xae, 0xc1, 0x8f, 0x38, 0x91, 0xb8, 0xd3, 0xbc, 0x8d, 0xcf, 0x86, 0x0e, 0x98, 0xd4, 0x8e, 0x9b, 0x2e, 0x38, 0x9d, 0x69,
0xf4, 0x7e, 0x97, 0x06, 0xa7, 0x06, 0xee, 0x3e, 0x4a, 0x88, 0x5c, 0x43, 0xea, 0xdb, 0x8d, 0x54, 0x9f, 0x58, 0x4d, 0x3f, 0xde, 0xf0, 0xac, 0x5c,
0x05, 0xf5, 0x29, 0x7e, 0x82, 0x78, 0xd1, 0x28, 0x10, 0xa4, 0x1b, 0x1d, 0x29, 0xdb, 0xf3, 0xe5, 0x65, 0x06, 0x12, 0x0c, 0xf8, 0x0d, 0x7f, 0x60,
0x34, 0x70, 0x4b, 0x0f, 0xd0, 0xa3, 0xd2, 0x01, 0xed, 0x91, 0x6f, 0x89, 0x70, 0x11, 0xbf, 0xa1, 0x85, 0x84, 0xb6, 0x7d, 0x56, 0x38, 0xf2, 0xcb,
0x29, 0x3d, 0xec, 0x39, 0x96, 0x25, 0x6b, 0xde, 0xb8, 0xc7, 0x7c, 0xac, 0xbd, 0x34, 0x3e, 0xd9, 0xc2, 0x7d, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00,
0x01, 0x20, 0x00, 0x9d, 0x00, 0x02, 0x05, 0x02, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38, 0x05, 0x63,
0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x87, 0xa2, 0xcc, 0x70, 0xee, 0x0b, 0x15, 0xd0, 0x52, 0x6c, 0x7a, 0xe4, 0xec, 0xeb, 0xf0,
0x52, 0x19, 0xbd, 0x6e, 0x05, 0x65, 0x8d, 0x3a, 0x4a, 0x39, 0x19, 0x1b, 0xf2, 0xab, 0xae, 0x3d, 0xe7, 0xf6, 0x4d, 0xef, 0xb7, 0xce, 0x4a, 0xb2,
0x8b, 0x6e, 0xb8, 0xc1, 0xf4, 0x81, 0xb6, 0x8d, 0xbf, 0xa6, 0x1c, 0x7d, 0x75, 0x9a, 0xb5, 0x88, 0xdd, 0xe2, 0x35, 0xa6, 0x68, 0xe3, 0x09, 0xf9,
0xf8, 0x6d, 0x58, 0x20, 0x45, 0x94, 0xdb, 0xa2, 0x19, 0x8c, 0x76, 0x1e, 0x51, 0x5c, 0xb0, 0xe8, 0xe2, 0x0b, 0xda, 0x95, 0xdf, 0x83, 0xa4, 0x3d,
0xcd, 0x79, 0x7a, 0xc8, 0x7a, 0x7a, 0xc0, 0x6e, 0x7a, 0x50, 0x29, 0xef, 0xad, 0xf2, 0xd3, 0x11, 0x83, 0x0c, 0x57, 0xe7, 0xca, 0x43, 0x82, 0xaa,
0x9c, 0x28, 0x11, 0xf8, 0xf0, 0xc5, 0xca, 0xa5, 0x3e, 0x1b, 0x65, 0x3c, 0x58, 0xa3, 0x4b, 0xa8, 0x57, 0xc2, 0x23, 0x00, 0x01, 0x00, 0x01, 0x00,
0x02, 0x91, 0x73, 0x00, 0x04, 0x7d, 0x64, 0x7e, 0xcd, 0xc2, 0x47, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x73, 0x00, 0x04, 0xc7, 0xaf, 0x89,
0xd5, 0xc2, 0x59, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x73, 0x00, 0x04, 0xcb, 0x8d, 0x99, 0x16, 0xc2, 0x35, 0x00, 0x01, 0x00, 0x01, 0x00,
0x02, 0x91, 0x73, 0x00, 0x04, 0x7a, 0x67, 0xee, 0xba, 0xc2, 0x23, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02, 0xf0, 0x01, 0x1d, 0x00, 0x01, 0x05,
0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0x72, 0x32, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65,
0x74, 0x00, 0x69, 0x38, 0xf0, 0xb9, 0x85, 0x5d, 0xde, 0x99, 0xb6, 0xa4, 0xbc, 0xc8, 0xeb, 0x94, 0x84, 0x88, 0xda, 0x6f, 0xe8, 0x18, 0x3c, 0xa4,
0xc4, 0x0e, 0x76, 0x82, 0x04, 0xf4, 0x95, 0xf1, 0x34, 0x52, 0x1f, 0xf3, 0x8a, 0x0d, 0xb7, 0x80, 0x76, 0xa7, 0xc3, 0x62, 0x66, 0x24, 0xe8, 0x9d,
0xa1, 0xfd, 0x17, 0xcf, 0x89, 0x4d, 0x66, 0x44, 0x91, 0x18, 0x34, 0xb4, 0x44, 0xd7, 0xd5, 0x27, 0x6e, 0xae, 0x87, 0xc5, 0x00, 0x24, 0x1d, 0xd5,
0xbb, 0x40, 0x9a, 0x86, 0x70, 0xa2, 0x41, 0x94, 0x04, 0x90, 0x4d, 0xbc, 0x67, 0xd2, 0xf9, 0x03, 0x1e, 0x0b, 0x2f, 0x4e, 0x72, 0xe3, 0x8b, 0xe2,
0x23, 0x65, 0x4e, 0x2f, 0x3c, 0x32, 0x0a, 0x8e, 0x64, 0x8e, 0x97, 0x77, 0x77, 0xfe, 0x53, 0xd2, 0xcb, 0x47, 0x53, 0x61, 0x62, 0xac, 0xe4, 0x25,
0x39, 0xbe, 0x30, 0x95, 0xfa, 0xc2, 0xe0, 0xac, 0xf1, 0x49, 0x1e, 0x2a, 0x38, 0xd7, 0xca, 0x33, 0xd3, 0xf8, 0x1b, 0xe4, 0x66, 0xa3, 0xcd, 0x4b,
0xce, 0x0f, 0x6d, 0x14, 0x84, 0x54, 0x39, 0xd8, 0x9d, 0xb4, 0x5a, 0x5e, 0x8b, 0x28, 0x0f, 0x2f, 0x84, 0xff, 0xa4, 0x54, 0x65, 0x83, 0xd7, 0xf6,
0x87, 0x4e, 0x68, 0x0e, 0x44, 0xf6, 0x61, 0x21, 0xc1, 0x13, 0x0c, 0x9f, 0xe8, 0xec, 0xb0, 0x24, 0x73, 0x80, 0x99, 0x8d, 0x4e, 0x1e, 0x8d, 0xa8,
0x66, 0xcb, 0x34, 0x75, 0xfb, 0x6a, 0x6d, 0x03, 0x07, 0xe4, 0x76, 0xe7, 0x51, 0xda, 0x84, 0x16, 0xb5, 0x8c, 0x96, 0xcb, 0x40, 0xb8, 0x41, 0xdc,
0x28, 0xc8, 0x20, 0x7a, 0xe4, 0x26, 0x1f, 0x0b, 0x62, 0x64, 0x02, 0x5e, 0xb0, 0xe2, 0xd9, 0xbf, 0x44, 0x5f, 0x70, 0x72, 0xb5, 0x45, 0x30, 0xcd,
0xb0, 0xe5, 0xb1, 0x8c, 0xcd, 0x3f, 0xb2, 0x3f, 0x45, 0x31, 0x31, 0x6f, 0x85, 0xf6, 0x78, 0x16, 0xe5, 0x77, 0xc2, 0x23, 0x00, 0x2e, 0x00, 0x01,
0x00, 0x00, 0x02, 0xf0, 0x00, 0x9d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38,
0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x0a, 0x2c, 0xd9, 0x19, 0x0a, 0xea, 0x93, 0x69, 0xf5, 0xb5, 0xc4, 0xdd, 0xd4,
0x1a, 0xbf, 0x63, 0xc2, 0xb1, 0x02, 0x06, 0x76, 0x0f, 0x46, 0x15, 0x5d, 0xe7, 0x74, 0x46, 0xcf, 0x94, 0x09, 0x5f, 0x39, 0x00, 0x5d, 0x32, 0xd1,
0x34, 0xbe, 0xb7, 0xbe, 0x43, 0xbc, 0x7a, 0x55, 0x37, 0x2b, 0x61, 0x27, 0xa7, 0x78, 0x90, 0x0a, 0x70, 0xac, 0xe8, 0xb5, 0xe5, 0x0c, 0x7f, 0xa9,
0x21, 0xdb, 0xef, 0x93, 0x2b, 0xed, 0xb6, 0x25, 0x16, 0xde, 0xcf, 0x88, 0xd7, 0xe7, 0x00, 0x76, 0x4e, 0x61, 0x7b, 0x2f, 0x34, 0x08, 0xdc, 0x57,
0x6e, 0x87, 0x68, 0xe4, 0x76, 0x8f, 0xa1, 0xc4, 0x5e, 0x47, 0x3f, 0x8d, 0x27, 0xf2, 0xa3, 0xa1, 0xb8, 0xaf, 0x3e, 0x1d, 0xd4, 0x91, 0xcf, 0xa4,
0x4a, 0xec, 0x68, 0x18, 0x72, 0x4d, 0x6f, 0xcd, 0xdc, 0xae, 0x4f, 0x82, 0x3f, 0x94, 0x4a, 0x6a, 0x18, 0x52, 0xe5, 0xc2, 0x47, 0x00, 0x2e, 0x00,
0x01, 0x00, 0x00, 0x02, 0xf0, 0x01, 0x1d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0x72,
0x32, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x65, 0x20, 0xaf, 0x6b, 0x49, 0x74, 0x26, 0xb5, 0x88, 0xa5, 0x40, 0x33,
0x24, 0xb7, 0x57, 0x4d, 0x9b, 0x37, 0x08, 0x71, 0x99, 0xa3, 0x1d, 0x76, 0x1e, 0x83, 0x9b, 0x10, 0xe1, 0x62, 0xd7, 0xc0, 0xc7, 0xaf, 0x07, 0x7a,
0x26, 0xd5, 0x3f, 0x65, 0xf7, 0xfe, 0x77, 0x70, 0xcc, 0xed, 0x0c, 0x21, 0x04, 0xad, 0xd2, 0xe0, 0xb6, 0x8e, 0x2f, 0xfa, 0xd4, 0x3c, 0xcc, 0x07,
0xa8, 0xf2, 0x09, 0x3f, 0xa9, 0x8f, 0xc8, 0x56, 0x71, 0x60, 0x51, 0x81, 0x41, 0xb0, 0x91, 0xa1, 0x05, 0xb9, 0xcb, 0x65, 0x0f, 0xc3, 0xc3, 0x02,
0x91, 0xaf, 0xfd, 0x0d, 0xb8, 0xc3, 0x52, 0x6b, 0x01, 0x4d, 0xab, 0x83, 0xdf, 0x64, 0xed, 0x0a, 0x04, 0xee, 0x5e, 0x25, 0x7e, 0xaf, 0x66, 0x34,
0x3e, 0x4f, 0xe4, 0x2c, 0x9b, 0x7c, 0x5c, 0x9c, 0xad, 0x22, 0xa9, 0xc5, 0xd7, 0xd5, 0x0c, 0xb9, 0xbd, 0x80, 0x03, 0xb1, 0x12, 0x13, 0x36, 0x5d,
0x32, 0xd8, 0x8e, 0xc9, 0x5a, 0xdc, 0x0c, 0x12, 0x3d, 0x13, 0x85, 0x1a, 0xaf, 0xea, 0x3e, 0xb5, 0x23, 0x21, 0x6b, 0x94, 0x4a, 0x38, 0x60, 0xb8,
0x47, 0x7c, 0xad, 0x35, 0x43, 0x57, 0x3f, 0x74, 0xb7, 0x1d, 0x0f, 0x8e, 0xa7, 0x57, 0x57, 0x6e, 0xa2, 0x33, 0xde, 0x83, 0x1a, 0x76, 0xf9, 0xde,
0xa7, 0x15, 0x34, 0x61, 0x02, 0xff, 0x27, 0x92, 0x4c, 0x0c, 0x64, 0x14, 0x10, 0xf0, 0xa2, 0x3a, 0xc0, 0xe1, 0x40, 0x0d, 0x76, 0x3a, 0xff, 0xf6,
0x9c, 0xc6, 0x0a, 0x79, 0x44, 0x74, 0x72, 0xdf, 0xf5, 0xfd, 0x01, 0xe4, 0xa7, 0xe9, 0x01, 0xd6, 0x49, 0x3e, 0x2c, 0xce, 0xd4, 0x96, 0x3e, 0x87,
0x47, 0x53, 0x4f, 0x4c, 0x79, 0x9a, 0xb6, 0x8f, 0x35, 0xde, 0x67, 0x8f, 0xd0, 0xb0, 0xd4, 0x05, 0xcb, 0x3c, 0x79, 0x41, 0x91, 0x76, 0x29, 0x97,
0x20, 0x1e, 0x53, 0x7e, 0xc2, 0x47, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02, 0xf0, 0x00, 0x9d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84,
0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x92, 0x67, 0x10,
0x1b, 0x65, 0x07, 0x30, 0x37, 0x24, 0x9e, 0xf9, 0x43, 0x0e, 0x58, 0xcc, 0xbc, 0x3b, 0x93, 0x9c, 0xa1, 0x5b, 0x84, 0xda, 0x0e, 0x73, 0xb3, 0x0b,
0x58, 0x8b, 0x7b, 0xd7, 0x05, 0x85, 0xf9, 0x00, 0xa8, 0x93, 0x8e, 0xfb, 0xb1, 0xfc, 0xb0, 0xf4, 0x71, 0x70, 0x7a, 0x46, 0x9f, 0x7d, 0x60, 0x7d,
0xc1, 0xba, 0xf5, 0xea, 0xda, 0x59, 0xf7, 0x68, 0xef, 0xe0, 0xd1, 0xba, 0xca, 0x93, 0x73, 0xa4, 0x62, 0x09, 0x7f, 0x3e, 0xa7, 0x20, 0x45, 0x36,
0xed, 0x8b, 0xdf, 0x9e, 0x8a, 0xff, 0xf6, 0x9c, 0x4e, 0xf2, 0x71, 0x64, 0x47, 0xfc, 0xa1, 0xe8, 0xb6, 0xa1, 0xd5, 0xd0, 0xb6, 0x0b, 0x53, 0x77,
0xaa, 0x57, 0x20, 0xf2, 0x33, 0xc8, 0xbb, 0x20, 0x38, 0x01, 0xa1, 0x31, 0xa8, 0xcd, 0x37, 0xcf, 0xc3, 0x71, 0x20, 0xad, 0x5e, 0xe4, 0x17, 0xba,
0x4f, 0x32, 0xe1, 0xf9, 0x48, 0xc2, 0x59, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02, 0xf0, 0x01, 0x1d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03,
0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0x72, 0x32, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x4d, 0x6f,
0xe1, 0x6b, 0x47, 0xe6, 0x9e, 0x03, 0xd2, 0xa6, 0x7e, 0xcb, 0x39, 0xca, 0x81, 0x15, 0x04, 0x00, 0xc6, 0x57, 0xfa, 0xea, 0x3d, 0x41, 0x5b, 0x86,
0x27, 0xd5, 0x01, 0x1c, 0xe8, 0x5d, 0x32, 0xd2, 0xec, 0xf6, 0x5b, 0xdd, 0xe4, 0xea, 0x30, 0x0d, 0xa9, 0x5f, 0xc9, 0x86, 0x8e, 0x1f, 0xcc, 0xe9,
0x9f, 0x0b, 0x18, 0xd1, 0xac, 0x93, 0xd0, 0x5c, 0xe4, 0x60, 0x12, 0xf0, 0x7a, 0xb6, 0x14, 0xc7, 0xf3, 0xd4, 0x11, 0x4c, 0xde, 0x4c, 0xcb, 0x8a,
0x74, 0xd6, 0x8c, 0xbe, 0x4c, 0x5e, 0xd9, 0x24, 0xd1, 0x66, 0xc9, 0xd0, 0x0b, 0x6f, 0xb6, 0xe9, 0x20, 0x21, 0xb5, 0x5f, 0x2a, 0x5f, 0x73, 0x59,
0xb7, 0xe1, 0x78, 0xa3, 0xb8, 0x65, 0x84, 0xc4, 0xa0, 0x32, 0x18, 0xc5, 0x9e, 0x11, 0x55, 0x16, 0xf4, 0x93, 0x2a, 0x84, 0x4b, 0x99, 0x4e, 0x50,
0x8c, 0xdc, 0x2e, 0x2b, 0x19, 0xa1, 0xca, 0x70, 0x4b, 0x57, 0xe4, 0xdb, 0x08, 0xae, 0xa1, 0x46, 0x89, 0xf8, 0xa5, 0x92, 0x35, 0x57, 0x62, 0xcf,
0xfe, 0x45, 0xb4, 0xff, 0xe1, 0xc6, 0xb6, 0x6a, 0x92, 0x22, 0x5b, 0x8a, 0xb6, 0x41, 0x03, 0xd4, 0xe1, 0x06, 0x90, 0x5c, 0x87, 0x5e, 0x58, 0x1a,
0x3b, 0x6e, 0x64, 0x91, 0x84, 0x34, 0x9a, 0x2f, 0x65, 0x42, 0x39, 0xd0, 0x21, 0xcc, 0xfa, 0xd5, 0xa5, 0xad, 0x9e, 0x58, 0x18, 0xd6, 0x0b, 0xa0,
0x7b, 0xcf, 0xe8, 0xfc, 0xe3, 0xa5, 0x06, 0xb4, 0xab, 0x77, 0x3c, 0x9b, 0x95, 0xb0, 0x05, 0xac, 0xed, 0xd1, 0x73, 0x12, 0xd1, 0x3f, 0x81, 0x7e,
0x2f, 0x8b, 0x2d, 0x79, 0x18, 0xec, 0x9d, 0xf2, 0xc3, 0xdd, 0x59, 0xf7, 0x36, 0xcf, 0x12, 0xaf, 0x7c, 0xdb, 0x72, 0x98, 0xb5, 0x8a, 0x03, 0x55,
0xb2, 0x9b, 0xa0, 0xa8, 0x1f, 0xf5, 0x28, 0x19, 0xbf, 0xb8, 0xda, 0x43, 0xeb, 0x64, 0xc2, 0x59, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02, 0xf0,
0x00, 0x9d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38, 0x05, 0x63, 0x79, 0x6e,
0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x4d, 0x86, 0x3f, 0x5b, 0x16, 0x41, 0xbc, 0x6d, 0xca, 0xf9, 0xb8, 0x4b, 0x90, 0x97, 0x7e, 0x70, 0x42,
0x48, 0x8e, 0x55, 0xa3, 0x34, 0xd0, 0xec, 0xb4, 0x4c, 0x4c, 0xe8, 0x75, 0x7b, 0x0b, 0xa7, 0x28, 0x4b, 0x22, 0xae, 0x49, 0x3d, 0x18, 0x57, 0x37,
0xde, 0x71, 0x8e, 0x13, 0xec, 0xa7, 0xd3, 0x98, 0xf5, 0xa6, 0x57, 0xc2, 0x13, 0x49, 0x94, 0xd1, 0x14, 0xb1, 0x95, 0xe8, 0x68, 0xe3, 0x91, 0xa1,
0x17, 0xea, 0xad, 0xb1, 0x63, 0x86, 0x99, 0xef, 0x9a, 0x1e, 0xca, 0x4e, 0x3f, 0x8f, 0x3c, 0x16, 0xe5, 0x0f, 0x80, 0x3e, 0x84, 0xb0, 0x88, 0xc6,
0xec, 0xbb, 0x0b, 0xe7, 0xcb, 0x67, 0x24, 0xea, 0xd2, 0xd6, 0x37, 0x3b, 0xa8, 0x87, 0x7a, 0x9c, 0x76, 0xad, 0x2e, 0x3a, 0x38, 0xd6, 0x18, 0xa7,
0x01, 0x5d, 0x90, 0xed, 0xe7, 0xce, 0x21, 0x48, 0xad, 0x08, 0x03, 0x33, 0xf1, 0xfb, 0x58, 0xc2, 0x35, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02,
0xf0, 0x01, 0x1d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4, 0x48, 0xe2, 0x06, 0xb4, 0x72, 0x32, 0x05, 0x63, 0x79,
0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x41, 0xe4, 0x32, 0xfb, 0x49, 0xd0, 0xd3, 0x09, 0x16, 0x99, 0x9c, 0x19, 0xce, 0xf7, 0xf8, 0x4e,
0xb3, 0x43, 0xcc, 0x16, 0x64, 0x55, 0xb7, 0xb2, 0x41, 0xa8, 0xe8, 0x1a, 0x2d, 0x52, 0x89, 0x29, 0xa0, 0xdb, 0x4e, 0x09, 0x01, 0xd2, 0x8a, 0x2f,
0x3e, 0x5a, 0x8c, 0x02, 0x74, 0xb5, 0xf0, 0x24, 0xb6, 0x91, 0x79, 0xd8, 0x85, 0x6e, 0x0e, 0xfe, 0x07, 0x8c, 0x27, 0xd8, 0x66, 0x96, 0xf1, 0x5d,
0x1a, 0xc8, 0x5d, 0x3d, 0x28, 0x9a, 0x6f, 0x8f, 0x5f, 0xbf, 0xf2, 0xef, 0xc6, 0x3b, 0x3c, 0x18, 0x50, 0xc7, 0xd3, 0x78, 0xd7, 0x52, 0x67, 0x6d,
0xac, 0x47, 0x6a, 0x95, 0x02, 0x47, 0x19, 0x61, 0x47, 0x54, 0xa3, 0xe4, 0xe0, 0x4e, 0x85, 0xd5, 0x91, 0x1c, 0x40, 0x36, 0xc2, 0xa1, 0xcb, 0x5a,
0x7a, 0x25, 0x78, 0xee, 0xed, 0xc3, 0xf4, 0x35, 0xba, 0xaf, 0x14, 0xa1, 0xcf, 0xd2, 0x2c, 0x2c, 0x58, 0x8b, 0x02, 0xcc, 0xb4, 0x48, 0x0a, 0x0c,
0x43, 0x4a, 0xce, 0xdc, 0x5f, 0x1d, 0x3c, 0xf4, 0xc3, 0x96, 0x17, 0xe8, 0x74, 0x38, 0x22, 0x73, 0x12, 0x1d, 0x04, 0x6a, 0x6f, 0x9b, 0x5e, 0xf2,
0x69, 0x96, 0xb6, 0x03, 0x68, 0x29, 0x7e, 0x67, 0xe3, 0xca, 0x67, 0x63, 0xd0, 0x4c, 0x92, 0x56, 0x6f, 0x87, 0x8b, 0x14, 0x77, 0x44, 0xbf, 0xba,
0x3c, 0xda, 0x45, 0x47, 0x4b, 0x44, 0x05, 0xc0, 0x1a, 0x23, 0x1f, 0x60, 0x47, 0x4c, 0x87, 0x3e, 0xb8, 0x40, 0x5a, 0x09, 0x90, 0xdb, 0xc9, 0xd4,
0x77, 0x14, 0x62, 0x37, 0x50, 0x41, 0x17, 0x2b, 0x2b, 0x4c, 0xec, 0x44, 0xd1, 0xdd, 0x0e, 0xf1, 0x63, 0x7a, 0x2d, 0x74, 0xef, 0xa7, 0x67, 0x5a,
0x7d, 0xf8, 0x02, 0x5b, 0xed, 0x10, 0xd5, 0xdc, 0x52, 0xe2, 0x59, 0x45, 0xd2, 0x52, 0x1e, 0x46, 0x39, 0xfa, 0xc3, 0x67, 0xce, 0x90, 0x90, 0x10,
0xc2, 0x35, 0x00, 0x2e, 0x00, 0x01, 0x00, 0x00, 0x02, 0xf0, 0x00, 0x9d, 0x00, 0x01, 0x05, 0x03, 0x00, 0x00, 0x03, 0x84, 0x49, 0x58, 0xad, 0xb4,
0x48, 0xe2, 0x06, 0xb4, 0xf1, 0x38, 0x05, 0x63, 0x79, 0x6e, 0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x4c, 0x17, 0x84, 0x17, 0xd5, 0xc8, 0x23,
0xd5, 0xdd, 0xe0, 0x6e, 0xc8, 0xec, 0x1a, 0xa3, 0x1d, 0x56, 0x1e, 0x14, 0x33, 0x6a, 0x71, 0x6a, 0x7c, 0xd7, 0xef, 0x06, 0x34, 0x6d, 0x21, 0x1a,
0x8f, 0x49, 0xb9, 0x2f, 0xa0, 0x66, 0x07, 0x11, 0xc8, 0xb3, 0xe6, 0xeb, 0x3c, 0x05, 0x50, 0x3f, 0xad, 0x0b, 0x26, 0x07, 0xaa, 0x07, 0x11, 0x4b,
0x00, 0x1c, 0xba, 0x99, 0x27, 0x1b, 0xda, 0xdc, 0x78, 0xe3, 0xab, 0xc7, 0x5f, 0xdb, 0x1f, 0xe2, 0xa0, 0xc9, 0x8d, 0x1e, 0x07, 0x08, 0xd4, 0x9b,
0x80, 0x3c, 0x85, 0x91, 0x2b, 0x08, 0xcf, 0x04, 0x83, 0x18, 0x07, 0x7a, 0x1c, 0xd2, 0x5f, 0xa2, 0xa8, 0x4a, 0x43, 0xde, 0x78, 0x33, 0x42, 0x94,
0x9c, 0xd5, 0x97, 0x3a, 0x66, 0xfe, 0x6d, 0x7b, 0x0f, 0x12, 0x3c, 0xf5, 0xa0, 0xeb, 0xd1, 0x04, 0x57, 0x14, 0x40, 0x0f, 0x72, 0x73, 0x09, 0xf4,
0xff, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00

};

//////////////////
// DNSSEC - Part 2
//////////////////

static const unsigned char Dnssec_part2[] = {

0xbd, 0xc0, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x00, 0x05, 0x07, 0x6d, 0x6f, 0x6e, 0x61, 0x64, 0x69, 0x63, 0x05, 0x63, 0x79, 0x6e,
0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x15, 0x00, 0x04, 0x7d,
0x64, 0x7e, 0xca, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc0, 0x14, 0xc0, 0x14, 0x00,
0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x32, 0xc0, 0x14, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91,
0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x33, 0xc0, 0x14, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73,
0x31, 0xc0, 0x14, 0xc0, 0x75, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0x7d, 0x64, 0x7e, 0xcd, 0xc0, 0x51, 0x00, 0x01, 0x00,
0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0xc7, 0xaf, 0x89, 0xd5, 0xc0, 0x63, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0xcb,
0x8d, 0x99, 0x16, 0xc0, 0x3f, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0x7a, 0x67, 0xee, 0xba, 0x00, 0x00, 0x29, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00

};

//////////////////
// DNSSEC - Part 3
//////////////////

static const unsigned char Dnssec_part3[] = {

0xc1, 0x18, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x00, 0x05, 0x07, 0x6d, 0x6f, 0x6e, 0x61, 0x64, 0x69, 0x63, 0x05, 0x63, 0x79, 0x6e,
0x69, 0x63, 0x03, 0x6e, 0x65, 0x74, 0x00, 0x00, 0x2c, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x2c, 0x00, 0x01, 0x00, 0x00, 0x01, 0x15, 0x00, 0x16, 0x01,
0x01, 0xf9, 0x0f, 0xd3, 0x96, 0x46, 0x96, 0x8e, 0xa8, 0x15, 0xcc, 0xcb, 0xc8, 0xdf, 0x17, 0xd9, 0x3a, 0x6a, 0x44, 0x75, 0xab, 0xc0, 0x14, 0x00,
0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x34, 0xc0, 0x14, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91,
0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x31, 0xc0, 0x14, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73,
0x33, 0xc0, 0x14, 0xc0, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x06, 0x03, 0x6e, 0x73, 0x32, 0xc0, 0x14, 0xc0, 0x63, 0x00,
0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0x7d, 0x64, 0x7e, 0xcd, 0xc0, 0x87, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00,
0x04, 0xc7, 0xaf, 0x89, 0xd5, 0xc0, 0x75, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0xcb, 0x8d, 0x99, 0x16, 0xc0, 0x51, 0x00,
0x01, 0x00, 0x01, 0x00, 0x02, 0x91, 0x70, 0x00, 0x04, 0x7a, 0x67, 0xee, 0xba, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

};

////////////////////
// Initial UDP Response - with TC bit set.  Triggers TCP request from Client
//
// QUESTION: wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.
//           wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.
//           wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.
//           comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww
// TYPE:  A
// CLASS: IN
////////////////////

static unsigned char       g_Too_Big_Legal_Buffer_TCP[] = {

0x31, 0x84, 0x83, 0x80, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
0x3f, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x3f, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x3f, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x3d, 0x63, 0x6f, 0x6d, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
0x77, 0x77, 0x00, 0x00, 0x01, 0x00, 0x01, 0xc0, 0x0c, 0x00, 0x01, 0x00,
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd8, 0x3a, 0xc1, 0x4e

};


////////////////////
// Template (RR) Response Record - copied over-and-over
////////////////////


static unsigned char       g_Too_Big_Legal_Buffer_TCP_Answer[] = {

0xc0, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
0xd8, 0x3a, 0xc1, 0x4e

};


static
nn::socket::ResolverOption DisableDnsCache()
{
    nn::socket::ResolverOption   myOption;

    NN_LOG( "DisableDnsCache() - Begin\n" );
    myOption.key = static_cast<nn::socket::ResolverOptionKey>( nn::socket::ResolverOptionKey::RequestEnableDnsCacheBoolean );
    myOption.type = nn::socket::ResolverOptionType::Boolean;
    myOption.size = sizeof(bool);
    myOption.data.booleanValue = false;
    NN_LOG( "DisableDnsCache() - End\n" );

    return myOption;
}


static void
StartLookbackDnsServer( void * inArg )
{
    // Tell Log we are done
    NN_LOG( "[Loopback DNS server]: Thread starting\n" );

    LoopbackDnsServer * loopbackDnsServer = (LoopbackDnsServer *) inArg;

    // Start the DNS Server Main Loop
    loopbackDnsServer->Start( (void *) NULL);

    // Tell Log we are done
    NN_LOG( "[Loopback DNS server]: Thread exiting\n" );
}



static bool
InitializeTesting()
{
    nn::Result                result;
    int                       rc;
    bool                      isSuccess = true, rval;

    NN_LOG( "In\n\n" );

#ifdef ENABLE_FAILING_TESTS
NN_LOG("** TestModeVerbose is ENABLED **\n");
#endif

    // Initialize work var
    g_WorkVaruchar = false;

    ///////////////////////////
    //// Test Counts: Initialize
    ///////////////////////////

    INITIALIZE_TEST_COUNTS;


    ///////////////////////////
    //// NIFM Library: Initialize
    ///////////////////////////

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Nifm | NATF::API::TestSetupOptions_Socket), "TestSetup failed.");

    // NIFM: Network Interface is Online
    NN_LOG( "====================================\n" );
    NN_LOG( "NIFM: Network ===>  O N L I N E <===\n" );
    NN_LOG( "====================================\n" );


    ///////////////////////////
    ////  Allocate DNS Server
    ///////////////////////////

    g_loopbackDnsServer = new LoopbackDnsServer();
    if ( g_loopbackDnsServer == NULL )
    {
        NN_LOG( "Failed to allocate a LoopbackDnsServer.  Can't start Loopback port DNS Server\n" );
        goto out;
    }

    ///////////////////////////
    ////  Change DNS Server Address - to (loopback)
    ///////////////////////////

    rval = g_loopbackDnsServer->SetDnsResolver( "127.0.0.1", 8053 );
    ERROR_IF( rval != true, "Failed calling LoopbackDnsServer::SetDnsResolver" );

    ///////////////////////////
    //// Threaded DNS Server
    ///////////////////////////

    NN_LOG( "===> Starting [loopback] DNS Server\n" );

    // Create: ThreadedTest
    g_pThreadedTest = new ThreadedController();
    if ( g_pThreadedTest == NULL )
    {
        NN_LOG( "new fail allocating a 'new' ThreadedController\n" );
        goto out;
    }

    // Allocate 1 slot
    g_pThreadedTest->Initialize( kMaxNumberOfThreads );

    // Create a thread to run the Server in
    rc = g_pThreadedTest->CreateThread( &StartLookbackDnsServer, (void *) g_loopbackDnsServer, kThreadPriority );
    if ( rc < 0 )
    {
        NN_LOG( "Failed to create and start DNS Server (thread)!\n" );
        goto out;
    }

    NN_LOG( "Successfully started DNS Server" );

    // Give Thread time to start
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));

    return( true );

out:

    // If the loopback DNS server is allocated
    if ( g_loopbackDnsServer != NULL )
    {
        delete g_loopbackDnsServer;
        g_loopbackDnsServer = NULL;
    }

    return( false );
}


static bool
CallGetAddrInfo( const char *in_domainname, nn::socket::AddrInfo *out_resp, nn::socket::AiErrno * out_error )
{

    nn::socket::SockAddrIn      *ipv4 = nullptr;
    nn::socket::AddrInfo         *respIdx = nullptr, hints = {};

    // Disable DNS Cache
    nn::socket::ResolverOption   myOption = DisableDnsCache();

    // Set GAI Hints
    memset( (char *) &hints, 0, sizeof( hints ) );
    hints.ai_family   = nn::socket::Family::Af_Inet;

    hints.ai_family   = nn::socket::Family::Af_Inet;
    hints.ai_socktype = nn::socket::Type::Sock_Stream;
    hints.ai_flags    = nn::socket::AddrInfoFlag::Ai_CanonName;

    *out_error = nn::socket::GetAddrInfo( in_domainname, 0, &hints, &out_resp, &myOption, 1 );
    if ( *out_error != nn::socket::AiErrno::EAi_Success )
    {
        NN_LOG( "nn::socket::GetAddrInfo() Failed with: errno: %d, h_errno: %d, hstrerror: %s\n",
                 nn::socket::GetLastError(), *(nn::socket::GetHError() ),
                 nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
       goto out;
    }

    for ( respIdx = out_resp; respIdx; respIdx = respIdx->ai_next)
    {
        ipv4 = (nn::socket::SockAddrIn *) (respIdx->ai_addr);

        NN_LOG( "Family: %d, Socktype: %d, Protocol: %d, Flags: 0x%0x, IPAddr: %s, Port: %d, Name: %s\n",
                respIdx->ai_family, respIdx->ai_socktype, respIdx->ai_protocol,
                respIdx->ai_flags, nn::socket::InetNtoa( ipv4->sin_addr ),
                nn::socket::InetNtohs( ipv4->sin_port ), respIdx->ai_canonname );
    }

    return( true );

out:

    return( false );
}


static bool
CallGetHostByName( const char * in_domainname )
{
    nn::socket::HostEnt * respHosts = nullptr;
    nn::socket::InAddr ** addr_list = nullptr;
    int                 idx;

    // Disable DNS Cache
    nn::socket::ResolverOption   myOption = DisableDnsCache();

    respHosts = nn::socket::GetHostEntByName( in_domainname, &myOption, 1 );
    if ( respHosts == NULL )
    {
        NN_LOG( "nn::socket::GetHostByName() Failed with: errno: %d, h_errno: %d, hstrerror: %s\n",
                 nn::socket::GetLastError(), *(nn::socket::GetHError() ),
                 nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
        goto out;
    }
    else
    {
        NN_LOG( "Host name       : [%s]\n", respHosts->h_name );
        NN_LOG( "Address Type    : [%d]\n", respHosts->h_addrtype );
        NN_LOG( "Len of Addr     : [%d]\n", respHosts->h_length );

        for(idx = 0; respHosts->h_aliases[idx] != NULL; idx++)
        {

           NN_LOG( "Alias: [%s]\n", respHosts->h_aliases[idx] );
        }

        addr_list = (nn::socket::InAddr **) respHosts->h_addr_list;
        for(idx = 0; addr_list[idx] != NULL; idx++)
        {

           NN_LOG( "IP Address: [%s]\n", nn::socket::InetNtoa( (*addr_list[idx] ) ) );
        }

        NN_LOG( "There are a total of [%d] IPv4 Addresses\n", idx );
    }

    return( true );

out:

    return( false );
}

static bool
TeardownTesting()
{
     bool    isSuccess = true;

    ///////////////////
    //// Stop DNS Server
    ////////////////////

    NN_LOG( "Stopping DNS Server\n" );

    // If the loopback DNS server is allocated
    if ( g_loopbackDnsServer != NULL )
    {
        g_loopbackDnsServer->Stop();
        delete g_loopbackDnsServer;
        g_loopbackDnsServer = NULL;
    }

    // Wait DNS Server threads to die
    g_pThreadedTest->WaitAllThreads();

    // Destroy all Threads
    g_pThreadedTest->DestroyAllThreads();

    // Delete Object Pointer
    delete g_pThreadedTest;
    g_pThreadedTest = NULL;

    NN_LOG( "DNS Server successfully stopped!\n" );


    ////////////////////
    ////  Stop Testing
    ////////////////////

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed.");

out:

    ////////////////////
    ////  Print Test Counts
    ////////////////////

    PRINT_TEST_COUNTS;

    EXPECT_EQ( isSuccess, true );

    NN_LOG( "Out\n\n" );

    return( true );
}

TEST(ApiUnit,DnsResponse_Initialize)
{
    InitializeTesting();
}


TEST(ApiUnit,DnsResponse_Various_Stuff)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval, isSuccess = true;

    // Normal DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( g_loopbackDnsServer->MakeDnsResponseCB );

    ///////////////////
    // Simple Google
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Google] Simple\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == false, "GAI - Valid query asked for over UDP, but GAI did not process the data!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] Simple\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == false, "GHBN - Valid query asked for over UDP, but GHBN did not process the data!" );

    ///////////////////
    // Response 505 -- UDP with TC (part1) then TCP response (part2)
    ///////////////////

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Response505_part1;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Response505_part1 );

    // TCP: cisum.org (without) TC bit set
    g_loopbackDnsServer->TCPResponse = (unsigned char *) Response505_part2;
    g_loopbackDnsServer->TCPResponseLen = sizeof( Response505_part2 );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Response505] Simple\n" );
    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == false, "GAI - Valid query asked for over TCP, but GAI did not process the data!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Response505] Simple\n" );
    rval = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org" );
    ERROR_IF_AND_COUNT( rval == true, "GHBH - Valid query asked for over TCP, but GHBN did not process the data!" );

    ///////////////////
    // Google with Truncated Response
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_truncated_response_buffer;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_truncated_response_buffer );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Google] truncated buffer response\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI processed (WRONG ANSWER) to DNS Question - should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] truncated buffer response\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN processed (WRONG ANSWER) to DNS Question - should have failed!" );

    ///////////////////////////////////////
    //// Return WRONG response via TCP
    ///////////////////////////////////////

    // UDP: Google with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple_with_TC;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple_with_TC );

    // TCP: cisum.org (without) TC bit set
    g_loopbackDnsServer->TCPResponse = (unsigned char *) Response505_part1;
    g_loopbackDnsServer->TCPResponseLen = sizeof( Response505_part1 );

    /////////////////////////
    // GetAddrInfo()
    /////////////////////////

    NN_LOG( "Query: [GetAddrInfo][Google] Returns wrong answer\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI processed (WRONG ANSWER) to DNS Question - should have failed!" );

    /////////////////////////
    // GetHostByName()
    /////////////////////////

    NN_LOG( "Query: [GetHostByName][Google] Returns wrong answer\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN processed (WRONG ANSWER) to DNS Question - should have failed!" );

    ///////////////////
    // Simple Google - EDNS0 with 4k buffer
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) SimpleGoogleEDNS04k;
    g_loopbackDnsServer->UDPResponseLen = sizeof( SimpleGoogleEDNS04k );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Google] EDNS0 with 4k Buffer\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [Google wrap around pointer] - but actually passed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] EDNS0 with 4k Buffer\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [EDNS0 4k Buffer] - but actually passed!" );

    ///////////////////
    // Simple Google -
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_Label_Endless_Pointer_Bug;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_Label_Endless_Pointer_Bug );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Google] with endless recursive wrap around pointer\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [Google wrap around pointer] - but actually passed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] with endless recursive wrap around pointer\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN should have failed testing [Google wrap around pointer] - but actually passed!" );

    ///////////////////
    // Google - Query for (ANY) record type
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_any;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_any );

    // GetAddrInfo()
    NN_LOG( "Query: [getAddrInfo][Google] (ANY) Resource Record\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [Google ANY record type] - but actually passed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] (ANY) Resource Record\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN should have failed testing [Google ANY record type] - but actually passed!" );

    ///////////////////
    // Google - Bad Label offset
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_Bad_Label_Offset;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_Bad_Label_Offset );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][Google] (Bad Label Offset) Resource Record\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [Google Bad Label] - but actually passed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google] (Bad Label Offset) Resource Record\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN should have failed testing [Google Bad Label] - but actually passed!" );
    nTestsPassing++;

    ///////////////////
    // HP - (ANY) record type
    ///////////////////

    // UDP: hp.com with TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) HP_com_manyanswers;
    g_loopbackDnsServer->UDPResponseLen = sizeof( HP_com_manyanswers );

    // TCP: hp.com (without) TC bit set
    g_loopbackDnsServer->TCPResponse = (unsigned char *) HPTCPWithFullResponse;
    g_loopbackDnsServer->TCPResponseLen = sizeof( HPTCPWithFullResponse );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][HP.com] (ANY) Resource Record\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI should have failed testing [hp.com] - but actually passed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][Google]  (ANY) Resource Record\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN should have failed testing [hp.com] - but actually passed!" );

    ///////////////////
    // HP - Full Response
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) HPTCPWithFullResponse;
    g_loopbackDnsServer->UDPResponseLen = sizeof(  HPTCPWithFullResponse );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][HP.com] Full Response\n" );
    rval = CallGetAddrInfo( "hp.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == false )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT( rval == true, "GAI passed testing [hp.com ANY] - but should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][HP.com] Full Response\n" );
    rval = CallGetHostByName( "hp.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN passed testing [hp.com] - but should have failed!" );

    ///////////////////
    // DNSSEC: Root Key Anchors
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) DNSSECRootKeyTrustAnchors;
    g_loopbackDnsServer->UDPResponseLen = sizeof( DNSSECRootKeyTrustAnchors );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][DNSSEC] Trust Anchors\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT(  rval == true, "GAI successfully processed DNSSEC Trust Anchors, but should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][DNSSEC] Trust Anchors\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT(  rval == true, "GHBN successfully processed DNSSEC Trust Anchors, but should have failed!" );

    ///////////////////
    // DNSSEC: Response - Part1
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Dnssec_part1;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Dnssec_part1 );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][DNSSEC] Response - Part 1\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT(  rval == true, "GAI successfully processed a DNSSEC response, but should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][DNSSEC] Response - Part 1\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT(  rval == true, "GHBN successfully processed a DNSSEC response, but should have failed!" );

    ///////////////////
    // DNSSEC: Response - Part2
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Dnssec_part2;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Dnssec_part2 );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][DNSSEC] Response - Part 2\n" );
    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT(  rval == true, "GAI successfully processed a DNSSEC response, but should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][DNSSEC] Response - Part 2\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT(  rval == true, "GHBN successfully processed a DNSSEC response, but should have failed!" );

    ///////////////////
    // DNSSEC: Response - Part3
    ///////////////////

    g_loopbackDnsServer->UDPResponse = (unsigned char *) Dnssec_part3;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Dnssec_part3 );

    // GetAddrInfo()
    NN_LOG( "Query: [GetAddrInfo][DNSSEC] Response - Part 3\n" );
    rval = CallGetAddrInfo( "google.com",out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    ERROR_IF_AND_COUNT(  rval == true, "GAI successfully processed a DNSSEC response, but should have failed!" );

    // GetHostByName()
    NN_LOG( "Query: [GetHostByName][DNSSEC] Response - Part 3\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT(  rval == true, "GHBN successfully processed a DNSSEC response, but should have failed!" );

    ///////////////////
    //  D O N E
    ///////////////////

out:

    return;
}  // NOLINT(impl/function_size)


static int
Wrong_Answer_Over_TCP( void *                  inArg,
                       unsigned char *         dnsRqst,
                       size_t &                dnsRqstLen,
                       unsigned char *         dnsResp,
                       size_t &                dnsRespLen,
                       bool *                  isUDP,
                       bool *                  shouldContinue )
{
    int                   bytesSent, bytesLeft, rc;
    uint16_t              savedLen, actualLen;
    LoopbackDnsServer *   thisObj = (LoopbackDnsServer *) inArg;

    // Process UDP normally
    if ( *isUDP == true )
    {
        return( g_loopbackDnsServer->MakeDnsResponseCB( thisObj, dnsRqst, dnsRqstLen, dnsResp, dnsRespLen, isUDP, shouldContinue )  );
    }

    // Else.. TCP
    *shouldContinue = false;

    // Save Wrong Question, Wrong Answer and Wrong Transaction ID
    memcpy( dnsResp, Response505_part1, sizeof( Response505_part1 ) );
    actualLen = (uint16_t) sizeof( Response505_part1 );

    // Write Len Bytes
    NN_LOG( "[GHBN_Wrong_Answer_Over_TCP]: Writing bad TCP DNS Response Len Bytes (Value: %d)\n", actualLen );
    savedLen = nn::socket::InetHtons( (uint16_t) actualLen );
    rc = nn::socket::Write( thisObj->acceptedTCP, (char *) &savedLen, 2 );

    // Write DNS Response Message
    bytesSent = 0;
    bytesLeft = actualLen;
    while( bytesLeft > 0 )
    {
        rc = nn::socket::Write( thisObj->acceptedTCP, &dnsResp[bytesSent], bytesLeft );
        if ( rc < 0 )
        {
            NN_LOG( "acceptedTCP: nn::socket::Write() Failed - Errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }

        NN_LOG( "Write: %d bytes to client...\n", rc );

        bytesSent = bytesSent + rc;
        bytesLeft = bytesLeft - rc;
    }

    NN_LOG( "Total Bytes Written to Client): %d ...\n", bytesSent );

    return( 0 );

out:

    return( -1 );

}

TEST(ApiUnit,DnsResponse_Wrong_Answer_Over_TCP)
{

NN_UNUSED(kMaxUDPPacketSize);
NN_UNUSED(kMaxTCPPacketSize);
NN_UNUSED(kMaxResourceRecordSize);
NN_UNUSED(g_WorkVaruint32_t);
NN_UNUSED(g_WorkVarint_t);
NN_UNUSED(g_workVarBool);
NN_UNUSED(Google_com_simple);
NN_UNUSED(Google_com_Bad_Label_Offset);
NN_UNUSED(Google_com_Label_Endless_Pointer_Bug);
NN_UNUSED(SimpleGoogleEDNS04k);
NN_UNUSED(Google_com_truncated_response_buffer);
NN_UNUSED(DNSSECRootKeyTrustAnchors);
NN_UNUSED(Google_com_any);
NN_UNUSED(HP_com_manyanswers);
NN_UNUSED(HPTCPWithFullResponse);
NN_UNUSED(Response505_part1);
NN_UNUSED(Response505_part2);
NN_UNUSED(Dnssec_part1);
NN_UNUSED(Dnssec_part2);
NN_UNUSED(Dnssec_part3);
NN_UNUSED(g_Too_Big_Legal_Buffer_TCP);
NN_UNUSED(g_Too_Big_Legal_Buffer_TCP_Answer);
NN_UNUSED(CallGetAddrInfo);

    bool              isSuccess = true, rval;

    // Set DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Wrong_Answer_Over_TCP );

    // UDP: Google with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple_with_TC;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple_with_TC );

    NN_LOG( "Query: [GetHostByName][Google] Returns wrong answer\n" );
    rval = CallGetHostByName( "google.com" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN processed (WRONG ANSWER) to DNS Question - should have failed!" );

out:

    return;
}


static int
Google_com_Bad_Response_Len( void *              inArg,
                             unsigned char *     dnsRqst,
                             size_t &            dnsRqstLen,
                             unsigned char *     dnsResp,
                             size_t &            dnsRespLen,
                             bool *              isUDP,
                             bool *              shouldContinue )
{
    struct DNS_HEADER_REC *    pDnsHeader;
    uint16_t                   saveId;
    LoopbackDnsServer *        thisObj = (LoopbackDnsServer *) inArg;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsRqst[0];
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Fill in the right Response
    memset( dnsResp, 0, dnsRespLen );

    // Work var initialized in (other) thread
    g_WorkVaruint32_t++;
    if (  g_WorkVaruint32_t < thisObj->UDPResponseLen )
    {
        memcpy( dnsResp, thisObj->UDPResponse, g_WorkVaruint32_t );
        dnsRespLen = g_WorkVaruint32_t;
    }
    else
    {
        memcpy( dnsResp,thisObj->UDPResponse, thisObj->UDPResponseLen );
        dnsRespLen    = thisObj->UDPResponseLen;
        g_workVarBool = false;
    }

    // Fix DNS Response
    pDnsHeader = (struct DNS_HEADER_REC *) dnsResp;
    pDnsHeader->Id = nn::socket::InetHtons( saveId );

    return( 0 );
}


TEST(ApiUnit,DnsResponse_Google_com_Bad_Response_Len)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval, isSuccess = true;

    // Signal for Cancel Thread..
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Google_com_Bad_Response_Len );

    // Simple Google
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple );

    // Initialize Work Vars
    g_WorkVaruint32_t = 2;
    g_workVarBool     = true;

    // For Idx = 2 to End of DNS Request
    while( g_workVarBool == true )
    {
        // GetAddrInfo()
        rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
        NN_LOG( "out_error: %d\n", out_error );
        if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

        // GetHostByName()
        rval = CallGetHostByName( "google.com" );
        ERROR_IF_AND_COUNT(  rval == true && g_workVarBool == true,
                             "GHBN successfully processed a google response, but should have failed!" );
    }

    // Test Passed
    nTestsPassing++;

out:

    return;
}


static int
Google_com_Bad_Data( void *              inArg,
                     unsigned char *     dnsRqst,
                     size_t &            dnsRqstLen,
                     unsigned char *     dnsResp,
                     size_t &             dnsRespLen,
                     bool *              isUDP,
                     bool *              shouldContinue )
{
    struct DNS_HEADER_REC *    pDnsHeader;
    uint16_t                   saveId;
    LoopbackDnsServer *        thisObj = (LoopbackDnsServer *) inArg;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) dnsRqst;
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Fill in the right Response
    memset( dnsResp, 0, dnsRespLen );

    // Copy and Place (bad value) into Buffer
    g_WorkVaruint32_t++;
    if (  g_WorkVaruint32_t < thisObj->UDPResponseLen )
    {
        memcpy( dnsResp, thisObj->UDPResponse, thisObj->UDPResponseLen );
        NN_LOG( "Value: %d written at positon: %d\n", g_WorkVaruchar, g_WorkVaruint32_t );
        dnsResp[g_WorkVaruint32_t] = g_WorkVaruchar;
        dnsRespLen                 = thisObj->UDPResponseLen;
    }
    else
    {
        memcpy( dnsResp, thisObj->UDPResponse, thisObj->UDPResponseLen );
        dnsRespLen = thisObj->UDPResponseLen;
        g_workVarBool = false;
    }

    // Fix DNS Response
    pDnsHeader = (struct DNS_HEADER_REC *) dnsResp;
    pDnsHeader->Id = nn::socket::InetHtons( saveId );

    return( 0 );
}


TEST(ApiUnit,DnsResponse_Google_com_Bad_Data_HighValues)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval;

    // Normal DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Google_com_Bad_Data );

    // Simple Google
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple );

    // Initialize Work Vars
    g_WorkVaruint32_t = 2;
    g_workVarBool     = true;
    g_WorkVaruchar    = 0xFF;

    //////////////////
    // High Values = 0xFF
    //////////////////

    // For Idx = 2 to End of DNS Request
    while( g_workVarBool == true )
    {
        // Make GAI call
        rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
        NN_LOG( "out_error: %d\n", out_error );

        // Free Returned Responsr
        if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    }

    // Test Passed
    nTestsPassing++;

    return;
}


TEST(ApiUnit,DnsResponse_Google_com_Bad_Data_LowValues)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval = false;

    // Normal DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Google_com_Bad_Data );

    // Simple Google
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple );

    // Initialize Work Vars
    g_WorkVaruint32_t = 2;
    g_workVarBool     = true;
    g_WorkVaruchar    = 0x00;

    //////////////////
    // Low Values = 0x00
    //////////////////

    // For Idx = 2 to End of DNS Request
    while( g_workVarBool == true )
    {
        // Make GAI call
        rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
        NN_LOG( "out_error: %d\n", out_error );

        // Free Returned Responsr
        if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    }

    // Test Passed
    nTestsPassing++;

    return;
}


static int
Too_Big_Bad_Buffer_UDP( void *              inArg,
                        unsigned char *     dnsRqst,
                        size_t &            dnsRqstLen,
                        unsigned char *     dnsResp,
                        size_t &            dnsRespLen,
                        bool *              isUDP,
                        bool *              shouldContinue )
{
    size_t                     dnsPtrLen = 9000;    // UDP "Jumbo" Max Packet Size
    unsigned char *            dnsPtr = NULL;
    struct DNS_HEADER_REC *    pDnsHeader;
    uint16_t                   saveId;
    ssize_t                    rc1;
    // LoopbackDnsServer *        thisObj = (LoopbackDnsServer *) inArg;

    // Don't continue.. This routine is handling the response
    *shouldContinue = false;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsRqst[0];
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Allocate a large chunk of memory
    dnsPtr = (unsigned char *) malloc( dnsPtrLen );
    if ( dnsPtr == NULL )
    {
        NN_LOG( "Failed to allocate: %d bytes of memory\n", dnsPtrLen );
        goto out;
    }

    // Set the memory to HIGH Values
    memset( dnsPtr, 0, dnsPtrLen );

    // Restore Transaction ID
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsPtr[0];
    pDnsHeader->Id = nn::socket::InetHtons( saveId );


    for( ; ; )
    {
       // DNS Response (From) this Server
       g_loopbackDnsServer->recvAddrSize = sizeof( nn::socket::SockAddrIn );
       rc1 = nn::socket::SendTo( g_loopbackDnsServer->serverUDP, dnsPtr, dnsPtrLen, nn::socket::MsgFlag::Msg_None,
                (nn::socket::SockAddr *) &g_loopbackDnsServer->recvAddr, g_loopbackDnsServer->recvAddrSize );

       NN_LOG( "UDP: SendTo rc = %ld\n", rc1 );

       if ( rc1 > 0 ) break;

       if ( rc1 < 0 && nn::socket::GetLastError() == nn::socket::Errno::EMsgSize ) {
           dnsPtrLen = dnsPtrLen - 2048;
           continue;
       }

       if ( rc1 < 0 )
       {
           NN_LOG( "DNS UDP: SendTo(): Failed - errno: %d\n", nn::socket::GetLastError() );
           goto out;
       }
    }

    // Free allocated memory
    free( dnsPtr );
    dnsPtr = NULL;


    return( 0 );

out:

    // Free allocated memory
    if ( dnsPtr != NULL )
    {
        free( dnsPtr );
        dnsPtr = NULL;
    }

    return( -1 );
}


TEST(ApiUnit,DnsResponse_Too_Big_Bad_Buffer_UDP)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval = false;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Too_Big_Bad_Buffer_UDP );

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) &Response505_part1[0];
    g_loopbackDnsServer->UDPResponseLen = sizeof( Response505_part1 );

    rval = CallGetAddrInfo( "google.com", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );

    // Free Returned Response
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    return;
}


static int
Too_Big_Bad_Buffer_TCP( void *              inArg,
                        unsigned char *     dnsRqst,
                        size_t &            dnsRqstLen,
                        unsigned char *     dnsResp,
                        size_t &            dnsRespLen,
                        bool *              isUDP,
                        bool *              shouldContinue )
{
    unsigned char *            dnsPtr;
    struct DNS_HEADER_REC *    pDnsHeader;
    size_t                     dnsPtrLen = kMaxTCPPacketSize;    // Max TCP Response Size (bytes)
    int                        bytesSent, bytesLeft, rc;
    uint16_t                   saveId, dnsLen;
    LoopbackDnsServer *         thisObj = (LoopbackDnsServer *) inArg;

    // Process UDP normally
    if ( *isUDP == true )
    {
        return( thisObj->MakeDnsResponseCB( thisObj, dnsRqst, dnsRqstLen, dnsResp, dnsRespLen, isUDP, shouldContinue )  );
    }

    // Don't continue.. This routine is handling the response
    *shouldContinue = false;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsRqst[0];
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Allocate a large chunk of memory
    dnsPtr = (unsigned char *) malloc( dnsPtrLen );
    if ( dnsPtr == NULL )
    {
        NN_LOG( "Failed to allocate: %d bytes of memory\n", dnsPtrLen );
        goto out;
    }

    // Set the memory to HIGH Values
    memset( dnsPtr, 0x0FF, dnsPtrLen );

    // Restore Transaction ID
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsPtr[0];
    pDnsHeader->Id = nn::socket::InetHtons( saveId );

    // Write (Maximized) Len Bytes ( 0xFFFF )
    NN_LOG( "[GHBN_TCP_Cancel]: Writing bad TCP DNS Response Len Bytes (Value: %d)\n", dnsPtrLen );
    dnsLen = nn::socket::InetHtons( (uint16_t) dnsPtrLen );
    rc = nn::socket::Write( thisObj->acceptedTCP, (char *) &dnsLen, 2 );

    // Write DNS Response Message
    bytesSent = 0;
    bytesLeft = dnsPtrLen;
    while( bytesLeft > 0 )
    {
        rc = nn::socket::Write( thisObj->acceptedTCP, &dnsPtr[bytesSent], bytesLeft );
        if ( rc < 0 )
        {
            NN_LOG( "acceptedTCP: nn::socket::Write() Failed - Errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }

        NN_LOG( "Write: %d bytes to client...\n", rc );

        bytesSent = bytesSent + rc;
        bytesLeft = bytesLeft - rc;
    }

    NN_LOG( "Total Bytes Written to Client): %d ...\n", bytesSent );

    // Free allocated memory
    free( dnsPtr );
    dnsPtr = NULL;

    return( 0 );

out:

    return( -1 );
}


TEST(ApiUnit,DnsResponse_Too_Big_Bad_Buffer_TCP)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval = false;;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Too_Big_Bad_Buffer_TCP );

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Response505_part1;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Response505_part1 );

    // Get GAI
    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );

    // Free Returned Response
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    return;
}


static int
Too_Big_Legal_Buffer_TCP( void *              inArg,
                          unsigned char *     dnsRqst,
                          size_t &            dnsRqstLen,
                          unsigned char *     dnsResp,
                          size_t &            dnsRespLen,
                          bool *              isUDP,
                          bool *              shouldContinue )
{
    unsigned char *            dnsPtr;
    struct DNS_HEADER_REC *    pDnsHeader;
    LoopbackDnsServer *  thisObj = (LoopbackDnsServer *) inArg;

    size_t               answerSize, dnsPtrLen = kMaxTCPPacketSize;    // Max TCP Response Size (bytes)
    int                  bytesSent, bytesToSend, bytesLeft, rc, thisOne;
    int                  idx1, idx2, idx3, idx4, anCount, nsCount, arCount;
    uint16_t             saveId, dnsLen, dnsFinal;


    // Process UDP normally
    if ( *isUDP == true )
    {
        return( thisObj->MakeDnsResponseCB( thisObj, dnsRqst, dnsRqstLen, dnsResp, dnsRespLen, isUDP, shouldContinue )  );
    }

    // Don't continue.. This routine is handling the response
    *shouldContinue = false;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) dnsRqst;
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Allocate a large chunk of memory
    dnsPtr = (unsigned char *) malloc( dnsPtrLen );
    if ( dnsPtr == NULL )
    {
        NN_LOG( "Failed to allocate: %d bytes of memory\n", dnsPtrLen );
        goto out;
    }

    //////////////////
    // Construct Large DNS Response
    //////////////////

    memset( dnsPtr, 0, dnsPtrLen );

    // Start by populating the response buffer with a Simple Response
    memcpy( dnsPtr, g_Too_Big_Legal_Buffer_TCP, sizeof( g_Too_Big_Legal_Buffer_TCP ) );
    dnsLen = sizeof( g_Too_Big_Legal_Buffer_TCP );

    // Restore Transaction ID
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsPtr[0];
    pDnsHeader->Id = nn::socket::InetHtons( saveId );
    pDnsHeader->TC = 0;

    answerSize = sizeof( g_Too_Big_Legal_Buffer_TCP_Answer );
    NN_LOG( "DNS Answer Size: %d\n", answerSize );

    thisOne = -1;
    idx1    = 0; idx2    = 0; idx3    = 0; idx4    = 1;
    anCount = 1; nsCount = 0; arCount = 0;

    while( dnsLen + answerSize < kMaxTCPPacketSize )
    {
        thisOne++;
        if (thisOne > 2 ) thisOne = 0;

        switch( thisOne )
        {
            case 0:  if ( anCount < kMaxResourceRecordSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         anCount++;
                         break;
                     }
                     // Fall Thru on purpose

            case 1:  if ( nsCount < kMaxResourceRecordSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         nsCount++;
                         break;
                     }
                     // Fall Thru on purpose

            default:
            case 2:  if ( arCount < kMaxResourceRecordSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         arCount++;
                         break;
                     }
                     else
                     {
                         NN_LOG( "DNS Header is full!  -- Exiting\n" );
                         break;
                     }
            }

            // Bend stored IP Address to something unique
            idx1++;
            if ( idx1 > 255 ) {
                 idx1 = 0;
                 idx2++;
            }
            if ( idx2 > 255 ) {
                 idx2 = 0;
                 idx3++;
            }
            if ( idx3 > 255 ) {
                 idx3 = 0;
                 idx4++;
            }
            if ( idx4 > 255 ) {
                 idx1 = 0;
                 idx2 = 0;
                 idx3 = 0;
                 idx4 = 0;
            }

            // Store IP Address
            dnsPtr[dnsLen - 1] = idx1; dnsPtr[dnsLen - 2] = idx2; dnsPtr[dnsLen - 3] = idx3; dnsPtr[dnsLen - 4] = idx4;
    }

    // Assign Counts in DNS Header
    pDnsHeader->ancount = nn::socket::InetHtons( anCount );
    pDnsHeader->nscount = nn::socket::InetHtons( nsCount );
    pDnsHeader->arcount = nn::socket::InetHtons( arCount );

    NN_LOG(
    "Resp Dns: Id: %d, OPCODE: %d, QR: %d, AA: %d, TC: %d, RD: %d, RA: %d, AD: %d, CD: %d, rcode: %d, totQ: %d, totA %d, totAut: %d, totAdd: %d\n",
    nn::socket::InetNtohs( pDnsHeader->Id ), pDnsHeader->opcode, pDnsHeader->QR, pDnsHeader->AA, pDnsHeader->TC,
        pDnsHeader->RD, pDnsHeader->RA,  pDnsHeader->AD, pDnsHeader->CD,  pDnsHeader->rcode,
    nn::socket::InetNtohs( pDnsHeader->qdcount ),  nn::socket::InetNtohs( pDnsHeader->ancount ),
        nn::socket::InetNtohs( pDnsHeader->nscount ),  nn::socket::InetNtohs( pDnsHeader->arcount ) );

#ifdef COMMENTED_OUT
    // Display Response in Hex
    bool isReq = false;
    answerSize = dnsLen;
    g_loopbackDnsServer->PrintHex( dnsPtr, answerSize, &isReq, isUDP );
#endif

    // Write Length Bytes
    NN_LOG( "Writing TCP DNS Response Len Bytes (Value: %d)\n", dnsLen );
    dnsFinal = nn::socket::InetHtons( dnsLen );
    rc = nn::socket::Write( g_loopbackDnsServer->acceptedTCP, (char *) &dnsFinal, 2 );

    // Write DNS Response Message
    bytesSent = 0;
    bytesLeft = dnsLen;
    while( bytesLeft > 0 )
    {
        // Sometimes we want a slower Write speed
        bytesToSend = bytesLeft;
        if ( g_workVarBool == true )
        {
            NN_LOG( "Slower write() requested - sleeping 200ms and sending only (up to) 10K\n" );
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(200));
            if ( bytesLeft > 10000 )
            {
                bytesToSend = 10000;
            }
            else
            {
                bytesToSend = bytesLeft;
            }
        }

        rc = nn::socket::Write( g_loopbackDnsServer->acceptedTCP, &dnsPtr[bytesSent], bytesToSend );
        if ( rc < 0 )
        {
            NN_LOG( "acceptedTCP: nn::socket::Write() Failed - Errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }

        NN_LOG( "Write: %d bytes to client...\n", rc );

        bytesSent = bytesSent + rc;
        bytesLeft = bytesLeft - rc;
    }

    NN_LOG( "(Total Bytes Written to Client): %d ...\n", bytesSent );

    // Free allocated memory
    free( dnsPtr );
    dnsPtr = NULL;

    return( 0 );

out:

    if ( dnsPtr != NULL )
    {
        free( dnsPtr );
        dnsPtr = NULL;
    }

    return( -1 );

}   // NOLINT(impl/function_size)


TEST(ApiUnit,DnsResponse_Too_Big_Legal_Buffer_TCP)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    int                     rc = 0;
    bool                    rval;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Too_Big_Legal_Buffer_TCP );

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) g_Too_Big_Legal_Buffer_TCP;
    g_loopbackDnsServer->UDPResponseLen = sizeof( g_Too_Big_Legal_Buffer_TCP );


    // Do a FAST streaming Write
    g_workVarBool = false;

    ///////////////
    // GetAddrInfo
    /////////////

    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww", out_resp, &out_error );

    NN_LOG( "out_error: %d\n", out_error );

    // Free Returned Response
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    ////////////////////////////////////////////
    // GetHostByName
    ////////////////////////////////////////////


    rc = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww" );
    if ( rc < 0 )
    {
        NN_LOG( "GetHostByName Failed with h_errno: %d, errno: %d\n", *(nn::socket::GetHError() ), nn::socket::GetLastError() );

        // Test Failed
        nTestsFailing++;
    }


    return;
}


TEST(ApiUnit,DnsResponse_Too_Big_Legal_Buffer_TCP_Delayed_Write)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    int                     rc = 0;
    bool                    rval = false;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB( g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Too_Big_Legal_Buffer_TCP );

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) g_Too_Big_Legal_Buffer_TCP;
    g_loopbackDnsServer->UDPResponseLen = sizeof( g_Too_Big_Legal_Buffer_TCP );


    // Slowly return TCP data - 10K every 200ms
    g_workVarBool = true;

    ///////////////
    // GetAddrInfo
    /////////////

    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww", out_resp, &out_error );

    NN_LOG( "out_error: %d\n", out_error );

    // Free Returned Response
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    ////////////////////////////////////////////
    // GetHostByName
    ////////////////////////////////////////////

    rc = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww" );
    if ( rc < 0 )
    {
            NN_LOG( "GetHostByName Failed with h_errno: %d, errno: %d\n", *(nn::socket::GetHError() ), nn::socket::GetLastError() );

            // Test Failed
            nTestsFailing++;
    }

    return;
}

static int
Too_Big_Legal_Buffer_UDP( void *              inArg,
                          unsigned char *     dnsRqst,
                          size_t &            dnsRqstLen,
                          unsigned char *     dnsResp,
                          size_t &            dnsRespLen,
                          bool *              isUDP,
                          bool *              shouldContinue )
{
    unsigned char *            dnsPtr = NULL;
    struct DNS_HEADER_REC *    pDnsHeader;

    ssize_t                    rc1;
    size_t                     answerSize, dnsPtrLen = kMaxUDPPacketSize;        // Max UDP Response Size (bytes)
    int                        thisOne;
    int                        idx1, idx2, idx3, idx4, anCount, nsCount, arCount;
    uint16_t                   saveId, dnsLen;
    // LoopbackDnsServer *        thisObj = (LoopbackDnsServer *) inArg;

    // Don't continue.. This routine is handling the response
    *shouldContinue = false;

    // Save DNS Request Transaction Id
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsRqst[0];
    saveId = nn::socket::InetNtohs( pDnsHeader->Id );

    // Allocate a large chunk of memory
    dnsPtr = (unsigned char *) malloc( dnsPtrLen );
    if ( dnsPtr == NULL )
    {
        NN_LOG( "Failed to allocate: %d bytes of memory\n", dnsPtrLen );
        goto out;
    }

    //////////////////
    // Construct Large DNS Response
    //////////////////

    memset( dnsPtr, 0, dnsPtrLen );

    // Start by populating the response buffer with a Simple Response
    memcpy( dnsPtr, g_Too_Big_Legal_Buffer_TCP, sizeof( g_Too_Big_Legal_Buffer_TCP ) );
    dnsLen = sizeof( g_Too_Big_Legal_Buffer_TCP );

    // Restore Transaction ID
    pDnsHeader = (struct DNS_HEADER_REC *) &dnsPtr[0];
    pDnsHeader->Id = nn::socket::InetHtons( saveId );
    pDnsHeader->TC = 0;

    answerSize = sizeof( g_Too_Big_Legal_Buffer_TCP_Answer );
    NN_LOG( "DNS Answer Size: %d\n", answerSize );

    idx1    = 0; idx2    = 0; idx3    = 0; idx4    = 1;
    anCount = 1; nsCount = 0; arCount = 0;

    while( dnsLen + answerSize < kMaxUDPPacketSize )
    {
        thisOne++;
        if (thisOne > 2 ) thisOne = 0;

        switch( thisOne )
        {
            case 0:  if ( anCount < kMaxUDPPacketSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         anCount++;
                         break;
                     }
                     // Fall Thru on purpose

            case 1:  if ( nsCount < kMaxUDPPacketSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         nsCount++;
                         break;
                     }
                     // Fall Thru on purpose

            default:
            case 2:  if ( arCount < kMaxUDPPacketSize )
                     {
                         memcpy( (char *) &dnsPtr[dnsLen], (char *) g_Too_Big_Legal_Buffer_TCP_Answer, answerSize );
                         dnsLen = dnsLen + answerSize;
                         arCount++;
                         break;
                     }
                     else
                     {
                         NN_LOG( "DNS Header is full!  -- Exiting\n" );
                         break;
                     }
            }

            // Bend stored IP Address to something unique
            idx1++;
            if ( idx1 > 255 ) {
                 idx1 = 0;
                 idx2++;
            }
            if ( idx2 > 255 ) {
                 idx2 = 0;
                 idx3++;
            }
            if ( idx3 > 255 ) {
                 idx3 = 0;
                 idx4++;
            }
            if ( idx4 > 255 ) {
                 idx1 = 0;
                 idx2 = 0;
                 idx3 = 0;
                 idx4 = 0;
            }

            // Store IP Address
            dnsPtr[dnsLen - 1] = idx1; dnsPtr[dnsLen - 2] = idx2; dnsPtr[dnsLen - 3] = idx3; dnsPtr[dnsLen - 4] = idx4;
    }

    // Assign Counts in DNS Header
    pDnsHeader->ancount = nn::socket::InetHtons( anCount );
    pDnsHeader->nscount = nn::socket::InetHtons( nsCount );
    pDnsHeader->arcount = nn::socket::InetHtons( arCount );

    NN_LOG(
    "Resp Dns: Id: %d, OPCODE: %d, QR: %d, AA: %d, TC: %d, RD: %d, RA: %d, AD: %d, CD: %d, rcode: %d, totQ: %d, totA %d, totAut: %d, totAdd: %d\n",
    nn::socket::InetNtohs( pDnsHeader->Id ), pDnsHeader->opcode, pDnsHeader->QR, pDnsHeader->AA, pDnsHeader->TC,
        pDnsHeader->RD, pDnsHeader->RA,  pDnsHeader->AD, pDnsHeader->CD,  pDnsHeader->rcode,
    nn::socket::InetNtohs( pDnsHeader->qdcount ),  nn::socket::InetNtohs( pDnsHeader->ancount ),
        nn::socket::InetNtohs( pDnsHeader->nscount ),  nn::socket::InetNtohs( pDnsHeader->arcount ) );

    // DNS Response (From) this Server
    g_loopbackDnsServer->recvAddrSize = sizeof( nn::socket::SockAddrIn );
    rc1 = nn::socket::SendTo( g_loopbackDnsServer->serverUDP, dnsPtr, dnsLen, nn::socket::MsgFlag::Msg_None,
                              (nn::socket::SockAddr *) &g_loopbackDnsServer->recvAddr, g_loopbackDnsServer->recvAddrSize );
    NN_LOG( "UDP: SendTo rc = %ld\n", rc1 );

    if ( rc1 < 0 )
    {
        NN_LOG( "DNS UDP: SendTo(): Failed - errno: %d\n", nn::socket::GetLastError() );
        goto out;
    }

    // Free allocated memory
    free( dnsPtr );
    dnsPtr = NULL;

    return( 0 );

out:

    // Free allocated memory
    if ( dnsPtr != NULL )
    {
        free( dnsPtr );
        dnsPtr = NULL;
    }


    return( -1 );

}    // NOLINT(impl/function_size)


TEST(ApiUnit,DnsResponse_Too_Big_Legal_Buffer_UDP)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB(  g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB( Too_Big_Legal_Buffer_UDP );

    /////////////////////
    ////  GetAddrInfo
    /////////////////////

    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww", out_resp, &out_error );

    NN_LOG( "out_error: %d\n", out_error );

    // Free Returned Response
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    ////////////////////////////////////////////
    // GetHostByName
    ////////////////////////////////////////////


    rval = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww.comwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww" );
    if ( rval == false )
    {
        NN_LOG( "GetHostByName Failed with h_errno: %d, errno: %d\n", *(nn::socket::GetHError() ), nn::socket::GetLastError() );

        // Test Failed
        nTestsFailing++;
    }

        return;
}


static int
Name_Server_Unresponsive_UDP( void *              inArg,
                              unsigned char *     dnsRqst,
                              size_t &            dnsRqstLen,
                              unsigned char *     dnsResp,
                              size_t &            dnsRespLen,
                              bool *              isUDP,
                              bool *              shouldContinue )
{

    // UDP: No response sent to Client
    *shouldContinue = false;

    return( 0 );
}

static int
Name_Server_Unresponsive_TCP( void *              inArg,
                              unsigned char *     dnsRqst,
                              size_t &            dnsRqstLen,
                              unsigned char *     dnsResp,
                              size_t &            dnsRespLen,
                              bool *              isUDP,
                              bool *              shouldContinue )
{
    LoopbackDnsServer *       thisObj = (LoopbackDnsServer *) inArg;

    // Process UDP normally
    if ( *isUDP == true )
    {
        return( thisObj->MakeDnsResponseCB( thisObj, dnsRqst, dnsRqstLen, dnsResp, dnsRespLen, isUDP, shouldContinue )  );
    }

    // TCP: No response sent to Client
    *shouldContinue = false;

    return( 0 );
}


TEST(ApiUnit,DnsResponse_Name_Server_Unresponsive)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval;

    // Normal DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB(  g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB(  g_loopbackDnsServer->MakeDnsResponseCB );

    // UDP: cisum.org with the TC bit set
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Response505_part1;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Response505_part1 );

    ///////////////////
    // UDP: No Reply to GetAddrInfo
    ///////////////////

    g_loopbackDnsServer->SetDNSResponseCB( Name_Server_Unresponsive_UDP);

    NN_LOG( "UDP: GetAddrInfo() -- No Reply\n" );

    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );

    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    ///////////////////
    // TCP: Connect - but No Reply to GetAddrInfo()
    ///////////////////

    g_loopbackDnsServer->SetDNSResponseCB( Name_Server_Unresponsive_TCP );

    NN_LOG( "TCP: GetAddrInfo() -- No Reply\n" );

    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );

    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );

    // Test Passed
    nTestsPassing++;

    ///////////////////
    // UDP: No Reply to GetHostByName()
    ///////////////////

    g_loopbackDnsServer->SetDNSResponseCB( Name_Server_Unresponsive_UDP );

    NN_LOG( "UDP: GetHostByName() -- No Reply\n" );
    rval = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org" );
    nTestsPassing++;

    ///////////////////
    // TCP: Connect - but No Reply to GetHostByName()
    ///////////////////

    g_loopbackDnsServer->SetDNSResponseCB( Name_Server_Unresponsive_TCP );

    NN_LOG( "TCP: GetHostByName() -- No Reply\n" );
    rval = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org" );
    NN_LOG( "out_error: %d\n", out_error );

    // Test Passed
    nTestsPassing++;

    return;
}


static int
Keep_Sending_UDP( void *              inArg,
                  unsigned char *     dnsRqst,
                  size_t &            dnsRqstLen,
                  unsigned char *     dnsResp,
                  size_t &            dnsRespLen,
                  bool *              isUDP,
                  bool *              shouldContinue )
{
    int                    idx, rc;
    LoopbackDnsServer *    thisObj = (LoopbackDnsServer *) inArg;

    // UDP: No response sent to Client
    *shouldContinue = false;

    // For I = 1 to 60 seconds
    g_loopbackDnsServer->recvAddrSize = sizeof( nn::socket::SockAddrIn );
    for( idx = 0; idx < 1000; idx++ )
    {

        rc = Too_Big_Legal_Buffer_UDP( thisObj, dnsRqst, dnsRqstLen, dnsResp, dnsRespLen, isUDP, shouldContinue );
        if ( rc < 0 )
        {
            NN_LOG( "[Keep_Sending_to_UDP]: SendTo(): Failed - errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }

        // Space the sends out by 1 second
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
    }

out:

    return( 0 );
}


TEST(ApiUnit,DnsResponse_Keep_Sending_to_UDP)
{
    nn::socket::AddrInfo   *out_resp = nullptr;
    nn::socket::AiErrno     out_error = nn::socket::AiErrno::EAi_Success;
    bool                    rval;

    // (Override) DNS Rqst/Resp Parsers
    g_loopbackDnsServer->SetDNSRequestCB(   g_loopbackDnsServer->MakeDnsRequestCB );
    g_loopbackDnsServer->SetDNSResponseCB(  Keep_Sending_UDP );

    // UDP: cisum.org with the TC bit see
    g_loopbackDnsServer->UDPResponse = (unsigned char *) Google_com_simple;
    g_loopbackDnsServer->UDPResponseLen = sizeof( Google_com_simple );

    // Get GetAddrInfo()

    ///////////////////
    // UDP: No Reply to GetAddrInfo
    ///////////////////

    NN_LOG( "UDP: GetAddrInfo() -- No Reply\n" );
    rval = CallGetAddrInfo( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org", out_resp, &out_error );
    NN_LOG( "out_error: %d\n", out_error );
    if ( rval == true )  nn::socket::FreeAddrInfo( out_resp );
    nTestsPassing++;

    ///////////////////
    // UDP: No Reply to GetHostByName()
    ///////////////////

    NN_LOG( "UDP: GetHostByName() -- No Reply\n" );
    rval = CallGetHostByName( "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwxx.cisum.org" );
    nTestsPassing++;

}


TEST(ApiUnit,DnsResponse_Teardown)
{
    TeardownTesting();
}

#else // Windows

TEST(ApiUnit,DnsResponse_Window)
{
    NN_LOG( "=============================================\n" );
    NN_LOG( "===  N O   T E S T s   T O    R U N \n" );
    NN_LOG( "=============================================\n" );
}

#endif

}}  // Namespace: NATF::API
