﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////
// DEFAULT: ENABLE_FAILING_TESTS - DISABLED
//
// #define ENABLE_FAILING_TESTS

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include <cstdio>     // sprintf
#include <cctype>     // isprint
#include <cstdlib>    // malloc
#include <cmath>      // abs

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nn/socket.h>
#include <nn/socket/socket_ApiPrivate.h>

#include <nnt/nntest.h>

#include <nn/os/os_Thread.h>

#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiIpAddress.h>          // nn::nifm::GetCurrentIpConfigInfo
#include <nn/nifm.h>

#include "Unit/testNet_ThreadedTest.h"          // Threads for testing
#include "Unit/testNet_EchoServer.h"            // TCP / UDP echo server
#include "Unit/testNet_CommonFunctions.h"       // Common Functions


namespace NATF {
namespace API {

//////////////////////////////////////////////////////////////
//
// I M P O R T A N T:  This testing is *ONLY* for NX.  These tests do not work on Windows
//
//////////////////////////////////////////////////////////////

#ifndef NN_BUILD_CONFIG_OS_WIN32


//*********************
//*  G L O B A L S
//*********************


static bool
InitializeTesting()
{
    bool        isSuccess = true;

    NN_LOG( "In\n\n" );

    ///////////////////////////
    //// Test Counts: Initialize
    ///////////////////////////

    INITIALIZE_TEST_COUNTS;


    ///////////////////////////
    //// NIFM Library: Initialize
    ///////////////////////////

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Nifm | NATF::API::TestSetupOptions_Socket), "TestSetup failed.");

    // NIFM: Network Interface is Online
    NN_LOG( "====================================\n" );
    NN_LOG( "NIFM: Network ===>  O N L I N E <===\n" );
    NN_LOG( "====================================\n" );


    return( true );

out:


    return( false );
}


static bool
TeardownTesting()
{
     bool    isSuccess = true;

    ////////////////////
    ////  Stop Testing
    ////////////////////

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed.");

    ////////////////////
    ////  Print Test Counts
    ////////////////////

    PRINT_TEST_COUNTS;

    EXPECT_EQ( isSuccess, true );

    NN_LOG( "Out\n\n" );

    return( true );

out:

    return( false );
}



////////////////
//
// B E G I N   T E S T I N G
//
////////////////

TEST(ApiUnit,Close_Initialize)
{
    InitializeTesting();
}


TEST(ApiUnit,Close_Various)
{
    nn::socket::SockAddrIn  localAddr = { 0 };
    int                     tcpSock = -1, tcpServSock = -1, acceptedSock = -1, udpSock = 1, udpServSock = -1, rc;
    bool                    isSuccess = true;
    unsigned char           buf1[32767];

    ///////////////
    // Clear Warnings
    //////////////

    memset( buf1, 0, sizeof( buf1 ) );
    memset( &localAddr, 0, sizeof( localAddr ) );
    acceptedSock = -1;


    ///////////////
    // TCP - Normal Close
    //////////////

    tcpSock = nn::socket::Socket( nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp );
    ERROR_IF( tcpSock < 0, "Failed creating TCP socket - errno: %d\n", nn::socket::GetLastError() );

    rc = nn::socket::Close( tcpSock );
    ERROR_IF_AND_COUNT( rc != 0, "Close failed closing a TCP connection - errno: %d\n", nn::socket::GetLastError() );


    ///////////////
    // UDP - Normal Close
    //////////////

    udpSock = nn::socket::Socket( nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Dgram, nn::socket::Protocol::IpProto_Udp );
    ERROR_IF( udpSock < 0, "Failed creating UDP socket - errno: %d\n", nn::socket::GetLastError() );

    rc = nn::socket::Close( udpSock );
    ERROR_IF_AND_COUNT( rc != 0, "Close failed closing a UDP connection - errno: %d\n", nn::socket::GetLastError() );


    ///////////////
    // nn::socket::Errno::EBadf
    //////////////

    rc = nn::socket::Close( -1 );
    ERROR_IF_AND_COUNT( rc == 0, "Close on bad file descriptor succeeded but should have failed!" );
    ERROR_IF_AND_COUNT( nn::socket::GetLastError() != nn::socket::Errno::EBadf, "Expected errno nn::socket::Errno::EBadf, but actually got: %d\n", nn::socket::GetLastError() );


#ifdef COMMENTED_OUT

    ///////////////
    // TCP - nn::socket::Errno::EConnReset
    //////////////

    // TCP Server
    tcpServSock = nn::socket::Socket( nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp );
    ERROR_IF( tcpServSock < 0, "Failed creating TCP Server socket - errno: %d\n", nn::socket::GetLastError() );

    // TCP Server: Target Address
    memset(&localAddr, 0, sizeof(localAddr));
    localAddr.sin_port        = nn::socket::InetHtons( 9060 );
    localAddr.sin_family      = nn::socket::Family::Af_Inet;

    // Translate Target IP Address into Network Address
    rc = nn::socket::InetPton( nn::socket::Family::Af_Inet, "127.0.0.1", &localAddr.sin_addr.S_addr );
    ERROR_IF( rc != 1, "InetPton() Failed but Success was expected!" );

    // Bind TCP Server
    rc = nn::socket::Bind( tcpServSock, (nn::socket::SockAddr *) &localAddr, sizeof( localAddr ) );
    ERROR_IF( rc != 0, "Bind() Failed but Success was expected!  errno: %d\n", nn::socket::GetLastError() );

    // Listen TCP Server
    rc = nn::socket::Listen( tcpServSock, 5 );
    ERROR_IF( rc != 0, "Listen() Failed but Success was expected!  errno: %d\n", nn::socket::GetLastError() );

    // TCP Client - Connect
    tcpSock = NATF::API::COMMON::MakeTCPConnection( "127.0.0.1", 9060 );
    ERROR_IF( tcpSock < 0, "Failed creating TCP Client socket - errno: %d\n", nn::socket::GetLastError() );

    // TCP Server - Accept the connection
    acceptedSock = nn::socket::Accept( tcpServSock, static_cast<nn::socket::SockAddr*>(nullptr), 0 );
    ERROR_IF( rc != 0, "Failed to accept the Connection - errno: %d\n", nn::socket::GetLastError() );

    // TCP Client - Fill TCP Send Window
    memset( buf1, '1', sizeof( buf1 ) );

    for( ; ; )
    {
        rc = nn::socket::Send( tcpSock, buf1, sizeof( buf1 ), nn::socket::MsgFlag::Msg_None );
        if ( rc < 0 )
        {
            myError = nn::socket::GetLastError();
            if ( myError == nn::socket::Errno::EAgain || myError == nn::socket::Errno::EWouldBlock )
            {
                NN_LOG( "Send would block.. TCP window full\n" );
                break;
            }
        }
    }

    // Accepted side abruptly closes
    rc = nn::socket::Shutdown( acceptedSock, nn::socket::ShutdownMethod::Shut_Rd );
    NN_LOG( "Accepted Shutdown Socket - rc: %d\n", rc );

    // Local side still wants to send data
    rc = nn::socket::Close( tcpSock );
    ERROR_IF_AND_COUNT( rc == 0, "Client Close succeeded but should have failed!\n" );
    ERROR_IF_AND_COUNT( nn::socket::GetLastError() != nn::socket::Errno::EConnReset, "Closed failed, but expected nn::socket::Errno::EConnReset - actually got: %d!\n",
                                                                                     nn::socket::GetLastError() );
    nTestsPassing++;

#endif

    return;

out:

    if ( acceptedSock > -1 )
    {
        nn::socket::Close( acceptedSock );
        acceptedSock = -1;
    }

    if ( tcpSock > -1 )
    {
        nn::socket::Close( tcpSock );
        tcpSock = -1;
    }

    if ( tcpServSock > -1 )
    {
        nn::socket::Close( tcpServSock );
        tcpSock = -1;
    }

    if ( udpSock > -1 )
    {
        nn::socket::Close( udpSock );
        udpSock = -1;
    }

    if ( udpServSock > -1 )
    {
        nn::socket::Close( udpServSock );
        udpServSock = -1;
    }
}


TEST(ApiUnit,Close_Teardown)
{
    TeardownTesting();
}

#else // Windows

TEST(ApiUnit,Close_Windows)
{
    NN_LOG( "=============================================\n" );
    NN_LOG( "===  N O   T E S T s   T O    R U N \n" );
    NN_LOG( "=============================================\n" );
}

#endif

}}  // Namespace: NATF::API
