﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "iperf_lib.h"
#include <nn/nn_Common.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Log.h>
#include <cstring>

extern "C"
{
#if !defined(NN_BUILD_CONFIG_OS_WIN32)
    const int  MemoryPoolSize = 10 * 1024 * 1024;
    uint8_t    mempool[MemoryPoolSize];
    size_t     mempoolSize = MemoryPoolSize;
#endif

    int testMain(int argc, char **argv);
}

namespace nnt {
namespace net {

int Iperf(int argC, char ** argV) NN_NOEXCEPT
{
    return testMain(argC, argV);
}

}} // namespace nnt:net
