﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <NetTest/Horizon/NetTest_OS.h>
#include <nn/util/util_Uuid.h>
#include <stdint.h>

namespace nn {
namespace nifm {
class NetworkConnection;
}}

namespace NATF {
namespace Utils {

enum class InitApiFlags : uint32_t
{
    InitApiFlags_None         = 0,
    InitApiFlags_Nifm         = 1,
    InitApiFlags_Network      = 2, // Network requires Nifm to be initialized.
    InitApiFlags_Socket       = 4,
    InitApiFlags_Ssl          = 8,
    InitApiFlags_Curl         = 16,
    InitApiFlags_All          = 0xFFFFFFFF,
};

inline InitApiFlags operator & (InitApiFlags lOption, InitApiFlags rOption)
{
    return static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) & static_cast<uint32_t>(rOption)));
}

inline InitApiFlags operator | (InitApiFlags lOption, InitApiFlags rOption)
{
    return static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) | static_cast<uint32_t>(rOption)));
}

inline InitApiFlags& operator &= (InitApiFlags &lOption, InitApiFlags rOption)
{
    lOption = static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) & static_cast<uint32_t>(rOption)));
    return lOption;
}

inline InitApiFlags& operator |= (InitApiFlags &lOption, InitApiFlags rOption)
{
    lOption = static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) | static_cast<uint32_t>(rOption)));
    return lOption;
}

inline InitApiFlags operator * (InitApiFlags lOption, bool rOption)
{
    return static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) * static_cast<uint32_t>(rOption)));
}

inline InitApiFlags operator * (bool lOption, InitApiFlags rOption)
{
    return static_cast<InitApiFlags>((static_cast<uint32_t>(lOption) * static_cast<uint32_t>(rOption)));
}

class InitApi
{
public:

    explicit InitApi(InitApiFlags apisToInit) NN_NOEXCEPT;
    ~InitApi() NN_NOEXCEPT;

    bool Init(const nn::util::Uuid& netProfile = nn::util::InvalidUuid) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

private:
    const InitApiFlags m_apisToInit;
    InitApiFlags m_apisAreInit;
    nn::nifm::NetworkConnection* m_pNifmConnection;
};

}} // Namespaces NATF::Utils
