﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/ResolverApiModule.h"

namespace NATF {
namespace Tests {

    class ResolverGetNameInfoTest : public BaseTest
    {
        NN_DISALLOW_COPY(ResolverGetNameInfoTest);

    public:
        ResolverGetNameInfoTest(const char* testName, const nn::util::Uuid& netProfile) NN_NOEXCEPT;
        virtual ~ResolverGetNameInfoTest() NN_NOEXCEPT NN_OVERRIDE;

        void CheckNoError() NN_NOEXCEPT;
        void CheckEaiAgain() NN_NOEXCEPT;
        void CheckEaiBadflags() NN_NOEXCEPT;
        void CheckEaiFail() NN_NOEXCEPT;
        void CheckEaiFamilyWithUnrecognizedAddressFamily() NN_NOEXCEPT;
        void CheckEaiFamilyWithInvalidAddressLength() NN_NOEXCEPT;
        void CheckEaiMemory() NN_NOEXCEPT;
        void CheckEaiNonameWithNoArgs() NN_NOEXCEPT;
        void CheckEaiNonameWithNiNamereqd() NN_NOEXCEPT;
        void CheckEaiOverflow() NN_NOEXCEPT;
        void CheckEaiSystem() NN_NOEXCEPT;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        Modules::ResolverApiModule *m_pResolverApiModule;
    };

} // namespace Tests
} // namespace NATF
