﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/ResolverApiModule.h"

namespace NATF {
namespace Tests {

    class ResolverGetAddrInfoTest : public BaseTest
    {
        NN_DISALLOW_COPY(ResolverGetAddrInfoTest);

    public:
        ResolverGetAddrInfoTest(const char* testName, const nn::util::Uuid& netProfile) NN_NOEXCEPT;
        virtual ~ResolverGetAddrInfoTest() NN_NOEXCEPT NN_OVERRIDE;

        void CheckNoError() NN_NOEXCEPT;
        void CheckEaiAddrfamily() NN_NOEXCEPT;
        void CheckEaiAgain() NN_NOEXCEPT;
        void CheckEaiBadflagsWithInvalidFlags() NN_NOEXCEPT;
        void CheckEaiBadflagsWithAiCanonname() NN_NOEXCEPT;
        void CheckEaiFail() NN_NOEXCEPT;
        void CheckEaiFamily() NN_NOEXCEPT;
        void CheckEaiMemory() NN_NOEXCEPT;
        void CheckEaiNodata() NN_NOEXCEPT;
        void CheckEaiNonameWithUnknownArgs() NN_NOEXCEPT;
        void CheckEaiNonameWithNullArgs() NN_NOEXCEPT;
        void CheckEaiNonameWithAiNumericserv() NN_NOEXCEPT;
        void CheckEaiService() NN_NOEXCEPT;
        void CheckEaiSocktype() NN_NOEXCEPT;
        void CheckEaiSystem() NN_NOEXCEPT;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        Modules::ResolverApiModule *m_pResolverApiModule;
    };

} // namespace Tests
} // namespace NATF
