﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"
#include "Utils/md5.h"
#include <nn/ssl/ssl_Connection.h> // For nn::ssl::Connection::VerifyOption

namespace NATF {
namespace Modules {

class SslHttpsDownload : public BaseModule
{
    NN_DISALLOW_COPY(SslHttpsDownload);

public:
    SslHttpsDownload(bool doInit, const char* pHostName, unsigned short port, const char* pResource, bool printResource, const MD5Hash::Result& expectedHash, bool isBlockingIo, nn::ssl::Connection::VerifyOption verifyOption) NN_NOEXCEPT;
    virtual ~SslHttpsDownload() NN_NOEXCEPT override {}

    virtual bool Run() NN_NOEXCEPT override;
    virtual const char* GetName() const NN_NOEXCEPT override;

private:
    bool m_doInit;
    const char* m_pHostName;
    unsigned short m_port;
    const char* m_pResource;
    bool m_printResource;
    const MD5Hash::Result& m_expectedHash;
    bool m_isBlocking;
    nn::ssl::Connection::VerifyOption m_verifyOption;

    static const uint32_t MaxIpStrLen = 16;

    bool Init() NN_NOEXCEPT;
    void CleanUp() NN_NOEXCEPT;
    bool ConfigSslContext(nn::ssl::Context* pOutContext) const NN_NOEXCEPT;
    bool ConfigSslConnection(nn::ssl::Connection* pOutConnection, nn::ssl::Context* pInContext, int socketFd, const char* pHostName, char* pServerCertBuff, uint32_t serverCertBuffLen, nn::ssl::Connection::VerifyOption verifyOption) const NN_NOEXCEPT;

    bool GetServerPage(const char* pHostName, unsigned short serverPort, const char* pResource, MD5Hash::Result& hashResult) const NN_NOEXCEPT;
    bool ReceiveResponse(nn::ssl::Connection& sslConnection, MD5Hash::Result& hashResult) const NN_NOEXCEPT;
    char* ParseHeader(char* pBuffer, unsigned bufSize, bool& isLastNewLine, bool& isHeaderComplete) const NN_NOEXCEPT;
    bool ConnectToServer(int socketFd, const char* pHostName, unsigned short portNum) const NN_NOEXCEPT;
    int CreateSocketWithOptions() const NN_NOEXCEPT;
    bool SendHttpRequest(nn::ssl::Connection& sslConnection, const char* pResource, const char* pHostName) const NN_NOEXCEPT;
    void InetNtoP(int32_t ipAddr, char pOutIp[MaxIpStrLen]) const;
};

}
}
