﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"

namespace NATF {
namespace Modules {

class ResolverApiModule : public BaseModule
{
    NN_DISALLOW_COPY(ResolverApiModule);

public:
    static const int RUN_MODE_DEFAULT = 0;
    static const int RUN_MODE_UNTIL_EAI_MEMORY = 1;

    static const int gaiResOverrideAiFlags       = 1;
    static const int gaiResOverrideAiFamily      = 2;
    static const int gaiResOverrideAiSocktype    = 4;
    static const int gaiResOverrideAiProtocol    = 8;
    static const int gaiResOverrideAiAddrlen     = 16;
    static const int gaiResOverrideAiAddr        = 32;
    static const int gaiResOverrideAiCanonname   = 64;
    static const int gaiResOverrideAiNext        = 128;

    static const int MAX_NUM_TESTS = 16;
    static const int MAX_CHARS_IN_STR = 256;

    typedef struct
    {
        char in[MAX_CHARS_IN_STR];
        char out[MAX_CHARS_IN_STR];
        char expec[MAX_CHARS_IN_STR];
    } gniArgBufferType;

    typedef struct
    {
        char* ptr;
        int len;
    } gniArgType;

    typedef struct
    {
        gniArgType in;
        gniArgType out;
        gniArgType expec;
    } argTestType;

    typedef struct
    {
        nn::socket::AddrInfo info;
        int flags;
    } gaiResOverrideType;

    ResolverApiModule(
        int NumTests, const char **TestDesc, const argTestType *Host, const argTestType *Serv,
        nn::socket::AddrInfo *GaiHints, gaiResOverrideType *GaiResOverride,
        nn::socket::AiErrno GaiRvExpec, int FlagsIn, nn::socket::AiErrno GniRvExpec) NN_NOEXCEPT;
    virtual ~ResolverApiModule() NN_NOEXCEPT override {}

    virtual bool Run() NN_NOEXCEPT override;
    virtual const char* GetName() const NN_NOEXCEPT override;

    bool RunTestScenario() NN_NOEXCEPT;
    bool RunTestScenarioUntilEaiMemory() NN_NOEXCEPT;
    void SetRunMode(int RunMode) NN_NOEXCEPT;
    void OverrideGaiRes(nn::socket::AddrInfo *gaiRes) NN_NOEXCEPT;
    bool FreeOrStoreGaiRes(nn::socket::AddrInfo *gaiRes, bool freeGaiRes) NN_NOEXCEPT;
    bool FreeGaiResHistory() NN_NOEXCEPT;

private:
    int m_NumTests;
    char m_TestDesc[MAX_NUM_TESTS][MAX_CHARS_IN_STR];
    argTestType m_Host[MAX_NUM_TESTS];
    argTestType m_Serv[MAX_NUM_TESTS];
    nn::socket::AddrInfo* m_pGaiHints;
    gaiResOverrideType* m_pGaiResOverride;
    nn::socket::AddrInfo m_BufferGaiHints;
    gaiResOverrideType m_BufferGaiResOverride;
    gniArgBufferType m_BufferHost[MAX_NUM_TESTS];
    gniArgBufferType m_BufferServ[MAX_NUM_TESTS];
    nn::socket::AiErrno m_GaiRvExpec;
    int m_FlagsIn;
    nn::socket::AiErrno m_GniRvExpec;
    int m_RunMode;

    void DeepCopyGniArgType(gniArgType* dst, const gniArgType* src, char buf[]);
    void LogParamsGetAddrInfo(const char* pHostIn,
        const char* pServIn, nn::socket::AddrInfo* pHints, nn::socket::AddrInfo** ppGaiRes);
    void LogResultsGetAddrInfo(nn::socket::AddrInfo **ppGaiRes, int lastGaiRv,
        int gaiRvExpec);
    void LogParamsGetNameInfo(nn::socket::SockAddr *ai_addr, nn::socket::SockLenT ai_addrlen,
        char* pHostOut, int hostOutLen,
        char* pServOut, int servOutLen, int flagsIn);
    void LogResultsGetNameInfo(char* host, char* serv,
        int gniRv, int gniRvExpec);

};

} // namespace Modules
} // namespace NATF
