﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"

namespace NATF {
namespace Modules {

class IoctlModule : public BaseModule
{
    NN_DISALLOW_COPY(IoctlModule);

public:

    enum AppType
    {
        AppType_Client = 0,
        AppType_Server = 1
    };

    enum InitType
    {
        InitType_All    = 0,
        InitType_Init   = 1,
        InitType_Socket = 2
    };

    enum TeardownType
    {
        TeardownType_Shutdown = 0,
        TeardownType_Close    = 1,
        TeardownType_All      = 2
    };

    IoctlModule( AppType app,const char * pIp, unsigned short port, InitType initType) NN_NOEXCEPT;
    virtual ~IoctlModule() NN_NOEXCEPT override {}

    virtual bool Run() NN_NOEXCEPT override;
    virtual const char* GetName() const NN_NOEXCEPT override;

private:

    enum AppErr
    {
        AppErr_Ok       = 0,
        AppErr_Continue = 1,
        AppErr_Out      = 2
    };
    struct SoTestParams
    {
        bool isNonBlocking;
        int socketRecvSize;
        int socketSendSize;
        NetTest::SockAddrIn remoteAddr;
        NetTest::SockLen addrLen;

        AppType appType;
        const char* pIp;
        unsigned short port;
        int backLog;
        int socketFd;
        TeardownType teardownType;
        nn::socket::ShutdownMethod shutdownType;
        int duration;
        unsigned bufferSize;

        InitType initType;
        nn::socket::Type socketType;
        nn::socket::Protocol socketProtocol;
        nn::socket::Family socketFamily;
        nn::socket::MsgFlag xferOptions;
        const char* pTestName;
        nn::socket::Errno expectedInitErr;
        nn::socket::Errno expectedSetupErr;
        nn::socket::Errno expectedXferErr;
        nn::socket::Errno expectedTeardownErr;

        bool serverFull;
        bool clientHalf;
        bool clientFull;
    };

    static const unsigned MaxBufSize = 2 * 1024;

    bool Teardown(nn::socket::Errno expectedErr) NN_NOEXCEPT;
    bool Init(nn::socket::Errno expectedErr) NN_NOEXCEPT;
    bool Setup(nn::socket::Errno expectedErr) NN_NOEXCEPT;
    bool DataXfer(nn::socket::Errno expectedErr) NN_NOEXCEPT;
    bool SetOpt() NN_NOEXCEPT;

    AppErr IoctlCheck(const char * checkID);

    AppErr ServerTcp(unsigned& totalSent, unsigned& totalRecvd, const char* sendBuffer, char* recvBuffer, nn::socket::Errno expectedErr) NN_NOEXCEPT;
    AppErr ClientTcp(unsigned& totalSent, unsigned& totalRecvd, const char* sendBuffer, char* recvBuffer, nn::socket::Errno expectedErr) NN_NOEXCEPT;

    struct SoTestParams m_params;
};

}
}
