﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"

#include <nn/nn_Macro.h>
#include <nn/TargetConfigs/build_Base.h>

#ifndef NN_BUILD_CONFIG_OS_WIN32
    #error "This is only supported by Win32"
#else

#define _WIN32_WINDOWS 0 // NOLINT(readability/define)
#include "windows.h"
#include "TCHAR.h"
#include "pdh.h"

namespace NATF {
namespace Modules {

class CpuUsage : public BaseModule
{
private:
    NN_DISALLOW_COPY(CpuUsage);

public:

    explicit CpuUsage(uint32_t printFreqMs) NN_NOEXCEPT;
    virtual ~CpuUsage() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool Run() NN_NOEXCEPT NN_OVERRIDE;
    virtual void StopSlave() NN_NOEXCEPT NN_OVERRIDE;
    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE;

    double GetCurrentUsage() const NN_NOEXCEPT;

private:

    bool m_doShutdown;
    uint32_t m_printFreqMs;
    PDH_HQUERY m_cpuQuery;
    PDH_HCOUNTER m_cpuTotal;
};

}}

#endif // Win32
