﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/socket.h>

#include "Complex/testNet_UnitCommon.h"
#include "Complex/testNet_UnitCommonSocket.h"
#include "Complex/testNet_SelectUnitData.h"
#include "Complex/testNet_SelectUnitNetworkCommon.h"

namespace NATF {
namespace API {
/**
 * @brief the client thread
 */
class SelectUnitClient :
        public virtual UnitTestThreadBase,
        public virtual SelectUnitNetworkCommon
{
public:
    /** ctor */
    NN_IMPLICIT SelectUnitClient(SelectUnitData* pSelectUnitData);

protected:
    /** dtor */
    virtual ~SelectUnitClient();

    /** @brief run the thread */
    virtual void Run();

    /** @brief function to initialize sockets */
    virtual void InitializeSockets(SocketContainer& container);

    /** @brief initialize the sockets */
    virtual bool EarlyBlockingInitialize(nn::os::SemaphoreType& BlockingSemaphore);

    virtual int OnNewConnectionEvent(SocketContainer& container);

    virtual int OnEmbryonicReadEvent(SocketContainer& container);

    virtual int OnReadEvent(SocketContainer& container);

    virtual int OnWriteEvent(SocketContainer& container);

    virtual int OnExceptionEvent(SocketContainer& container);

private:

    /** @brief the name of this class */
    char m_SelectUnitClientName[API_UNIT_STRING_MAX];
};

}}; // NATF::API
