$ErrorActionPreference = "stop"

$seed = Get-Random
$msg = "Seed is " + $seed
echo $msg
$rand = New-Object System.Random $seed

$size = 128 * 1024
$src = New-Object byte[] $size

if (Test-Path Env:TEMP) {
    $source = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\source.bin")
    $destination = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\expected.bin")
    $patch = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\patch.bdiff")
} else {
    if (Test-Path Env:TMP) {
        $source = [System.Environment]::ExpandEnvironmentVariables("%TMP%\source.bin")
        $destination = [System.Environment]::ExpandEnvironmentVariables("%TMP%\expected.bin")
        $patch = [System.Environment]::ExpandEnvironmentVariables("%TMP%\patch.bdiff")
    } else {
        $source = "C:\Windows\Temp\source.bin"
        $destination = "C:\Windows\Temp\expected.bin"
        $patch = "C:\Windows\Temp\patch.bdiff"
    }
}

$rand.NextBytes($src)
[System.IO.File]::WriteAllBytes($source, $src)

$decrease = $rand.Next(4096, 16384)
$new_size = $size - $decrease
$src2 = New-Object byte[] $new_size

[System.Array]::Copy($src, 0, $src2, 0, $new_size)

$try = $new_size / 20
for ($i = 0; $i -lt $try; ++$i) {
	$index = $rand.Next(1, $new_size)
	$src2[$index - 1] = $rand.Next(0, 255)
}
[System.IO.File]::WriteAllBytes($destination, $src2)

$auth = [System.Environment]::ExpandEnvironmentVariables("%NINTENDO_SDK_ROOT%/Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe")
& $auth bdiff --source $source --destination $destination --command-size-max 65536 -o $patch

