﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#ifndef NV_VIDEO_ENCODER_H_

#define NV_VIDEO_ENCODER_H_

#include <utils/Log.h>
//#include <binder/IPCThreadState.h>
#include <utils/Errors.h>
#include <utils/Timers.h>
#include <utils/Trace.h>
#include <gui/surface.h>
#include <gui/SurfaceComposerClient.h>
#include <gui/ISurfaceComposer.h>
#include <ui/DisplayInfo.h>
#include <media/openmax/OMX_IVCommon.h>
#include <media/stagefright/foundation/ABuffer.h>
#include <media/stagefright/foundation/AMessage.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaSource.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/ICrypto.h>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>

#include "fAudioSource.h"
#include "NvMediaRecorder.h"

//#define ENABLE_LOG

#ifdef ENABLE_LOG
    #define NN_LOG_V NN_LOG
#else
    #define NN_LOG_V(format, args...) ((void)0)
#endif

#define NN_LOG_E NN_LOG

using namespace android;

typedef void (*fnEvent) (uint32_t event);

class NvVideoEncoder {
public:
    NvVideoEncoder(uint32_t width, uint32_t height,
                    uint32_t framerate, uint32_t noOfRecFrame);

    ~NvVideoEncoder();

    class VideoRecordThread : public android::Thread
    {
    public:
        NvVideoEncoder *mEncoder;
        Mutex mLock;
        virtual bool threadLoop();
        virtual void requestExit();
    };

    const char* kMimeTypeAvc;
    uint32_t gVideoWidth;
    uint32_t gVideoHeight;
    uint32_t gBitRate;
    uint32_t gFrameRate;
    uint32_t gNumFrameRecord;
    bool gVideoDone;
    bool mStopCalled;

    fnEvent mEventCallback;

    Condition mCondition;

    sp<IGraphicBufferProducer> mProducer = NULL;
    sp<MediaCodec> mVideoEncoder;

    NvMediaRecorder *mMediaRecorder;

    android::sp<VideoRecordThread> mVideoThread;

    volatile bool gStopRequested;

    status_t start(NvMediaRecorder *aRecorder, fnEvent evenClk);
    status_t stop();

    status_t runVideoEncoder(const sp<MediaCodec>& encoder,
                                    const sp<MediaMuxer>& muxer) ;
    sp<MediaCodec> prepareVideoEncoder();
};

//    android::sp<AudioRecordThread> mAudioThread;

#endif //NV_AUDIO_ENCODER_H_
