﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#define LOG_TAG "MemoryAllocator"

//#define LOG_NDEBUG  0

#include "MemoryAllocator.h"
#include "nvos.h"
#include "mm_MemoryManagement_private.h"


//#define ENABLE_LOG

#ifdef ENABLE_LOG
    #define NN_LOG_V NN_LOG
#else
    #define NN_LOG_V(format, args...) ((void)0)
#endif

#define NN_LOG_E NN_LOG

MemoryAllocator::MemoryAllocator() {
    mTotalSize = 0;
    mFilledSize = 0;
    mAllocIndex = 0;
    mFreeIndex = 0;
    mCurrentOffset = 0;
    mFreeSize = 0;
}

MemoryAllocator::~MemoryAllocator() {
    NN_LOG_V("MemoryAllocator instance destroyed\n\n");
    nv::mm::Free(mMemHandle);
}

uint8_t * MemoryAllocator::init(uint32_t allocSize) {
    if (allocSize > 0) {
        mMemHandle = (uint8_t *)nv::mm::Alloc(allocSize);
        if (mMemHandle == NULL) {
            NN_LOG_E("No sufficient memory !!!!!!\n ");
            return NULL;
        }
        NN_LOG_V("MemoryAllocator : Allocated size - %d mMemHandle - %p\n",allocSize, mMemHandle);
    } else {
        NN_LOG_E("Size to allocate is not valid - %d\n",allocSize);
        return NULL;
    }
    mFreeSize = mTotalSize = allocSize;
    mCurrentOffset = 0;
    return mMemHandle;
}

uint8_t * MemoryAllocator::getMemory(uint32_t size, uint64_t *offset, int32_t *status) {
    uint8_t *mem = mMemHandle;
    NN_LOG_V("MemoryAllocator::getMemory mCurrentOffset - %d mFilledSize - %lld\n",mCurrentOffset, mFilledSize);

    if (((mFilledSize + size) > mTotalSize) || mFreeSize <= 0)  {
        NN_LOG_E("MemoryAllocator : Memory FULL.. First free some before allocating new\n");
        //mFilledSize = 0;
        *status = MEMORY_FULL;
    } else {
        mem += mCurrentOffset;
        mFilledSize += size;
        mFreeSize -= size;
        *status = MEMORY_AVAILABLE;
        //offset = (void *) ((uint64_t) mMemHandle + size);
        NN_LOG_V("MemoryAllocator : mMemHandle - %p mem - %p size - %d\n",mMemHandle, mem, size);
    }

    mCurrentOffset += size;
    if (mCurrentOffset >= mTotalSize) {
        NN_LOG_V("MemoryAllocator : Memory offset has reach to max size mCurrentOffset - %d\n", mCurrentOffset);
        mem = mMemHandle;
        mCurrentOffset = 0;
        *status = MEMORY_FULL;
    }

    *offset = mCurrentOffset;
    return mem;
}

status_t MemoryAllocator::freeMemory(int32_t size) {
    NN_LOG_V("freeMemory size - %d\n",size);

    mFreeSize += size;
    mFilledSize -= size;

    if (mFilledSize == 0){
        NN_LOG_E("Nothing to free.. no mem blocks allocated");
        return NO_ERROR;
    }
    return NO_ERROR;
}
