﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#define NN_LOG_USE_DEFAULT_LOCALE_CHARSET

#include <cstdlib>

#include <mm_MemoryManagement.h>
#include <nnt/nntest.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/image/image_ExifExtractor.h>
#include <nn/image/image_JpegDecoder.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/init.h>
#include <cstdio>
#include "AVIExtractor.h"
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <cerrno>
#include <nv/nv_MemoryManagement.h>

#include "Utilities.h"

#if 1

namespace{

    const int FsHeapSize = 512 * 1024;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }

}

namespace // 'unnamed'
{
nn::mem::StandardAllocator g_MultimediaAllocator;
}

void MMCreateAllocator()
{
    const int allocatorSize = 512 << 20;
    static char s_MMAllocatorBuffer[allocatorSize];
    g_MultimediaAllocator.Initialize(s_MMAllocatorBuffer, sizeof(s_MMAllocatorBuffer));
}

void MMDestroyAllocator()
{
    g_MultimediaAllocator.Finalize();
}

void *MMAlloc(size_t size, size_t alignment, void*)
{
    return g_MultimediaAllocator.Allocate(size, alignment);
}

void MMFree(void *p, void*)
{
    g_MultimediaAllocator.Free(p);
}

void *MMRealloc(void *p, size_t newSize, void*)
{
    return g_MultimediaAllocator.Reallocate(p, newSize);
}

//----------------------------------------------------------
// nninitStartup() is invoked before calling nnMain().
//----------------------------------------------------------

extern "C" void nninitStartup()
{
    #if 1
    const size_t heapSize = 128 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    //NN_SDK_LOG("\ninit done: \n");
    #endif
}


static void displayUsage()
{
    NN_SDK_LOG("usage: %s --in <file> --out <Output file Path> [--no-output-files]\n", nn::os::GetHostArgv()[0]);
}

/* Process main entry */
TEST(MjpegPlaybackTest, Video)
{
    MMCreateAllocator();
    NN_SDK_LOG("Calling nv::mm::SetAllocator\n");
    nv::mm::SetAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    NN_SDK_LOG("Calling nv::SetGraphicsAllocator\n");
    nv::SetGraphicsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    NN_SDK_LOG("Calling nv::SetGraphicsDevtoolsAllocator\n");
    nv::SetGraphicsDevtoolsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    const int mmFirmwareMemorySize = 8 << 20;
    NN_ALIGNAS(4096) static char s_mmFirmwareMemory[mmFirmwareMemorySize];
    NN_SDK_LOG("Calling nv::InitializeGraphics\n");
    nv::InitializeGraphics(s_mmFirmwareMemory, sizeof(s_mmFirmwareMemory));
    int argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();
    const char* inputFileName = 0;
    char* outFilePath = 0;
    bool noOutputFiles = false;

    for (int i = 1; i < argc; i++)
    {
        if(!strcmp(argv[i], "--no-output-files")){
            noOutputFiles = true;
            continue;
            }
        if(argc - i < 1)
            break;
        if(!strcmp(argv[i], "--in"))
            inputFileName = argv[++i];
        else if(!strcmp(argv[i], "--out")){
            outFilePath = (char*)malloc(strlen(argv[++i]) + 1);
            strcpy(outFilePath, argv[i]);
            }
        else
        {
            displayUsage();
            return;
        }
    }
    if(!inputFileName || !(outFilePath || noOutputFiles))
    {
        displayUsage();
        return;
    }
    bool sdcardMounted = false;
    const char* token = "sdcard";
    int compare = strncmp(inputFileName, token, strlen(token));
    if (compare == 0)
    {
        nn::Result resultSdcardMount = nn::fs::MountSdCardForDebug("sdcard");
        if (resultSdcardMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::SD card Mount failure. Module:%d, Description:%d\n",
                    resultSdcardMount.GetModule(),
                    resultSdcardMount.GetDescription());
            return;
        }
        sdcardMounted = true;
    }
    else
    {
        nn::Result resultHostMount = nn::fs::MountHostRoot();
        if (resultHostMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::Host root mount failure.\n",
                    resultHostMount.GetModule(),
                    resultHostMount.GetDescription());
            return;
        }

    }

    FILE* file = fopen(inputFileName, "r");
    if (file == NULL)
    {
        NN_LOG("fopen(%s) failed with :=%d\n",inputFileName,errno);
        perror(0);
        return;
    }
    parse_riff(file, outFilePath);
    fclose(file);

    if (sdcardMounted == true)
    {
        nn::fs::Unmount("sdcard");
    }
    else
    {
        nn::fs::UnmountHostRoot();
    }
    MMDestroyAllocator();
    return;


}
#endif

