﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "HeapTracker.h"
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>


HeapTracker::HeapTracker() : m_mutex(true), m_creationTime(nn::os::GetSystemTick()), m_total(0), m_maxSize(0), m_id(0)
{
    memset(m_infoUsed, 0, sizeof(m_infoUsed));

}

void HeapTracker::Track(void *memory, size_t size)
{
    // m_mutex.Lock();
    for(int i = 0; i < m_maxAllocations; ++i)
    {
        if(!m_infoUsed[i])
        {
            m_infos[i] = AllocationInfo(size, m_id++, memory);
            m_infoUsed[i] = true;
            break;
        }
    }
    m_total += size;
    m_maxSize = std::max(m_maxSize, m_total);
    // m_mutex.Unlock();
}

void HeapTracker::Untrack(void *memory)
{
    if(!memory)
        return;
    // m_mutex.Lock();
    AllocationInfo *info = NULL;
    for(int i = 0; i < m_maxAllocations; ++i)
    {
        if(m_infos[i].m_address == memory)
        {
            info = m_infos + i;
            m_infoUsed[i] = false;
            break;
        }
    }
    NN_ASSERT_NOT_NULL(info);
    m_total -= info->m_size;
    // m_mutex.Unlock();
}

void HeapTracker::OutputUsage()
{

    for(int i = 0; i < m_maxAllocations; ++i)
    {
        if(m_infoUsed[i])
        {
            AllocationInfo *info = m_infos + i;
            nn::TimeSpan t = (info->m_time - m_creationTime).ToTimeSpan();
            NN_LOG("memory: 0x%p, size: %lu, id: %lu, time: %ld.%ld\n", info->m_address, info->m_size, info->m_id, t.GetSeconds(), t.GetMilliSeconds() % 1000);
        }

    }
    NN_LOG("current size: %lu max size: %lu\n", m_total, m_maxSize);
}


HeapTracker::AllocationInfo::AllocationInfo(size_t size, size_t id, void *address) : m_size(size), m_id(id), m_address(address), m_time(nn::os::GetSystemTick())
{
}
